/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.connection.auth.Authenticator;
import com.allanbank.mongodb.error.MongoDbAuthenticationException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class Credential
implements Serializable {
    public static final String ADMIN_DB = "admin";
    public static final String KERBEROS;
    public static final String MONGODB_CR;
    public static final char[] NO_PASSWORD;
    private static final long serialVersionUID = -6251469373336569336L;
    private final String myAuthenticationType;
    private transient Authenticator myAuthenticator;
    private final String myDatabase;
    private final File myFile;
    private final char[] myPassword;
    private final String myUserName;

    public static Builder builder() {
        return new Builder();
    }

    public Credential(Builder builder) {
        this.myUserName = builder.myUserName;
        this.myDatabase = builder.myDatabase;
        this.myFile = builder.myFile;
        this.myAuthenticationType = builder.myAuthenticationType;
        this.myAuthenticator = builder.myAuthenticator;
        this.myPassword = (char[])builder.myPassword.clone();
    }

    public Authenticator authenticator() throws MongoDbAuthenticationException {
        if (this.myAuthenticator == null) {
            try {
                this.loadAuthenticator();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MongoDbAuthenticationException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MongoDbAuthenticationException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MongoDbAuthenticationException(illegalAccessException);
            }
        }
        return this.myAuthenticator.clone();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Credential credential = (Credential)object;
            bl = this.nullSafeEquals(this.myAuthenticationType, credential.myAuthenticationType) && this.nullSafeEquals(this.myDatabase, credential.myDatabase) && this.nullSafeEquals(this.myUserName, credential.myUserName) && this.nullSafeEquals(this.myFile, credential.myFile) && Arrays.equals(this.myPassword, credential.myPassword);
        }
        return bl;
    }

    public String getAuthenticationType() {
        return this.myAuthenticationType;
    }

    public Authenticator getAuthenticator() {
        return this.myAuthenticator;
    }

    public String getDatabase() {
        return this.myDatabase;
    }

    public File getFile() {
        return this.myFile;
    }

    public char[] getPassword() {
        return (char[])this.myPassword.clone();
    }

    public String getUserName() {
        return this.myUserName;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.myAuthenticationType == null ? 0 : this.myAuthenticationType.hashCode());
        n = 31 * n + (this.myDatabase == null ? 0 : this.myDatabase.hashCode());
        n = 31 * n + Arrays.hashCode(this.myPassword);
        n = 31 * n + (this.myUserName == null ? 0 : this.myUserName.hashCode());
        n = 31 * n + (this.myFile == null ? 0 : this.myFile.hashCode());
        return n;
    }

    public boolean hasPassword() {
        return this.myPassword.length > 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ username : '");
        stringBuilder.append(this.myUserName);
        stringBuilder.append("', database : '");
        stringBuilder.append(this.myDatabase);
        if (this.myFile != null) {
            stringBuilder.append("', file : '");
            stringBuilder.append(this.myFile.getName());
        }
        stringBuilder.append("', password : '<redacted>', type: '");
        if (KERBEROS.equals(this.myAuthenticationType)) {
            stringBuilder.append("KERBEROS");
        } else if (MONGODB_CR.equals(this.myAuthenticationType)) {
            stringBuilder.append("MONGODB-CR");
        } else if (this.myAuthenticationType != null) {
            stringBuilder.append(this.myAuthenticationType);
        }
        stringBuilder.append("' }");
        return stringBuilder.toString();
    }

    void loadAuthenticator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.myAuthenticator == null) {
            this.myAuthenticator = (Authenticator)Class.forName(this.getAuthenticationType()).newInstance();
        }
    }

    private boolean nullSafeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.myAuthenticator = null;
    }

    static {
        NO_PASSWORD = new char[0];
        KERBEROS = "com.allanbank.mongodb.extensions.authentication.KerberosAuthenticator";
        MONGODB_CR = "com.allanbank.mongodb.connection.auth.MongoDbAuthenticator";
    }

    public static class Builder {
        protected String myAuthenticationType;
        protected Authenticator myAuthenticator;
        protected String myDatabase;
        protected File myFile;
        protected char[] myPassword;
        protected String myUserName;

        public Builder() {
            this.reset();
        }

        public Builder authenticationType(String string) {
            return this.setAuthenticationType(string);
        }

        public Builder authenticator(Authenticator authenticator) {
            return this.setAuthenticator(authenticator);
        }

        public Credential build() {
            return new Credential(this);
        }

        public Builder database(String string) {
            return this.setDatabase(string);
        }

        public Builder file(File file) {
            return this.setFile(file);
        }

        public Builder kerberos() {
            return this.setAuthenticationType(KERBEROS);
        }

        public Builder mongodbCR() {
            return this.setAuthenticationType(MONGODB_CR);
        }

        public Builder password(char[] cArray) {
            return this.setPassword(cArray);
        }

        public Builder reset() {
            if (this.myPassword != null) {
                Arrays.fill(this.myPassword, '\u0000');
            }
            this.myAuthenticationType = MONGODB_CR;
            this.myAuthenticator = null;
            this.myDatabase = Credential.ADMIN_DB;
            this.myFile = null;
            this.myPassword = NO_PASSWORD;
            this.myUserName = null;
            return this;
        }

        public Builder setAuthenticationType(String string) {
            this.myAuthenticationType = string;
            return this;
        }

        public Builder setAuthenticator(Authenticator authenticator) {
            this.myAuthenticator = authenticator;
            return this;
        }

        public Builder setDatabase(String string) {
            this.myDatabase = string == null ? Credential.ADMIN_DB : string;
            return this;
        }

        public Builder setFile(File file) {
            this.myFile = file;
            return this;
        }

        public Builder setPassword(char[] cArray) {
            Arrays.fill(this.myPassword, '\u0000');
            this.myPassword = cArray == null ? NO_PASSWORD : (char[])cArray.clone();
            return this;
        }

        public Builder setUserName(String string) {
            this.myUserName = string;
            return this;
        }

        public Builder userName(String string) {
            return this.setUserName(string);
        }
    }
}

