/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.Credential;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.MongoDbUri;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.error.MongoDbAuthenticationException;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.ServerNameUtils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class MongoClientConfiguration
implements Cloneable,
Serializable {
    public static final String ADMIN_DB_NAME = "admin";
    public static final String DEFAULT_DB_NAME = "local";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger LOG = Logger.getLogger(MongoClientConfiguration.class.getCanonicalName());
    private static final long serialVersionUID = 2964127883934086500L;
    private boolean myAutoDiscoverServers = true;
    private int myConnectTimeout = 0;
    private final ConcurrentHashMap<String, Credential> myCredentials;
    private String myDefaultDatabase = "local";
    private Durability myDefaultDurability = Durability.NONE;
    private ReadPreference myDefaultReadPreference = ReadPreference.PRIMARY;
    private transient Executor myExecutor = null;
    private Credential myLegacyCredential;
    private LockType myLockType = LockType.MUTEX;
    private int myMaxConnectionCount = 3;
    private int myMaxPendingOperationsPerConnection = 1024;
    private long myMaxSecondaryLag = TimeUnit.MINUTES.toMillis(5L);
    private int myReadTimeout = 0;
    private int myReconnectTimeout = 0;
    private List<InetSocketAddress> myServers = new ArrayList<InetSocketAddress>();
    private transient SocketFactory mySocketFactory = null;
    private transient ThreadFactory myThreadFactory = Executors.defaultThreadFactory();
    private boolean myUsingSoKeepalive = true;

    public MongoClientConfiguration() {
        this.myCredentials = new ConcurrentHashMap();
    }

    public MongoClientConfiguration(InetSocketAddress ... inetSocketAddressArray) {
        this();
        for (InetSocketAddress inetSocketAddress : inetSocketAddressArray) {
            this.addServer(inetSocketAddress);
        }
    }

    public MongoClientConfiguration(MongoClientConfiguration mongoClientConfiguration) {
        this();
        this.myServers.addAll(mongoClientConfiguration.getServerAddresses());
        this.myAutoDiscoverServers = mongoClientConfiguration.isAutoDiscoverServers();
        this.myMaxConnectionCount = mongoClientConfiguration.getMaxConnectionCount();
        this.myMaxPendingOperationsPerConnection = mongoClientConfiguration.getMaxPendingOperationsPerConnection();
        this.myUsingSoKeepalive = mongoClientConfiguration.isUsingSoKeepalive();
    }

    public MongoClientConfiguration(MongoDbUri mongoDbUri) throws IllegalArgumentException {
        this(mongoDbUri, Durability.ACK);
    }

    public MongoClientConfiguration(String string) throws IllegalArgumentException {
        this(new MongoDbUri(string));
    }

    protected MongoClientConfiguration(MongoDbUri mongoDbUri, Durability durability) throws IllegalArgumentException {
        this();
        for (String string : mongoDbUri.getHosts()) {
            this.addServer(string);
        }
        if (this.myServers.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least 1 host to connect to.");
        }
        String string = mongoDbUri.getDatabase();
        if (!string.isEmpty()) {
            this.setDefaultDatabase(string);
        }
        if (mongoDbUri.getUserName() != null) {
            if (string.isEmpty()) {
                this.setCredentials(Arrays.asList(Credential.builder().userName(mongoDbUri.getUserName()).password(mongoDbUri.getPassword().toCharArray()).mongodbCR().build()));
            } else {
                this.setCredentials(Arrays.asList(Credential.builder().userName(mongoDbUri.getUserName()).password(mongoDbUri.getPassword().toCharArray()).database(string).mongodbCR().build()));
            }
        }
        boolean bl = false;
        int n = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(mongoDbUri.getOptions(), "?;&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n3 = string4.indexOf(61);
            if (n3 >= 0) {
                string3 = string4.substring(0, n3);
                string2 = string4.substring(n3 + 1);
            } else {
                string3 = string4;
                string2 = Boolean.TRUE.toString();
            }
            try {
                if ("replicaSet".equalsIgnoreCase(string3)) {
                    LOG.info("Not validating the replica set name is '" + string2 + "'.");
                    continue;
                }
                if ("slaveOk".equalsIgnoreCase(string3)) {
                    if (Boolean.parseBoolean(string2)) {
                        this.myDefaultReadPreference = ReadPreference.SECONDARY;
                        continue;
                    }
                    this.myDefaultReadPreference = ReadPreference.PRIMARY;
                    continue;
                }
                if ("safe".equalsIgnoreCase(string3)) {
                    bl = Boolean.parseBoolean(string2);
                    continue;
                }
                if ("w".equalsIgnoreCase(string3)) {
                    bl = true;
                    n = Integer.parseInt(string2);
                    continue;
                }
                if ("wtimeout".equalsIgnoreCase(string3)) {
                    bl = true;
                    n2 = Integer.parseInt(string2);
                    if (n >= 1) continue;
                    n = 1;
                    continue;
                }
                if ("fsync".equalsIgnoreCase(string3)) {
                    bl2 = Boolean.parseBoolean(string2);
                    if (!bl2) continue;
                    bl3 = false;
                    bl = true;
                    continue;
                }
                if ("journal".equalsIgnoreCase(string3)) {
                    bl3 = Boolean.parseBoolean(string2);
                    if (!bl3) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if ("connectTimeoutMS".equalsIgnoreCase(string3)) {
                    this.myConnectTimeout = Integer.parseInt(string2);
                    continue;
                }
                if ("socketTimeoutMS".equalsIgnoreCase(string3)) {
                    this.myReadTimeout = Integer.parseInt(string2);
                    continue;
                }
                if ("autoDiscoverServers".equalsIgnoreCase(string3)) {
                    this.myAutoDiscoverServers = Boolean.parseBoolean(string2);
                    continue;
                }
                if ("maxConnectionCount".equalsIgnoreCase(string3)) {
                    this.myMaxConnectionCount = Integer.parseInt(string2);
                    continue;
                }
                if ("maxPendingOperationsPerConnection".equalsIgnoreCase(string3)) {
                    this.myMaxPendingOperationsPerConnection = Integer.parseInt(string2);
                    continue;
                }
                if ("reconnectTimeoutMS".equalsIgnoreCase(string3)) {
                    this.myReconnectTimeout = Integer.parseInt(string2);
                    continue;
                }
                if ("useSoKeepalive".equalsIgnoreCase(string3)) {
                    this.myUsingSoKeepalive = Boolean.parseBoolean(string2);
                    continue;
                }
                LOG.info("Unknown property '" + string3 + "' and value '" + string2 + "'.");
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The '" + string3 + "' parameter must have a numeric value not '" + string2 + "'.", numberFormatException);
            }
        }
        this.myDefaultDurability = bl ? (bl2 ? Durability.fsyncDurable(n2) : (bl3 ? Durability.journalDurable(n2) : (n > 0 ? Durability.replicaDurable(n, n2) : Durability.ACK))) : durability;
    }

    public void addCredential(Credential credential) throws IllegalArgumentException {
        try {
            credential.loadAuthenticator();
            Credential credential2 = this.myCredentials.putIfAbsent(credential.getDatabase(), credential);
            if (credential2 != null) {
                throw new IllegalArgumentException("There can only be one set of credentials for each database.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not load the credentials authenticator.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not load the credentials authenticator.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not load the credentials authenticator.", illegalAccessException);
        }
    }

    public void addCredential(Credential.Builder builder) throws IllegalArgumentException {
        this.addCredential(builder.build());
    }

    public void addServer(InetSocketAddress inetSocketAddress) {
        this.myServers.add(inetSocketAddress);
    }

    public void addServer(String string) {
        this.myServers.add(ServerNameUtils.parse(string));
    }

    @Deprecated
    public void authenticate(String string, String string2) throws MongoDbAuthenticationException {
        if (this.myLegacyCredential != null) {
            this.myCredentials.remove(this.myLegacyCredential.getDatabase());
        }
        this.myLegacyCredential = Credential.builder().userName(string).password(string2.toCharArray()).database(this.getDefaultDatabase()).mongodbCR().build();
        this.addCredential(this.myLegacyCredential);
    }

    @Deprecated
    public void authenticateAsAdmin(String string, String string2) throws MongoDbAuthenticationException {
        this.addCredential(Credential.builder().userName(string).password(string2.toCharArray()).database(ADMIN_DB_NAME).mongodbCR().build());
    }

    public MongoClientConfiguration clone() {
        MongoClientConfiguration mongoClientConfiguration = null;
        try {
            mongoClientConfiguration = (MongoClientConfiguration)super.clone();
            mongoClientConfiguration.myServers = new ArrayList<InetSocketAddress>(this.getServerAddresses());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mongoClientConfiguration = new MongoClientConfiguration(this);
        }
        return mongoClientConfiguration;
    }

    public int getConnectTimeout() {
        return this.myConnectTimeout;
    }

    public Collection<Credential> getCredentials() {
        return Collections.unmodifiableCollection(this.myCredentials.values());
    }

    @Deprecated
    public String getDefaultDatabase() {
        return this.myDefaultDatabase;
    }

    public Durability getDefaultDurability() {
        return this.myDefaultDurability;
    }

    public ReadPreference getDefaultReadPreference() {
        return this.myDefaultReadPreference;
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public LockType getLockType() {
        return this.myLockType;
    }

    public int getMaxConnectionCount() {
        return this.myMaxConnectionCount;
    }

    public int getMaxPendingOperationsPerConnection() {
        return this.myMaxPendingOperationsPerConnection;
    }

    public long getMaxSecondaryLag() {
        return this.myMaxSecondaryLag;
    }

    @Deprecated
    public String getPasswordHash() {
        if (!this.myCredentials.isEmpty()) {
            Credential credential = this.myCredentials.entrySet().iterator().next().getValue();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = messageDigest.digest((credential.getUserName() + ":mongo:" + new String(credential.getPassword())).getBytes(UTF8));
                return IOUtils.toHex(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MongoDbAuthenticationException(noSuchAlgorithmException);
            }
        }
        return null;
    }

    public int getReadTimeout() {
        return this.myReadTimeout;
    }

    public int getReconnectTimeout() {
        return this.myReconnectTimeout;
    }

    public List<InetSocketAddress> getServerAddresses() {
        return Collections.unmodifiableList(this.myServers);
    }

    public List<String> getServers() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myServers.size());
        for (InetSocketAddress inetSocketAddress : this.myServers) {
            arrayList.add(ServerNameUtils.normalize(inetSocketAddress));
        }
        return arrayList;
    }

    public SocketFactory getSocketFactory() {
        if (this.mySocketFactory == null) {
            this.mySocketFactory = SocketFactory.getDefault();
        }
        return this.mySocketFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.myThreadFactory;
    }

    @Deprecated
    public String getUserName() {
        if (!this.myCredentials.isEmpty()) {
            Credential credential = this.myCredentials.entrySet().iterator().next().getValue();
            return credential.getUserName();
        }
        return null;
    }

    @Deprecated
    public boolean isAdminUser() {
        return this.myCredentials.containsKey(ADMIN_DB_NAME);
    }

    public boolean isAuthenticating() {
        return !this.myCredentials.isEmpty();
    }

    public boolean isAutoDiscoverServers() {
        return this.myAutoDiscoverServers;
    }

    public boolean isUsingSoKeepalive() {
        return this.myUsingSoKeepalive;
    }

    public void setAutoDiscoverServers(boolean bl) {
        this.myAutoDiscoverServers = bl;
    }

    public void setConnectTimeout(int n) {
        this.myConnectTimeout = n;
    }

    public void setCredentials(Collection<Credential> collection) {
        this.myCredentials.clear();
        for (Credential credential : collection) {
            this.addCredential(credential);
        }
    }

    @Deprecated
    public void setDefaultDatabase(String string) {
        this.myDefaultDatabase = string;
        if (this.myLegacyCredential != null) {
            this.myCredentials.remove(this.myLegacyCredential.getDatabase());
            this.myLegacyCredential = Credential.builder().userName(this.myLegacyCredential.getUserName()).password(this.myLegacyCredential.getPassword()).database(string).mongodbCR().build();
            this.addCredential(this.myLegacyCredential);
        }
    }

    public void setDefaultDurability(Durability durability) {
        this.myDefaultDurability = durability;
    }

    public void setDefaultReadPreference(ReadPreference readPreference) {
        this.myDefaultReadPreference = readPreference == null ? ReadPreference.PRIMARY : readPreference;
    }

    public void setExecutor(Executor executor) {
        this.myExecutor = executor;
    }

    public void setLockType(LockType lockType) {
        this.myLockType = lockType;
    }

    public void setMaxConnectionCount(int n) {
        this.myMaxConnectionCount = n;
    }

    public void setMaxPendingOperationsPerConnection(int n) {
        this.myMaxPendingOperationsPerConnection = n;
    }

    public void setMaxSecondaryLag(long l) {
        this.myMaxSecondaryLag = l;
    }

    public void setReadTimeout(int n) {
        this.myReadTimeout = n;
    }

    public void setReconnectTimeout(int n) {
        this.myReconnectTimeout = n;
    }

    public void setServers(List<InetSocketAddress> list) {
        this.myServers.clear();
        if (list != null) {
            for (InetSocketAddress inetSocketAddress : list) {
                this.addServer(inetSocketAddress);
            }
        }
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.mySocketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.myThreadFactory = threadFactory;
    }

    public void setUsingSoKeepalive(boolean bl) {
        this.myUsingSoKeepalive = bl;
    }
}

