/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.impl.EmptyDocument;
import com.allanbank.mongodb.builder.Aggregate;
import com.allanbank.mongodb.builder.Distinct;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.FindAndModify;
import com.allanbank.mongodb.builder.GroupBy;
import com.allanbank.mongodb.builder.MapReduce;
import com.allanbank.mongodb.builder.Text;
import com.allanbank.mongodb.builder.TextResult;
import java.util.List;
import java.util.concurrent.Future;

public interface MongoCollection {
    public static final Document ALL = EmptyDocument.INSTANCE;

    public List<Document> aggregate(Aggregate var1) throws MongoDbException;

    public List<Document> aggregate(Aggregate.Builder var1) throws MongoDbException;

    public Future<List<Document>> aggregateAsync(Aggregate var1) throws MongoDbException;

    public Future<List<Document>> aggregateAsync(Aggregate.Builder var1) throws MongoDbException;

    public void aggregateAsync(Callback<List<Document>> var1, Aggregate var2) throws MongoDbException;

    public void aggregateAsync(Callback<List<Document>> var1, Aggregate.Builder var2) throws MongoDbException;

    public long count() throws MongoDbException;

    public long count(DocumentAssignable var1) throws MongoDbException;

    public long count(DocumentAssignable var1, ReadPreference var2) throws MongoDbException;

    public long count(ReadPreference var1) throws MongoDbException;

    public Future<Long> countAsync() throws MongoDbException;

    public void countAsync(Callback<Long> var1) throws MongoDbException;

    public void countAsync(Callback<Long> var1, DocumentAssignable var2) throws MongoDbException;

    public void countAsync(Callback<Long> var1, DocumentAssignable var2, ReadPreference var3) throws MongoDbException;

    public void countAsync(Callback<Long> var1, ReadPreference var2) throws MongoDbException;

    public Future<Long> countAsync(DocumentAssignable var1) throws MongoDbException;

    public Future<Long> countAsync(DocumentAssignable var1, ReadPreference var2) throws MongoDbException;

    public Future<Long> countAsync(ReadPreference var1) throws MongoDbException;

    public void createIndex(boolean var1, Element ... var2) throws MongoDbException;

    public void createIndex(DocumentAssignable var1, Element ... var2) throws MongoDbException;

    public void createIndex(Element ... var1) throws MongoDbException;

    public void createIndex(String var1, boolean var2, Element ... var3) throws MongoDbException;

    public void createIndex(String var1, DocumentAssignable var2, Element ... var3) throws MongoDbException;

    public long delete(DocumentAssignable var1) throws MongoDbException;

    public long delete(DocumentAssignable var1, boolean var2) throws MongoDbException;

    public long delete(DocumentAssignable var1, boolean var2, Durability var3) throws MongoDbException;

    public long delete(DocumentAssignable var1, Durability var2) throws MongoDbException;

    public void deleteAsync(Callback<Long> var1, DocumentAssignable var2) throws MongoDbException;

    public void deleteAsync(Callback<Long> var1, DocumentAssignable var2, boolean var3) throws MongoDbException;

    public void deleteAsync(Callback<Long> var1, DocumentAssignable var2, boolean var3, Durability var4) throws MongoDbException;

    public void deleteAsync(Callback<Long> var1, DocumentAssignable var2, Durability var3) throws MongoDbException;

    public Future<Long> deleteAsync(DocumentAssignable var1) throws MongoDbException;

    public Future<Long> deleteAsync(DocumentAssignable var1, boolean var2) throws MongoDbException;

    public Future<Long> deleteAsync(DocumentAssignable var1, boolean var2, Durability var3) throws MongoDbException;

    public Future<Long> deleteAsync(DocumentAssignable var1, Durability var2) throws MongoDbException;

    public ArrayElement distinct(Distinct var1) throws MongoDbException;

    public ArrayElement distinct(Distinct.Builder var1) throws MongoDbException;

    public void distinctAsync(Callback<ArrayElement> var1, Distinct var2) throws MongoDbException;

    public void distinctAsync(Callback<ArrayElement> var1, Distinct.Builder var2) throws MongoDbException;

    public Future<ArrayElement> distinctAsync(Distinct var1) throws MongoDbException;

    public Future<ArrayElement> distinctAsync(Distinct.Builder var1) throws MongoDbException;

    public boolean drop() throws MongoDbException;

    public boolean dropIndex(IntegerElement ... var1) throws MongoDbException;

    public boolean dropIndex(String var1) throws MongoDbException;

    public Document explain(DocumentAssignable var1) throws MongoDbException;

    public Document explain(Find var1) throws MongoDbException;

    public Document explain(Find.Builder var1) throws MongoDbException;

    public void explainAsync(Callback<Document> var1, Find var2) throws MongoDbException;

    public void explainAsync(Callback<Document> var1, Find.Builder var2) throws MongoDbException;

    public Future<Document> explainAsync(Find var1) throws MongoDbException;

    public Future<Document> explainAsync(Find.Builder var1) throws MongoDbException;

    public MongoIterator<Document> find(DocumentAssignable var1) throws MongoDbException;

    public MongoIterator<Document> find(Find var1) throws MongoDbException;

    public MongoIterator<Document> find(Find.Builder var1) throws MongoDbException;

    public Document findAndModify(FindAndModify var1) throws MongoDbException;

    public Document findAndModify(FindAndModify.Builder var1) throws MongoDbException;

    public void findAndModifyAsync(Callback<Document> var1, FindAndModify var2) throws MongoDbException;

    public void findAndModifyAsync(Callback<Document> var1, FindAndModify.Builder var2) throws MongoDbException;

    public Future<Document> findAndModifyAsync(FindAndModify var1) throws MongoDbException;

    public Future<Document> findAndModifyAsync(FindAndModify.Builder var1) throws MongoDbException;

    public void findAsync(Callback<MongoIterator<Document>> var1, DocumentAssignable var2) throws MongoDbException;

    public void findAsync(Callback<MongoIterator<Document>> var1, Find var2) throws MongoDbException;

    public void findAsync(Callback<MongoIterator<Document>> var1, Find.Builder var2) throws MongoDbException;

    public Future<MongoIterator<Document>> findAsync(DocumentAssignable var1) throws MongoDbException;

    public Future<MongoIterator<Document>> findAsync(Find var1) throws MongoDbException;

    public Future<MongoIterator<Document>> findAsync(Find.Builder var1) throws MongoDbException;

    public Document findOne(DocumentAssignable var1) throws MongoDbException;

    public Document findOne(Find var1) throws MongoDbException;

    public Document findOne(Find.Builder var1) throws MongoDbException;

    public void findOneAsync(Callback<Document> var1, DocumentAssignable var2) throws MongoDbException;

    public void findOneAsync(Callback<Document> var1, Find var2) throws MongoDbException;

    public void findOneAsync(Callback<Document> var1, Find.Builder var2) throws MongoDbException;

    public Future<Document> findOneAsync(DocumentAssignable var1) throws MongoDbException;

    public Future<Document> findOneAsync(Find var1) throws MongoDbException;

    public Future<Document> findOneAsync(Find.Builder var1) throws MongoDbException;

    public String getDatabaseName();

    public Durability getDurability();

    public String getName();

    public ReadPreference getReadPreference();

    public ArrayElement groupBy(GroupBy var1) throws MongoDbException;

    public ArrayElement groupBy(GroupBy.Builder var1) throws MongoDbException;

    public void groupByAsync(Callback<ArrayElement> var1, GroupBy var2) throws MongoDbException;

    public void groupByAsync(Callback<ArrayElement> var1, GroupBy.Builder var2) throws MongoDbException;

    public Future<ArrayElement> groupByAsync(GroupBy var1) throws MongoDbException;

    public Future<ArrayElement> groupByAsync(GroupBy.Builder var1) throws MongoDbException;

    public int insert(boolean var1, DocumentAssignable ... var2) throws MongoDbException;

    public int insert(boolean var1, Durability var2, DocumentAssignable ... var3) throws MongoDbException;

    public int insert(DocumentAssignable ... var1) throws MongoDbException;

    public int insert(Durability var1, DocumentAssignable ... var2) throws MongoDbException;

    public Future<Integer> insertAsync(boolean var1, DocumentAssignable ... var2) throws MongoDbException;

    public Future<Integer> insertAsync(boolean var1, Durability var2, DocumentAssignable ... var3) throws MongoDbException;

    public void insertAsync(Callback<Integer> var1, boolean var2, DocumentAssignable ... var3) throws MongoDbException;

    public void insertAsync(Callback<Integer> var1, boolean var2, Durability var3, DocumentAssignable ... var4) throws MongoDbException;

    public void insertAsync(Callback<Integer> var1, DocumentAssignable ... var2) throws MongoDbException;

    public void insertAsync(Callback<Integer> var1, Durability var2, DocumentAssignable ... var3) throws MongoDbException;

    public Future<Integer> insertAsync(DocumentAssignable ... var1) throws MongoDbException;

    public Future<Integer> insertAsync(Durability var1, DocumentAssignable ... var2) throws MongoDbException;

    public boolean isCapped() throws MongoDbException;

    public List<Document> mapReduce(MapReduce var1) throws MongoDbException;

    public List<Document> mapReduce(MapReduce.Builder var1) throws MongoDbException;

    public void mapReduceAsync(Callback<List<Document>> var1, MapReduce var2) throws MongoDbException;

    public void mapReduceAsync(Callback<List<Document>> var1, MapReduce.Builder var2) throws MongoDbException;

    public Future<List<Document>> mapReduceAsync(MapReduce var1) throws MongoDbException;

    public Future<List<Document>> mapReduceAsync(MapReduce.Builder var1) throws MongoDbException;

    public int save(DocumentAssignable var1) throws MongoDbException;

    public int save(DocumentAssignable var1, Durability var2) throws MongoDbException;

    public void saveAsync(Callback<Integer> var1, DocumentAssignable var2) throws MongoDbException;

    public void saveAsync(Callback<Integer> var1, DocumentAssignable var2, Durability var3) throws MongoDbException;

    public Future<Integer> saveAsync(DocumentAssignable var1) throws MongoDbException;

    public Future<Integer> saveAsync(DocumentAssignable var1, Durability var2) throws MongoDbException;

    public void setDurability(Durability var1);

    public void setReadPreference(ReadPreference var1);

    public Document stats() throws MongoDbException;

    @Deprecated
    public MongoCursorControl streamingFind(Callback<Document> var1, DocumentAssignable var2) throws MongoDbException;

    @Deprecated
    public MongoCursorControl streamingFind(Callback<Document> var1, Find var2) throws MongoDbException;

    public MongoCursorControl streamingFind(StreamCallback<Document> var1, DocumentAssignable var2) throws MongoDbException;

    public MongoCursorControl streamingFind(StreamCallback<Document> var1, Find var2) throws MongoDbException;

    public MongoCursorControl streamingFind(StreamCallback<Document> var1, Find.Builder var2) throws MongoDbException;

    public List<TextResult> textSearch(Text var1) throws MongoDbException;

    public List<TextResult> textSearch(Text.Builder var1) throws MongoDbException;

    public void textSearchAsync(Callback<List<TextResult>> var1, Text var2) throws MongoDbException;

    public void textSearchAsync(Callback<List<TextResult>> var1, Text.Builder var2) throws MongoDbException;

    public Future<List<TextResult>> textSearchAsync(Text var1) throws MongoDbException;

    public Future<List<TextResult>> textSearchAsync(Text.Builder var1) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2, boolean var3, boolean var4) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2, boolean var3, boolean var4, Durability var5) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2, Durability var3) throws MongoDbException;

    public void updateAsync(Callback<Long> var1, DocumentAssignable var2, DocumentAssignable var3) throws MongoDbException;

    public void updateAsync(Callback<Long> var1, DocumentAssignable var2, DocumentAssignable var3, boolean var4, boolean var5) throws MongoDbException;

    public void updateAsync(Callback<Long> var1, DocumentAssignable var2, DocumentAssignable var3, boolean var4, boolean var5, Durability var6) throws MongoDbException;

    public void updateAsync(Callback<Long> var1, DocumentAssignable var2, DocumentAssignable var3, Durability var4) throws MongoDbException;

    public Future<Long> updateAsync(DocumentAssignable var1, DocumentAssignable var2) throws MongoDbException;

    public Future<Long> updateAsync(DocumentAssignable var1, DocumentAssignable var2, boolean var3, boolean var4) throws MongoDbException;

    public Future<Long> updateAsync(DocumentAssignable var1, DocumentAssignable var2, boolean var3, boolean var4, Durability var5) throws MongoDbException;

    public Future<Long> updateAsync(DocumentAssignable var1, DocumentAssignable var2, Durability var3) throws MongoDbException;

    public Document updateOptions(DocumentAssignable var1) throws MongoDbException;

    public Document validate(ValidateMode var1) throws MongoDbException;

    public static enum ValidateMode {
        FULL,
        INDEX_ONLY,
        NORMAL;

    }
}

