/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.ProfilingStatus;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import java.util.List;
import java.util.concurrent.Future;

public interface MongoDatabase {
    public static final String ADMIN_NAME = "admin";
    public static final String CONFIG_NAME = "config";
    public static final String LOCAL_NAME = "local";
    public static final String TEST_NAME = "test";

    public boolean createCappedCollection(String var1, long var2) throws MongoDbException;

    public boolean createCollection(String var1, DocumentAssignable var2) throws MongoDbException;

    public boolean drop() throws MongoDbException;

    public MongoCollection getCollection(String var1);

    public Durability getDurability();

    public String getName();

    public ProfilingStatus getProfilingStatus() throws MongoDbException;

    public ReadPreference getReadPreference();

    public List<String> listCollectionNames() throws MongoDbException;

    @Deprecated
    public List<String> listCollections() throws MongoDbException;

    public Document runAdminCommand(String var1) throws MongoDbException;

    public Document runAdminCommand(String var1, DocumentAssignable var2) throws MongoDbException;

    public Document runAdminCommand(String var1, String var2, DocumentAssignable var3) throws MongoDbException;

    public Document runCommand(DocumentAssignable var1) throws MongoDbException;

    public Document runCommand(String var1) throws MongoDbException;

    public Document runCommand(String var1, DocumentAssignable var2) throws MongoDbException;

    public Document runCommand(String var1, int var2, DocumentAssignable var3) throws MongoDbException;

    public Document runCommand(String var1, String var2, DocumentAssignable var3) throws MongoDbException;

    public void runCommandAsync(Callback<Document> var1, DocumentAssignable var2) throws MongoDbException;

    public void runCommandAsync(Callback<Document> var1, String var2) throws MongoDbException;

    public void runCommandAsync(Callback<Document> var1, String var2, DocumentAssignable var3) throws MongoDbException;

    public void runCommandAsync(Callback<Document> var1, String var2, int var3, DocumentAssignable var4) throws MongoDbException;

    public void runCommandAsync(Callback<Document> var1, String var2, String var3, DocumentAssignable var4) throws MongoDbException;

    public Future<Document> runCommandAsync(DocumentAssignable var1) throws MongoDbException;

    public Future<Document> runCommandAsync(String var1) throws MongoDbException;

    public Future<Document> runCommandAsync(String var1, DocumentAssignable var2) throws MongoDbException;

    public Future<Document> runCommandAsync(String var1, int var2, DocumentAssignable var3) throws MongoDbException;

    public Future<Document> runCommandAsync(String var1, String var2, DocumentAssignable var3) throws MongoDbException;

    public void setDurability(Durability var1);

    public boolean setProfilingStatus(ProfilingStatus var1) throws MongoDbException;

    public void setReadPreference(ReadPreference var1);

    public Document stats() throws MongoDbException;
}

