/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class MongoDbUri {
    public static final String MONGODB_URI_PREFIX = "mongodb://";
    private final String myDatabase;
    private final List<String> myHosts;
    private final String myOptions;
    private final String myPassword;
    private final String myUserName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MongoDbUri(String string) throws IllegalArgumentException {
        String string2;
        String string3;
        if (string == null) {
            throw new IllegalArgumentException("The MongoDB URI cannot be null.");
        }
        if (!string.substring(0, MONGODB_URI_PREFIX.length()).equalsIgnoreCase(MONGODB_URI_PREFIX)) {
            throw new IllegalArgumentException("The MongoDB URI must start with 'mongodb://'.");
        }
        String string4 = string.substring(MONGODB_URI_PREFIX.length());
        int n = string4.indexOf(64);
        if (n >= 0) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
        } else {
            string3 = "";
        }
        n = string4.indexOf(47);
        if (n >= 0) {
            string2 = string4.substring(0, n);
            if ((n = (string4 = string4.substring(n + 1)).indexOf(63)) >= 0) {
                this.myDatabase = string4.substring(0, n);
                this.myOptions = string4.substring(n + 1);
            } else {
                this.myDatabase = string4;
                this.myOptions = "";
            }
        } else {
            this.myDatabase = "";
            n = string4.indexOf(63);
            if (n >= 0) {
                string2 = string4.substring(0, n);
                this.myOptions = string4.substring(n + 1);
            } else {
                string2 = string4;
                this.myOptions = "";
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        this.myHosts = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            this.myHosts.add(stringTokenizer.nextToken());
        }
        if (this.myHosts.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least 1 host to connect to.");
        }
        if (!string3.isEmpty()) {
            n = string3.indexOf(58);
            if (n < 0) throw new IllegalArgumentException("The password for the user '" + string3 + "' must be provided.");
            this.myUserName = string3.substring(0, n);
            this.myPassword = string3.substring(n + 1);
            return;
        } else {
            this.myUserName = null;
            this.myPassword = null;
        }
    }

    public String getDatabase() {
        return this.myDatabase;
    }

    public List<String> getHosts() {
        return Collections.unmodifiableList(this.myHosts);
    }

    public String getOptions() {
        return this.myOptions;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public String getUserName() {
        return this.myUserName;
    }
}

