/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ReadPreference
implements Serializable,
DocumentAssignable {
    public static final ReadPreference CLOSEST = new ReadPreference(Mode.NEAREST, new DocumentAssignable[0]);
    public static final String FIELD_NAME = "$readPreference";
    public static final ReadPreference PREFER_PRIMARY = new ReadPreference(Mode.PRIMARY_PREFERRED, new DocumentAssignable[0]);
    public static final ReadPreference PREFER_SECONDARY = new ReadPreference(Mode.SECONDARY_PREFERRED, new DocumentAssignable[0]);
    public static final ReadPreference PRIMARY = new ReadPreference(Mode.PRIMARY_ONLY, new DocumentAssignable[0]);
    public static final ReadPreference SECONDARY = new ReadPreference(Mode.SECONDARY_ONLY, new DocumentAssignable[0]);
    private static final long serialVersionUID = -2135959854336511332L;
    private final Document myDocumentForm;
    private final Mode myMode;
    private final String myServer;
    private final List<Document> myTagMatchingDocuments;

    public static ReadPreference closest(DocumentAssignable ... documentAssignableArray) {
        if (documentAssignableArray.length == 0) {
            return CLOSEST;
        }
        return new ReadPreference(Mode.NEAREST, documentAssignableArray);
    }

    public static ReadPreference preferPrimary(DocumentAssignable ... documentAssignableArray) {
        if (documentAssignableArray.length == 0) {
            return PREFER_PRIMARY;
        }
        return new ReadPreference(Mode.PRIMARY_PREFERRED, documentAssignableArray);
    }

    public static ReadPreference preferSecondary(DocumentAssignable ... documentAssignableArray) {
        if (documentAssignableArray.length == 0) {
            return PREFER_SECONDARY;
        }
        return new ReadPreference(Mode.SECONDARY_PREFERRED, documentAssignableArray);
    }

    public static ReadPreference primary() {
        return PRIMARY;
    }

    public static ReadPreference secondary(DocumentAssignable ... documentAssignableArray) {
        if (documentAssignableArray.length == 0) {
            return SECONDARY;
        }
        return new ReadPreference(Mode.SECONDARY_ONLY, documentAssignableArray);
    }

    public static ReadPreference server(String string) {
        return new ReadPreference(Mode.SERVER, string);
    }

    protected ReadPreference(Mode mode, DocumentAssignable ... documentAssignableArray) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("mode", mode.getToken());
        this.myMode = mode;
        this.myServer = null;
        if (documentAssignableArray.length == 0) {
            this.myTagMatchingDocuments = Collections.emptyList();
        } else {
            this.myTagMatchingDocuments = new ArrayList<Document>(documentAssignableArray.length);
            ArrayBuilder arrayBuilder = documentBuilder.pushArray("tags");
            for (DocumentAssignable documentAssignable : documentAssignableArray) {
                Document document = documentAssignable.asDocument();
                this.myTagMatchingDocuments.add(document);
                arrayBuilder.addDocument(document);
            }
        }
        this.myDocumentForm = documentBuilder.build();
    }

    protected ReadPreference(Mode mode, String string) {
        this.myMode = mode;
        this.myServer = string;
        this.myTagMatchingDocuments = Collections.emptyList();
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("mode", mode.getToken());
        this.myDocumentForm = documentBuilder.build();
    }

    @Override
    public Document asDocument() {
        return this.myDocumentForm;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            ReadPreference readPreference = (ReadPreference)object;
            bl = this.myMode.equals((Object)readPreference.myMode) && this.myTagMatchingDocuments.equals(readPreference.myTagMatchingDocuments) && this.nullSafeEquals(this.myServer, readPreference.myServer);
        }
        return bl;
    }

    public Mode getMode() {
        return this.myMode;
    }

    public String getServer() {
        return this.myServer;
    }

    public List<Document> getTagMatchingDocuments() {
        return this.myTagMatchingDocuments;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.myMode.ordinal();
        n = 31 * n + this.myTagMatchingDocuments.hashCode();
        return n;
    }

    public boolean isLegacy() {
        return (this.myMode == Mode.PRIMARY_ONLY || this.myMode == Mode.SECONDARY_ONLY || this.myMode == Mode.SERVER) && this.myTagMatchingDocuments.isEmpty();
    }

    public boolean isSecondaryOk() {
        return this.myMode.isSecondaryOk();
    }

    public boolean matches(Document document) {
        if (this.myTagMatchingDocuments.isEmpty()) {
            return true;
        }
        boolean bl = false;
        Iterator<Document> iterator = this.myTagMatchingDocuments.iterator();
        while (iterator.hasNext() && !bl) {
            Document document2 = iterator.next();
            if (document == null) {
                if (document2.iterator().hasNext()) continue;
                bl = true;
                continue;
            }
            bl = true;
            Iterator iterator2 = document2.iterator();
            while (iterator2.hasNext() && bl) {
                Element element;
                Element element2 = (Element)iterator2.next();
                if (this.fuzzyEquals(element2, element = document.get(element2.getName()))) continue;
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.myMode.name());
        if (this.myServer != null) {
            stringBuilder.append('[');
            stringBuilder.append(this.myServer);
            stringBuilder.append(']');
        } else if (!this.myTagMatchingDocuments.isEmpty()) {
            stringBuilder.append('[');
            boolean bl = true;
            for (Document document : this.myTagMatchingDocuments) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append('{');
                boolean bl2 = true;
                for (Element element : document) {
                    if (!bl2) {
                        stringBuilder.append(", ");
                    }
                    bl2 = false;
                    stringBuilder.append(element);
                }
                stringBuilder.append('}');
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    protected boolean nullSafeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private boolean fuzzyEquals(Element element, Element element2) {
        if (element2 instanceof NumericElement && element instanceof NumericElement) {
            long l;
            long l2 = ((NumericElement)element2).getLongValue();
            return l2 == (l = ((NumericElement)element).getLongValue());
        }
        return element.equals(element2);
    }

    private Object readResolve() {
        if (this.equals(CLOSEST)) {
            return CLOSEST;
        }
        if (this.equals(PREFER_PRIMARY)) {
            return PREFER_PRIMARY;
        }
        if (this.equals(PREFER_SECONDARY)) {
            return PREFER_SECONDARY;
        }
        if (this.equals(PRIMARY)) {
            return PRIMARY;
        }
        if (this.equals(SECONDARY)) {
            return SECONDARY;
        }
        return this;
    }

    public static enum Mode {
        NEAREST("nearest"),
        PRIMARY_ONLY("primary"),
        PRIMARY_PREFERRED("primaryPreferred"),
        SECONDARY_ONLY("secondary"),
        SECONDARY_PREFERRED("secondaryPreferred"),
        SERVER("server");

        private final String myToken;

        private Mode(String string2) {
            this.myToken = string2;
        }

        public String getToken() {
            return this.myToken;
        }

        public boolean isSecondaryOk() {
            return this != PRIMARY_ONLY;
        }
    }
}

