/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.util.Assertions;

public class DocumentReference
implements DocumentAssignable {
    public static final String COLLECTION_FIELD_NAME = "$ref";
    public static final String DATABASE_FIELD_NAME = "$db";
    public static final String ID_FIELD_NAME = "$id";
    private final String myCollectionName;
    private final String myDatabaseName;
    private final Element myId;

    public DocumentReference(String string, Element element) throws IllegalArgumentException {
        this(null, string, element);
    }

    public DocumentReference(String string, String string2, Element element) throws IllegalArgumentException {
        Assertions.assertNotNull(string2, "The collection name of a Document Reference (DBRef) cannot be null.");
        Assertions.assertNotNull(element, "The id of a Document Reference (DBRef) cannot be null.");
        this.myDatabaseName = string;
        this.myCollectionName = string2;
        this.myId = element.withName(ID_FIELD_NAME);
    }

    @Override
    public Document asDocument() {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add(COLLECTION_FIELD_NAME, this.myCollectionName);
        documentBuilder.add(this.myId.withName(ID_FIELD_NAME));
        if (this.myDatabaseName != null) {
            documentBuilder.add(DATABASE_FIELD_NAME, this.myDatabaseName);
        }
        return documentBuilder.asDocument();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            DocumentReference documentReference = (DocumentReference)object;
            bl = this.myCollectionName.equals(documentReference.myCollectionName) && this.myId.withName(ID_FIELD_NAME).equals(documentReference.myId.withName(ID_FIELD_NAME)) && this.nullSafeEquals(this.myDatabaseName, documentReference.myDatabaseName);
        }
        return bl;
    }

    public String getCollectionName() {
        return this.myCollectionName;
    }

    public String getDatabaseName() {
        return this.myDatabaseName;
    }

    public Element getId() {
        return this.myId;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.myCollectionName.hashCode();
        n = 31 * n + this.myId.withName(ID_FIELD_NAME).hashCode();
        n = 31 * n + (this.myDatabaseName != null ? this.myDatabaseName.hashCode() : 3);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{ '");
        stringBuilder.append(COLLECTION_FIELD_NAME);
        stringBuilder.append("' : '");
        stringBuilder.append(this.myCollectionName);
        stringBuilder.append("', ");
        stringBuilder.append(this.myId.withName(ID_FIELD_NAME));
        if (this.myDatabaseName != null) {
            stringBuilder.append(", '");
            stringBuilder.append(DATABASE_FIELD_NAME);
            stringBuilder.append("' : '");
            stringBuilder.append(this.myDatabaseName);
            stringBuilder.append("'");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    protected boolean nullSafeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }
}

