/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.builder.impl;

import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementAssignable;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.Builder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.builder.impl.ArrayBuilderImpl;
import com.allanbank.mongodb.bson.builder.impl.DocumentBuilderImpl;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.bson.element.UuidElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public abstract class AbstractBuilder
implements Builder {
    protected static final boolean ASSERTIONS_ENABLED;
    protected static final Class<BuilderElement> BUILDER_ELEMENT_CLASS;
    protected final List<Element> myElements;
    private final AbstractBuilder myOuterBuilder;

    public AbstractBuilder(AbstractBuilder abstractBuilder) {
        this.myOuterBuilder = abstractBuilder;
        this.myElements = new ArrayList<Element>(5);
    }

    @Override
    public Builder pop() {
        return this.myOuterBuilder;
    }

    @Override
    public Builder reset() {
        this.myElements.clear();
        return this;
    }

    protected abstract Element build(String var1);

    protected Element coerse(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            return new NullElement(string);
        }
        if (object instanceof Boolean) {
            return new BooleanElement(string, (Boolean)object);
        }
        if (object instanceof Long || object instanceof BigInteger) {
            return new LongElement(string, ((Number)object).longValue());
        }
        if (object instanceof Double || object instanceof Float) {
            return new DoubleElement(string, ((Number)object).doubleValue());
        }
        if (object instanceof Number) {
            return new IntegerElement(string, ((Number)object).intValue());
        }
        if (object instanceof byte[]) {
            return new BinaryElement(string, (byte[])object);
        }
        if (object instanceof ObjectId) {
            return new ObjectIdElement(string, (ObjectId)object);
        }
        if (object instanceof Pattern) {
            return new RegularExpressionElement(string, (Pattern)object);
        }
        if (object instanceof String) {
            return new StringElement(string, (String)object);
        }
        if (object instanceof Date) {
            return new TimestampElement(string, ((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new TimestampElement(string, ((Calendar)object).getTime().getTime());
        }
        if (object instanceof UUID) {
            return new UuidElement(string, (UUID)object);
        }
        if (object instanceof DocumentAssignable) {
            return new DocumentElement(string, ((DocumentAssignable)object).asDocument());
        }
        if (object instanceof ElementAssignable) {
            return ((ElementAssignable)object).asElement().withName(string);
        }
        if (object instanceof Map) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                documentBuilder.add(entry.getKey().toString(), entry.getValue());
            }
            return new DocumentElement(string, documentBuilder.build());
        }
        if (object instanceof Collection) {
            ArrayBuilder arrayBuilder = BuilderFactory.startArray();
            for (Object e : (Collection)object) {
                arrayBuilder.add(e);
            }
            return new ArrayElement(string, arrayBuilder.build());
        }
        if (object instanceof Object[]) {
            ArrayBuilder arrayBuilder = BuilderFactory.startArray();
            for (Object object2 : (Object[])object) {
                arrayBuilder.add(object2);
            }
            return new ArrayElement(string, arrayBuilder.build());
        }
        throw new IllegalArgumentException("Could not coerce the type '" + object.getClass().getName() + "' into a valid BSON element type.");
    }

    protected DocumentBuilder doPush(String string) {
        DocumentBuilderImpl documentBuilderImpl = new DocumentBuilderImpl(this);
        this.myElements.add(new BuilderElement(string, documentBuilderImpl));
        return documentBuilderImpl;
    }

    protected ArrayBuilder doPushArray(String string) {
        ArrayBuilderImpl arrayBuilderImpl = new ArrayBuilderImpl(this);
        this.myElements.add(new BuilderElement(string, arrayBuilderImpl));
        return arrayBuilderImpl;
    }

    protected List<Element> subElements() {
        ArrayList<Element> arrayList = new ArrayList<Element>(this.myElements.size());
        HashSet<String> hashSet = null;
        for (Element element : this.myElements) {
            if (element.getClass() == BUILDER_ELEMENT_CLASS) {
                element = ((BuilderElement)element).build();
            }
            if (ASSERTIONS_ENABLED) {
                String string;
                if (hashSet == null) {
                    hashSet = new HashSet<String>(this.myElements.size() << 1);
                }
                if (!hashSet.add(string = element.getName())) assert (false) : string + " is not unique in  " + this.myElements;
            }
            arrayList.add(element);
        }
        return arrayList;
    }

    static {
        BUILDER_ELEMENT_CLASS = BuilderElement.class;
        ASSERTIONS_ENABLED = AbstractBuilder.class.desiredAssertionStatus();
    }

    public static final class BuilderElement
    extends AbstractElement {
        private static final long serialVersionUID = 4421203621373216989L;
        private transient AbstractBuilder myBuilder;

        public BuilderElement(String string, AbstractBuilder abstractBuilder) {
            super(string);
            this.myBuilder = abstractBuilder;
        }

        @Override
        public void accept(Visitor visitor) {
        }

        public Element build() {
            return this.myBuilder.build(this.getName());
        }

        @Override
        public ElementType getType() {
            return null;
        }

        @Override
        public Object getValueAsObject() {
            return null;
        }

        @Override
        public BuilderElement withName(String string) {
            return new BuilderElement(string, this.myBuilder);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.myBuilder = null;
        }
    }
}

