/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.builder.impl;

import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementAssignable;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.builder.impl.AbstractBuilder;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DBPointerElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.JavaScriptElement;
import com.allanbank.mongodb.bson.element.JavaScriptWithScopeElement;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.MaxKeyElement;
import com.allanbank.mongodb.bson.element.MinKeyElement;
import com.allanbank.mongodb.bson.element.MongoTimestampElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.bson.element.UuidElement;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;

public class ArrayBuilderImpl
extends AbstractBuilder
implements ArrayBuilder {
    public ArrayBuilderImpl() {
        this(null);
    }

    public ArrayBuilderImpl(AbstractBuilder abstractBuilder) {
        super(abstractBuilder);
    }

    @Override
    public ArrayBuilder add(boolean bl) {
        return this.addBoolean(bl);
    }

    @Override
    public ArrayBuilder add(byte by, byte[] byArray) throws IllegalArgumentException {
        return this.addBinary(by, byArray);
    }

    @Override
    public ArrayBuilder add(byte[] byArray) {
        if (byArray == null) {
            return this.addNull();
        }
        return this.addBinary(byArray);
    }

    @Override
    public ArrayBuilder add(Date date) {
        if (date == null) {
            return this.addNull();
        }
        return this.addTimestamp(date.getTime());
    }

    @Override
    public ArrayBuilder add(DocumentAssignable documentAssignable) {
        if (documentAssignable == null) {
            return this.addNull();
        }
        return this.addDocument(documentAssignable);
    }

    @Override
    public ArrayBuilder add(DocumentElement documentElement) {
        if (documentElement == null) {
            return this.addNull();
        }
        return this.addDocument(documentElement);
    }

    @Override
    public ArrayBuilder add(double d) {
        return this.addDouble(d);
    }

    @Override
    public ArrayBuilder add(ElementAssignable elementAssignable) throws IllegalArgumentException {
        if (elementAssignable == null) {
            throw new IllegalArgumentException("Cannot add a null element.");
        }
        this.myElements.add(elementAssignable.asElement().withName(this.nextIndex()));
        return this;
    }

    @Override
    public ArrayBuilder add(int n) {
        return this.addInteger(n);
    }

    @Override
    public ArrayBuilder add(long l) {
        return this.addLong(l);
    }

    @Override
    public ArrayBuilder add(Object object) throws IllegalArgumentException {
        this.myElements.add(this.coerse(this.nextIndex(), object));
        return this;
    }

    @Override
    public ArrayBuilder add(ObjectId objectId) {
        if (objectId == null) {
            return this.addNull();
        }
        return this.addObjectId(objectId);
    }

    @Override
    public ArrayBuilder add(Pattern pattern) {
        if (pattern == null) {
            return this.addNull();
        }
        return this.addRegularExpression(pattern);
    }

    @Override
    public ArrayBuilder add(String string) {
        if (string == null) {
            return this.addNull();
        }
        return this.addString(string);
    }

    @Override
    @Deprecated
    public ArrayBuilder add(String string, String string2, ObjectId objectId) throws IllegalArgumentException {
        return this.addDBPointer(string, string2, objectId);
    }

    @Override
    public ArrayBuilder add(UUID uUID) throws IllegalArgumentException {
        if (uUID == null) {
            return this.addNull();
        }
        return this.addUuid(uUID);
    }

    @Override
    public ArrayBuilder addBinary(byte by, byte[] byArray) throws IllegalArgumentException {
        this.myElements.add(new BinaryElement(this.nextIndex(), by, byArray));
        return this;
    }

    @Override
    public ArrayBuilder addBinary(byte[] byArray) throws IllegalArgumentException {
        this.myElements.add(new BinaryElement(this.nextIndex(), byArray));
        return this;
    }

    @Override
    public ArrayBuilder addBoolean(boolean bl) {
        this.myElements.add(new BooleanElement(this.nextIndex(), bl));
        return this;
    }

    @Override
    @Deprecated
    public ArrayBuilder addDBPointer(String string, String string2, ObjectId objectId) throws IllegalArgumentException {
        this.myElements.add(new DBPointerElement(this.nextIndex(), string, string2, objectId));
        return this;
    }

    @Override
    public ArrayBuilder addDocument(DocumentAssignable documentAssignable) throws IllegalArgumentException {
        this.myElements.add(new DocumentElement(this.nextIndex(), documentAssignable.asDocument()));
        return this;
    }

    @Override
    public ArrayBuilder addDouble(double d) {
        this.myElements.add(new DoubleElement(this.nextIndex(), d));
        return this;
    }

    @Override
    public ArrayBuilder addInteger(int n) {
        this.myElements.add(new IntegerElement(this.nextIndex(), n));
        return this;
    }

    @Override
    public ArrayBuilder addJavaScript(String string) throws IllegalArgumentException {
        this.myElements.add(new JavaScriptElement(this.nextIndex(), string));
        return this;
    }

    @Override
    public ArrayBuilder addJavaScript(String string, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        this.myElements.add(new JavaScriptWithScopeElement(this.nextIndex(), string, documentAssignable.asDocument()));
        return this;
    }

    @Override
    public ArrayBuilder addLegacyUuid(UUID uUID) throws IllegalArgumentException {
        this.myElements.add(new UuidElement(this.nextIndex(), 3, uUID));
        return this;
    }

    @Override
    public ArrayBuilder addLong(long l) {
        this.myElements.add(new LongElement(this.nextIndex(), l));
        return this;
    }

    @Override
    public ArrayBuilder addMaxKey() {
        this.myElements.add(new MaxKeyElement(this.nextIndex()));
        return this;
    }

    @Override
    public ArrayBuilder addMinKey() {
        this.myElements.add(new MinKeyElement(this.nextIndex()));
        return this;
    }

    @Override
    public ArrayBuilder addMongoTimestamp(long l) {
        this.myElements.add(new MongoTimestampElement(this.nextIndex(), l));
        return this;
    }

    @Override
    public ArrayBuilder addNull() {
        this.myElements.add(new NullElement(this.nextIndex()));
        return this;
    }

    @Override
    public ArrayBuilder addObjectId(ObjectId objectId) throws IllegalArgumentException {
        this.myElements.add(new ObjectIdElement(this.nextIndex(), objectId));
        return this;
    }

    @Override
    public ArrayBuilder addRegularExpression(Pattern pattern) throws IllegalArgumentException {
        this.myElements.add(new RegularExpressionElement(this.nextIndex(), pattern));
        return this;
    }

    @Override
    public ArrayBuilder addRegularExpression(String string, String string2) throws IllegalArgumentException {
        this.myElements.add(new RegularExpressionElement(this.nextIndex(), string, string2));
        return this;
    }

    @Override
    public ArrayBuilder addString(String string) throws IllegalArgumentException {
        this.myElements.add(new StringElement(this.nextIndex(), string));
        return this;
    }

    @Override
    public ArrayBuilder addSymbol(String string) throws IllegalArgumentException {
        this.myElements.add(new SymbolElement(this.nextIndex(), string));
        return this;
    }

    @Override
    public ArrayBuilder addTimestamp(long l) {
        this.myElements.add(new TimestampElement(this.nextIndex(), l));
        return this;
    }

    @Override
    public ArrayBuilder addUuid(UUID uUID) throws IllegalArgumentException {
        this.myElements.add(new UuidElement(this.nextIndex(), 4, uUID));
        return this;
    }

    @Override
    public Element[] build() {
        List<Element> list = this.subElements();
        return list.toArray(new Element[list.size()]);
    }

    @Override
    public ArrayElement build(String string) {
        return new ArrayElement(string, this.subElements());
    }

    @Override
    public DocumentBuilder push() {
        return this.doPush(this.nextIndex());
    }

    @Override
    public ArrayBuilder pushArray() {
        return this.doPushArray(this.nextIndex());
    }

    @Override
    public ArrayBuilder reset() {
        super.reset();
        return this;
    }

    private String nextIndex() {
        return ArrayElement.nameFor(this.myElements.size());
    }
}

