/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.util.PatternUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ArrayElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.ARRAY;
    private static final String[] ourIndexes = new String[256];
    private static final long serialVersionUID = -7363294574214059703L;
    private final List<Element> myEntries;

    public static final String nameFor(int n) {
        if (0 <= n && n < ourIndexes.length) {
            return ourIndexes[n];
        }
        return Integer.toString(n);
    }

    public ArrayElement(String string, Element ... elementArray) throws IllegalArgumentException {
        super(string);
        int n = elementArray.length;
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(elementArray[i].withName(ArrayElement.nameFor(i)));
        }
        this.myEntries = Collections.unmodifiableList(arrayList);
    }

    public ArrayElement(String string, List<Element> list) throws IllegalArgumentException {
        super(string);
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            ArrayList<Element> arrayList = new ArrayList<Element>(n);
            int n2 = 0;
            for (Element element : list) {
                arrayList.add(element.withName(ArrayElement.nameFor(n2)));
                ++n2;
            }
            this.myEntries = Collections.unmodifiableList(arrayList);
        } else {
            this.myEntries = Collections.emptyList();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitArray(this.getName(), this.getEntries());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            ArrayElement arrayElement = (ArrayElement)object;
            bl = super.equals(object) && this.myEntries.equals(arrayElement.myEntries);
        }
        return bl;
    }

    @Override
    public <E extends Element> List<E> find(Class<E> clazz, String ... stringArray) {
        if (0 < stringArray.length) {
            ArrayList<E> arrayList = new ArrayList<E>();
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                for (Element element : this.myEntries) {
                    if (!pattern.matcher(element.getName()).matches()) continue;
                    arrayList.addAll(element.find(clazz, stringArray2));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                for (Element element : this.myEntries) {
                    if (!string.equals(element.getName())) continue;
                    arrayList.addAll(element.find(clazz, stringArray2));
                }
            }
            return arrayList;
        }
        if (clazz.isAssignableFrom(this.getClass())) {
            return Collections.singletonList(clazz.cast(this));
        }
        return Collections.emptyList();
    }

    @Override
    public <E extends Element> E findFirst(Class<E> clazz, String ... stringArray) {
        Element element = null;
        if (0 < stringArray.length) {
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                Iterator<Element> iterator = this.myEntries.iterator();
                while (iterator.hasNext() && element == null) {
                    Element element2 = iterator.next();
                    if (!pattern.matcher(element2.getName()).matches()) continue;
                    element = element2.findFirst(clazz, stringArray2);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Iterator<Element> iterator = this.myEntries.iterator();
                while (iterator.hasNext() && element == null) {
                    Element element3 = iterator.next();
                    if (!string.equals(element3.getName())) continue;
                    element = element3.findFirst(clazz, stringArray2);
                }
            }
        } else if (clazz.isAssignableFrom(this.getClass())) {
            element = (Element)clazz.cast(this);
        }
        return (E)element;
    }

    public List<Element> getEntries() {
        return this.myEntries;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public Element[] getValueAsObject() {
        return this.myEntries.toArray(new Element[this.myEntries.size()]);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.myEntries.hashCode();
        return n;
    }

    @Override
    public ArrayElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new ArrayElement(string, this.myEntries);
    }

    static {
        for (int i = 0; i < ourIndexes.length; ++i) {
            ArrayElement.ourIndexes[i] = Integer.toString(i).intern();
        }
    }
}

