/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.util.Assertions;
import java.util.Arrays;

public class BinaryElement
extends AbstractElement {
    public static final byte DEFAULT_SUB_TYPE = 0;
    public static final ElementType TYPE = ElementType.BINARY;
    private static final long serialVersionUID = 5864918707454038001L;
    private final byte mySubType;
    private final byte[] myValue;

    public BinaryElement(String string, byte by, byte[] byArray) {
        super(string);
        Assertions.assertNotNull(byArray, "Binary element's value cannot be null.  Add a null element instead.");
        this.mySubType = by;
        this.myValue = (byte[])byArray.clone();
    }

    public BinaryElement(String string, byte[] byArray) {
        this(string, 0, byArray);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBinary(this.getName(), this.getSubType(), this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            BinaryElement binaryElement = (BinaryElement)object;
            bl = super.equals(object) && this.mySubType == binaryElement.mySubType && Arrays.equals(this.myValue, binaryElement.myValue);
        }
        return bl;
    }

    public byte getSubType() {
        return this.mySubType;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public byte[] getValue() {
        return (byte[])this.myValue.clone();
    }

    @Override
    public Object getValueAsObject() {
        return this.getValue();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.mySubType;
        n = 31 * n + Arrays.hashCode(this.myValue);
        return n;
    }

    @Override
    public BinaryElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new BinaryElement(string, this.mySubType, this.myValue);
    }
}

