/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;

public class BooleanElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.BOOLEAN;
    private static final long serialVersionUID = -3534279865960686134L;
    private final boolean myValue;

    public BooleanElement(String string, boolean bl) {
        super(string);
        this.myValue = bl;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBoolean(this.getName(), this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            BooleanElement booleanElement = (BooleanElement)object;
            bl = super.equals(object) && this.myValue == booleanElement.myValue;
        }
        return bl;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public boolean getValue() {
        return this.myValue;
    }

    @Override
    public Boolean getValueAsObject() {
        return this.getValue();
    }

    @Override
    public String getValueAsString() {
        return Boolean.toString(this.myValue);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.myValue ? 31 : 11);
    }

    @Override
    public BooleanElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new BooleanElement(string, this.myValue);
    }
}

