/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;

public class DoubleElement
extends AbstractElement
implements NumericElement {
    public static final ElementType TYPE = ElementType.DOUBLE;
    private static final long serialVersionUID = -7373717629447356968L;
    private final double myValue;

    public DoubleElement(String string, double d) {
        super(string);
        this.myValue = d;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitDouble(this.getName(), this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            DoubleElement doubleElement = (DoubleElement)object;
            bl = super.equals(object) && this.myValue == doubleElement.myValue;
        }
        return bl;
    }

    @Override
    public double getDoubleValue() {
        return this.myValue;
    }

    @Override
    public int getIntValue() {
        return (int)this.myValue;
    }

    @Override
    public long getLongValue() {
        return (long)this.myValue;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public double getValue() {
        return this.myValue;
    }

    @Override
    public Double getValueAsObject() {
        return this.myValue;
    }

    @Override
    public String getValueAsString() {
        return Double.toString(this.myValue);
    }

    @Override
    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.myValue);
        n = 31 * n + super.hashCode();
        n = 31 * n + (int)(l & 0xFFFFFFFFFFFFFFFFL);
        n = 31 * n + (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        return n;
    }

    @Override
    public DoubleElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new DoubleElement(string, this.myValue);
    }
}

