/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;

public class IntegerElement
extends AbstractElement
implements NumericElement {
    public static final ElementType TYPE = ElementType.INTEGER;
    private static final long serialVersionUID = 3738845320555958508L;
    private final int myValue;

    public IntegerElement(String string, int n) {
        super(string);
        this.myValue = n;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInteger(this.getName(), this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            IntegerElement integerElement = (IntegerElement)object;
            bl = super.equals(object) && this.myValue == integerElement.myValue;
        }
        return bl;
    }

    @Override
    public double getDoubleValue() {
        return this.myValue;
    }

    @Override
    public int getIntValue() {
        return this.myValue;
    }

    @Override
    public long getLongValue() {
        return this.myValue;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public int getValue() {
        return this.myValue;
    }

    @Override
    public Integer getValueAsObject() {
        return this.myValue;
    }

    @Override
    public String getValueAsString() {
        return Integer.toString(this.myValue);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + this.myValue;
        return n;
    }

    @Override
    public IntegerElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new IntegerElement(string, this.myValue);
    }
}

