/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.JavaScriptElement;
import com.allanbank.mongodb.util.Assertions;

public class JavaScriptWithScopeElement
extends JavaScriptElement {
    public static final ElementType TYPE = ElementType.JAVA_SCRIPT_WITH_SCOPE;
    private static final long serialVersionUID = -5697976862389984453L;
    private final Document myScope;

    public JavaScriptWithScopeElement(String string, String string2, Document document) {
        super(string, string2);
        Assertions.assertNotNull(document, "JavaScript element's scope cannot be null.");
        this.myScope = document;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitJavaScript(this.getName(), this.getJavaScript(), this.getScope());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            JavaScriptWithScopeElement javaScriptWithScopeElement = (JavaScriptWithScopeElement)object;
            bl = super.equals(object) && this.nullSafeEquals(this.myScope, javaScriptWithScopeElement.myScope);
        }
        return bl;
    }

    public Document getScope() {
        return this.myScope;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Document getValueAsObject() {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("$code", this.getJavaScript());
        documentBuilder.add("$scope", this.myScope);
        return documentBuilder.build();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myScope != null ? this.myScope.hashCode() : 3);
        return n;
    }

    @Override
    public JavaScriptWithScopeElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new JavaScriptWithScopeElement(string, this.getJavaScript(), this.myScope);
    }
}

