/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.error.JsonException;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class JsonSerializationVisitor
implements Visitor {
    public static final String NL = System.getProperty("line.separator", "\n");
    public static final Pattern SYMBOL_PATTERN = Pattern.compile("\\p{Alpha}\\p{Alnum}*");
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private int myIndentLevel = 0;
    private final boolean myOneLine;
    private final Writer mySink;
    private boolean mySuppressNames = false;

    public JsonSerializationVisitor(Writer writer, boolean bl) {
        this.mySink = writer;
        this.myOneLine = bl;
        this.myIndentLevel = 0;
    }

    @Override
    public void visit(List<Element> list) {
        try {
            if (list.isEmpty()) {
                this.mySink.write("{}");
            } else if (list.size() == 1 && !(list.get(0) instanceof DocumentElement) && !(list.get(0) instanceof ArrayElement)) {
                this.mySink.write("{ ");
                boolean bl = this.mySuppressNames;
                this.mySuppressNames = false;
                list.get(0).accept(this);
                this.mySuppressNames = bl;
                this.mySink.write(" }");
            } else {
                this.mySink.write(123);
                ++this.myIndentLevel;
                boolean bl = this.mySuppressNames;
                this.mySuppressNames = false;
                boolean bl2 = true;
                for (Element element : list) {
                    if (!bl2) {
                        this.mySink.write(",");
                    }
                    this.nl();
                    element.accept(this);
                    bl2 = false;
                }
                this.mySuppressNames = bl;
                --this.myIndentLevel;
                this.nl();
                this.mySink.write(125);
            }
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitArray(String string, List<Element> list) {
        try {
            this.writeName(string);
            if (list.isEmpty()) {
                this.mySink.write("[]");
            } else if (list.size() == 1 && !(list.get(0) instanceof DocumentElement) && !(list.get(0) instanceof ArrayElement)) {
                this.mySink.write("[ ");
                boolean bl = this.mySuppressNames;
                this.mySuppressNames = true;
                list.get(0).accept(this);
                this.mySuppressNames = bl;
                this.mySink.write(" ]");
            } else {
                this.mySink.write("[");
                ++this.myIndentLevel;
                boolean bl = this.mySuppressNames;
                this.mySuppressNames = true;
                boolean bl2 = true;
                for (Element element : list) {
                    if (!bl2) {
                        this.mySink.write(", ");
                    }
                    this.nl();
                    element.accept(this);
                    bl2 = false;
                }
                this.mySuppressNames = bl;
                --this.myIndentLevel;
                this.nl();
                this.mySink.append(']');
            }
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitBinary(String string, byte by, byte[] byArray) {
        try {
            this.writeName(string);
            this.mySink.write("BinData( ");
            this.mySink.write(Integer.toString(by));
            this.mySink.write(", '");
            this.mySink.write(IOUtils.toBase64(byArray));
            this.mySink.write("' )");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitBoolean(String string, boolean bl) {
        try {
            this.writeName(string);
            this.mySink.write(Boolean.toString(bl));
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitDBPointer(String string, String string2, String string3, ObjectId objectId) {
        try {
            this.writeName(string);
            this.mySink.write("DBPointer( ");
            this.writeQuotedString(string2);
            this.mySink.write(", ");
            this.writeQuotedString(string3);
            this.mySink.write(", ");
            this.writeObjectId(objectId);
            this.mySink.write(" )");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitDocument(String string, List<Element> list) {
        try {
            this.writeName(string);
            this.visit(list);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitDouble(String string, double d) {
        try {
            this.writeName(string);
            this.mySink.write(Double.toString(d));
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitInteger(String string, int n) {
        try {
            this.writeName(string);
            this.mySink.write(Integer.toString(n));
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitJavaScript(String string, String string2) {
        try {
            this.writeName(string);
            this.mySink.write("{ $code : ");
            this.writeQuotedString(string2);
            this.mySink.write(" }");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitJavaScript(String string, String string2, Document document) {
        try {
            this.writeName(string);
            this.mySink.write("{ $code : ");
            this.writeQuotedString(string2);
            this.mySink.write(", $scope : ");
            document.accept(this);
            this.mySink.write(" }");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitLong(String string, long l) {
        try {
            this.writeName(string);
            this.mySink.write("NumberLong('");
            this.mySink.write(Long.toString(l));
            this.mySink.write("')");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitMaxKey(String string) {
        try {
            this.writeName(string);
            this.mySink.write("MaxKey()");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitMinKey(String string) {
        try {
            this.writeName(string);
            this.mySink.write("MinKey()");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitMongoTimestamp(String string, long l) {
        try {
            long l2 = l >> 32 & 0xFFFFFFFFL;
            long l3 = l & 0xFFFFFFFFL;
            this.writeName(string);
            this.mySink.write("Timestamp(");
            this.mySink.write(Long.toString(l2 * 1000L));
            this.mySink.write(", ");
            this.mySink.write(Long.toString(l3));
            this.mySink.write(41);
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitNull(String string) {
        try {
            this.writeName(string);
            this.mySink.write("null");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitObjectId(String string, ObjectId objectId) {
        try {
            this.writeName(string);
            this.writeObjectId(objectId);
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitRegularExpression(String string, String string2, String string3) {
        try {
            this.writeName(string);
            this.mySink.write("{ $regex : '");
            this.mySink.write(string2);
            if (string3.isEmpty()) {
                this.mySink.write("' }");
            } else {
                this.mySink.write("', $options : '");
                this.mySink.write(string3);
                this.mySink.write("' }");
            }
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitString(String string, String string2) {
        try {
            this.writeName(string);
            this.writeQuotedString(string2);
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitSymbol(String string, String string2) {
        try {
            this.writeName(string);
            if (SYMBOL_PATTERN.matcher(string2).matches()) {
                this.mySink.write(string2);
            } else {
                this.writeQuotedString(string2);
            }
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    @Override
    public void visitTimestamp(String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        simpleDateFormat.setTimeZone(UTC);
        try {
            this.writeName(string);
            this.mySink.write("ISODate('");
            this.mySink.write(simpleDateFormat.format(new Date(l)));
            this.mySink.write("')");
            this.mySink.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    protected boolean isSuppressNames() {
        return this.mySuppressNames;
    }

    protected void nl() throws IOException {
        if (!this.myOneLine) {
            this.mySink.write(NL);
            for (int i = 0; i < this.myIndentLevel; ++i) {
                this.mySink.write("  ");
            }
        } else {
            this.mySink.write(32);
        }
    }

    protected void setSuppressNames(boolean bl) {
        this.mySuppressNames = bl;
    }

    protected void writeName(String string) throws IOException {
        if (!this.mySuppressNames) {
            if (SYMBOL_PATTERN.matcher(string).matches()) {
                this.mySink.write(string);
            } else {
                this.writeQuotedString(string);
            }
            this.mySink.write(" : ");
        }
    }

    protected void writeObjectId(ObjectId objectId) throws IOException {
        this.mySink.write("ObjectId('");
        String string = Integer.toHexString(objectId.getTimestamp());
        this.mySink.write("00000000".substring(string.length()));
        this.mySink.write(string);
        string = Long.toHexString(objectId.getMachineId());
        this.mySink.write("0000000000000000".substring(string.length()));
        this.mySink.write(string);
        this.mySink.write("')");
    }

    protected void writeQuotedString(String string) throws IOException {
        if (string.indexOf(39) < 0) {
            this.mySink.write(39);
            this.mySink.write(string);
            this.mySink.write(39);
        } else if (string.indexOf(34) < 0) {
            this.mySink.write(34);
            this.mySink.write(string);
            this.mySink.write(34);
        } else {
            this.mySink.write(39);
            this.mySink.write(string.replaceAll("'", "\\\\'"));
            this.mySink.write(39);
        }
    }
}

