/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;

public class MongoTimestampElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.MONGO_TIMESTAMP;
    private static final long serialVersionUID = -402083578422199042L;
    private final long myTimestamp;

    public MongoTimestampElement(String string, long l) {
        super(string);
        this.myTimestamp = l;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMongoTimestamp(this.getName(), this.getTime());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            MongoTimestampElement mongoTimestampElement = (MongoTimestampElement)object;
            bl = super.equals(object) && this.myTimestamp == mongoTimestampElement.myTimestamp;
        }
        return bl;
    }

    public long getTime() {
        return this.myTimestamp;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Long getValueAsObject() {
        return this.myTimestamp;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (int)(this.myTimestamp >> 32 & 0xFFFFFFFFFFFFFFFFL);
        n = 31 * n + (int)(this.myTimestamp & 0xFFFFFFFFFFFFFFFFL);
        return n;
    }

    @Override
    public MongoTimestampElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new MongoTimestampElement(string, this.myTimestamp);
    }
}

