/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.io.EndianUtils;
import com.allanbank.mongodb.util.IOUtils;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ObjectId
implements Serializable {
    public static final long MACHINE_ID;
    private static final AtomicLong COUNTER;
    private static final long serialVersionUID = -3035334151717895487L;
    private final long myMachineId;
    private final int myTimestamp;

    private static int now() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    private static long processId() {
        return MACHINE_ID + (COUNTER.incrementAndGet() & 0xFFFFFFL);
    }

    public ObjectId() {
        this(ObjectId.now(), ObjectId.processId());
    }

    public ObjectId(int n, long l) {
        this.myTimestamp = n;
        this.myMachineId = l;
    }

    public ObjectId(String string) throws IllegalArgumentException {
        if (string.length() != 24) {
            throw new IllegalArgumentException("Invalid ObjectId value.  Must be a 24 character hex string.");
        }
        byte[] byArray = IOUtils.hexToBytes(string);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = byArray[i] & 0xFF;
            n += (n2 <<= 8 * i);
        }
        long l = 0L;
        for (int i = 4; i < 12; ++i) {
            long l2 = byArray[i] & 0xFF;
            l += (l2 <<= 8 * (i - 4));
        }
        this.myTimestamp = EndianUtils.swap(n);
        this.myMachineId = EndianUtils.swap(l);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            ObjectId objectId = (ObjectId)object;
            bl = this.myMachineId == objectId.myMachineId && this.myTimestamp == objectId.myTimestamp;
        }
        return bl;
    }

    public int getCounterField() {
        return (int)(this.myMachineId & 0xFFFFFFL);
    }

    public long getMachineId() {
        return this.myMachineId;
    }

    public int getMachineIdentifier() {
        return (int)(this.myMachineId >> 40 & 0xFFFFFFL);
    }

    public int getPidField() {
        return (int)(this.myMachineId >> 24 & 0xFFFFL);
    }

    public int getTimestamp() {
        return this.myTimestamp;
    }

    public int hashCode() {
        int n = 0;
        n += (int)(this.myMachineId >> 32 & 0xFFFFFFFFFFFFFFFFL);
        n += (int)(this.myMachineId & 0xFFFFFFFFFFFFFFFFL);
        return n += this.myTimestamp;
    }

    public String toHexString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toHexString(this.myTimestamp);
        stringBuilder.append("00000000".substring(string.length()));
        stringBuilder.append(string);
        string = Long.toHexString(this.myMachineId);
        stringBuilder.append("0000000000000000".substring(string.length()));
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ObjectId(");
        stringBuilder.append(this.toHexString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    static {
        int n;
        Object object;
        long l = 0L;
        SecureRandom secureRandom = new SecureRandom();
        try {
            boolean bl = true;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            try {
                object = NetworkInterface.getNetworkInterfaces();
                while (object.hasMoreElements()) {
                    try {
                        NetworkInterface networkInterface = object.nextElement();
                        if (networkInterface.isLoopback()) continue;
                        messageDigest.update(networkInterface.getHardwareAddress());
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        throwable.hashCode();
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.hashCode();
            }
            if (!bl) {
                messageDigest.update(InetAddress.getLocalHost().getHostName().getBytes("UTF8"));
            }
            object = messageDigest.digest();
            l += (long)(object[0] & 0xFF);
            l <<= 8;
            l += (long)(object[1] & 0xFF);
            l <<= 8;
            l += (long)(object[2] & 0xFF);
            l <<= 8;
        }
        catch (Throwable throwable) {
            for (int i = 0; i < 3; ++i) {
                l += (long)secureRandom.nextInt(256);
                l <<= 8;
            }
        }
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            object = runtimeMXBean.getName();
            int n2 = ((String)object).indexOf(64);
            if (n2 >= 0) {
                String string = ((String)object).substring(0, n2);
                n = Integer.parseInt(string);
            } else {
                n = secureRandom.nextInt();
            }
        }
        catch (Throwable throwable) {
            n = secureRandom.nextInt();
        }
        l += (long)(n >> 8 & 0xFF);
        l <<= 8;
        MACHINE_ID = (l += (long)(n & 0xFF)) << 24;
        COUNTER = new AtomicLong(secureRandom.nextLong() & 0xFFFFFFL);
    }
}

