/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.util.Assertions;

public class StringElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.STRING;
    private static final long serialVersionUID = 2279503881395893379L;
    private final String myValue;

    public StringElement(String string, String string2) {
        super(string);
        Assertions.assertNotNull(string2, "String element's value cannot be null.");
        this.myValue = string2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitString(this.getName(), this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            StringElement stringElement = (StringElement)object;
            bl = super.equals(object) && this.nullSafeEquals(this.myValue, stringElement.myValue);
        }
        return bl;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    public String getValue() {
        return this.myValue;
    }

    @Override
    public String getValueAsObject() {
        return this.getValue();
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myValue != null ? this.myValue.hashCode() : 3);
        return n;
    }

    @Override
    public StringElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new StringElement(string, this.myValue);
    }
}

