/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import com.allanbank.mongodb.util.Assertions;

public class SymbolElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.SYMBOL;
    private static final long serialVersionUID = -3181997000292958333L;
    private final String mySymbol;

    public SymbolElement(String string, String string2) {
        super(string);
        Assertions.assertNotNull(string2, "Symbol element's symbol cannot be null.");
        this.mySymbol = string2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSymbol(this.getName(), this.getSymbol());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            SymbolElement symbolElement = (SymbolElement)object;
            bl = super.equals(object) && this.nullSafeEquals(this.mySymbol, symbolElement.mySymbol);
        }
        return bl;
    }

    public String getSymbol() {
        return this.mySymbol;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public String getValueAsObject() {
        return this.getSymbol();
    }

    @Override
    public String getValueAsString() {
        return this.getSymbol();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.mySymbol != null ? this.mySymbol.hashCode() : 3);
        return n;
    }

    @Override
    public SymbolElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new SymbolElement(string, this.mySymbol);
    }
}

