/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.element;

import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.AbstractElement;
import java.util.Date;

public class TimestampElement
extends AbstractElement {
    public static final ElementType TYPE = ElementType.UTC_TIMESTAMP;
    private static final long serialVersionUID = 949598909338399091L;
    private final long myTimestamp;

    public TimestampElement(String string, long l) {
        super(string);
        this.myTimestamp = l;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitTimestamp(this.getName(), this.getTime());
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            TimestampElement timestampElement = (TimestampElement)object;
            bl = super.equals(object) && this.myTimestamp == timestampElement.myTimestamp;
        }
        return bl;
    }

    public long getTime() {
        return this.myTimestamp;
    }

    @Override
    public ElementType getType() {
        return TYPE;
    }

    @Override
    public Date getValueAsObject() {
        return new Date(this.getTime());
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (int)(this.myTimestamp & 0xFFFFFFFFFFFFFFFFL);
        n = 31 * n + (int)(this.myTimestamp >> 32 & 0xFFFFFFFFFFFFFFFFL);
        return n;
    }

    @Override
    public TimestampElement withName(String string) {
        if (this.getName().equals(string)) {
            return this;
        }
        return new TimestampElement(string, this.myTimestamp);
    }
}

