/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.impl;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.JsonSerializationVisitor;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.util.PatternUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RootDocument
implements Document {
    public static final List<Element> EMPTY_ELEMENTS = Collections.emptyList();
    protected static final Class<Element> ELEMENT_TYPE = Element.class;
    private static final long serialVersionUID = -2875918328146027036L;
    private final AtomicReference<Map<String, Element>> myElementMap;
    private final AtomicReference<List<Element>> myElements = new AtomicReference();
    private final boolean myIdKnownPresent;

    public RootDocument(Element ... elementArray) {
        this.myElementMap = new AtomicReference();
        if (elementArray.length > 0) {
            this.myElements.set(Collections.unmodifiableList(new ArrayList<Element>(Arrays.asList(elementArray))));
        } else {
            this.myElements.set(EMPTY_ELEMENTS);
        }
        this.myIdKnownPresent = false;
    }

    public RootDocument(List<Element> list) {
        this(list, false);
    }

    public RootDocument(List<Element> list, boolean bl) {
        this.myElementMap = new AtomicReference();
        if (list != null && !list.isEmpty()) {
            this.myElements.set(Collections.unmodifiableList(new ArrayList<Element>(list)));
        } else {
            this.myElements.set(EMPTY_ELEMENTS);
        }
        this.myIdKnownPresent = bl;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this.getElements());
    }

    @Override
    public Document asDocument() {
        return this;
    }

    @Override
    public boolean contains(String string) {
        return this.myIdKnownPresent && "_id".equals(string) || this.getElementMap().containsKey(string);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null) {
            if (this.getClass() == object.getClass()) {
                RootDocument rootDocument = (RootDocument)object;
                bl = this.myElements.get().equals(rootDocument.myElements.get());
            } else if (object instanceof Document) {
                Document document = (Document)object;
                bl = this.myElements.get().equals(document.getElements());
            }
        }
        return bl;
    }

    @Override
    public <E extends Element> List<E> find(Class<E> clazz, String ... stringArray) {
        List list = Collections.emptyList();
        if (0 < stringArray.length) {
            List<Element> list2 = this.myElements.get();
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            list = new ArrayList();
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                for (Element element : list2) {
                    if (!pattern.matcher(element.getName()).matches()) continue;
                    list.addAll(element.find(clazz, stringArray2));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                for (Element element : list2) {
                    if (!string.equals(element.getName())) continue;
                    list.addAll(element.find(clazz, stringArray2));
                }
            }
        }
        return list;
    }

    @Override
    public List<Element> find(String ... stringArray) {
        return this.find(ELEMENT_TYPE, stringArray);
    }

    @Override
    public <E extends Element> E findFirst(Class<E> clazz, String ... stringArray) {
        E e = null;
        if (0 < stringArray.length) {
            List<Element> list = this.myElements.get();
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            try {
                Pattern pattern = PatternUtils.toPattern(string);
                Iterator<Element> iterator = list.iterator();
                while (iterator.hasNext() && e == null) {
                    Element element = iterator.next();
                    if (!pattern.matcher(element.getName()).matches()) continue;
                    e = element.findFirst(clazz, stringArray2);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Iterator<Element> iterator = list.iterator();
                while (iterator.hasNext() && e == null) {
                    Element element = iterator.next();
                    if (!string.equals(element.getName())) continue;
                    e = element.findFirst(clazz, stringArray2);
                }
            }
        }
        return e;
    }

    @Override
    public Element findFirst(String ... stringArray) {
        return this.findFirst(ELEMENT_TYPE, stringArray);
    }

    @Override
    public <E extends Element> E get(Class<E> clazz, String string) {
        Element element = this.get(string);
        if (element != null && clazz.isAssignableFrom(element.getClass())) {
            return (E)((Element)clazz.cast(element));
        }
        return null;
    }

    @Override
    public Element get(String string) {
        return this.getElementMap().get(string);
    }

    @Override
    public List<Element> getElements() {
        return this.myElements.get();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.myElements.get().hashCode();
        return n;
    }

    public void injectId() {
        if (!this.contains("_id")) {
            List<Element> list = this.myElements.get();
            ArrayList<Element> arrayList = new ArrayList<Element>();
            arrayList.add(new ObjectIdElement("_id", new ObjectId()));
            arrayList.addAll(list);
            if (this.myElements.compareAndSet(list, arrayList)) {
                this.myElementMap.set(null);
            }
        }
    }

    @Override
    public Iterator<Element> iterator() {
        return this.getElements().iterator();
    }

    @Override
    @Deprecated
    public <E extends Element> List<E> queryPath(Class<E> clazz, String ... stringArray) {
        return this.find(clazz, stringArray);
    }

    @Override
    @Deprecated
    public List<Element> queryPath(String ... stringArray) {
        return this.find(stringArray);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializationVisitor jsonSerializationVisitor = new JsonSerializationVisitor(stringWriter, false);
        this.accept(jsonSerializationVisitor);
        return stringWriter.toString();
    }

    private Map<String, Element> getElementMap() {
        if (this.myElementMap.get() == null) {
            List<Element> list = this.myElements.get();
            HashMap<String, Element> hashMap = new HashMap<String, Element>(list.size() + list.size());
            for (Element element : list) {
                hashMap.put(element.getName(), element);
            }
            this.myElementMap.compareAndSet(null, hashMap);
        }
        return this.myElementMap.get();
    }
}

