/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DBPointerElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.JavaScriptElement;
import com.allanbank.mongodb.bson.element.JavaScriptWithScopeElement;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.MaxKeyElement;
import com.allanbank.mongodb.bson.element.MinKeyElement;
import com.allanbank.mongodb.bson.element.MongoTimestampElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.bson.element.UuidElement;
import com.allanbank.mongodb.bson.impl.RootDocument;
import com.allanbank.mongodb.bson.io.EndianUtils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;

public class BsonInputStream
extends FilterInputStream {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private long myBytesRead = 0L;
    private final StringBuilder myStringBuilder = new StringBuilder(64);

    public BsonInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long getBytesRead() {
        return this.myBytesRead;
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        ++this.myBytesRead;
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray, 0, byArray.length);
        this.myBytesRead += (long)n;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        this.myBytesRead += (long)n3;
        return n3;
    }

    public String readCString() throws EOFException, IOException {
        this.myStringBuilder.setLength(0);
        CharsetDecoder charsetDecoder = null;
        ByteBuffer byteBuffer = null;
        CharBuffer charBuffer = null;
        int n = this.read();
        while (n > 0) {
            if (byteBuffer == null) {
                if (n < 128) {
                    this.myStringBuilder.append((char)n);
                } else {
                    charsetDecoder = UTF8.newDecoder();
                    charBuffer = CharBuffer.allocate(64);
                    byteBuffer = ByteBuffer.allocate(64);
                    byteBuffer.put((byte)n);
                }
            } else {
                byteBuffer.put((byte)n);
                if (!byteBuffer.hasRemaining()) {
                    byteBuffer.flip();
                    charsetDecoder.decode(byteBuffer, charBuffer, false);
                    charBuffer.flip();
                    this.myStringBuilder.append(charBuffer);
                    charBuffer.clear();
                    byteBuffer.compact();
                }
            }
            n = this.read();
        }
        if (n < 0) {
            throw new EOFException();
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
            charsetDecoder.decode(byteBuffer, charBuffer, true);
            charBuffer.flip();
            this.myStringBuilder.append(charBuffer);
        }
        return this.myStringBuilder.toString();
    }

    public Document readDocument() throws EOFException, IOException {
        this.readInt();
        return new RootDocument(this.readElements());
    }

    public int readInt() throws EOFException, IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 32; i += 8) {
            n = this.read();
            n2 |= n;
            n3 += n << i;
        }
        if (n2 < 0) {
            throw new EOFException();
        }
        return n3;
    }

    public long readLong() throws EOFException, IOException {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < 64; i += 8) {
            n = this.read();
            n2 |= n;
            l += (long)n << i;
        }
        if (n2 < 0) {
            throw new EOFException();
        }
        return l;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        this.myBytesRead += l2;
        return l2;
    }

    protected ArrayElement readArrayElement() throws EOFException, IOException {
        String string = this.readCString();
        this.readInt();
        return new ArrayElement(string, this.readElements());
    }

    protected BinaryElement readBinaryElement() throws EOFException, IOException {
        String string = this.readCString();
        int n = this.readInt();
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        if (n2 == 2) {
            int n3 = this.readInt();
            assert (n3 == n - 4) : "Binary Element Subtye 2 length should be outer length - 4.";
            n -= 4;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        if (n2 == 3 || n2 == 4) {
            try {
                return new UuidElement(string, (byte)n2, byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.getCause();
            }
        }
        return new BinaryElement(string, (byte)n2, byArray);
    }

    protected DocumentElement readDocumentElement() throws EOFException, IOException {
        String string = this.readCString();
        this.readInt();
        return new DocumentElement(string, this.readElements(), true);
    }

    protected Element readElement(byte by) throws EOFException, IOException {
        ElementType elementType = ElementType.valueOf(by);
        if (elementType == null) {
            throw new StreamCorruptedException("Unknown element type: 0x" + Integer.toHexString(by & 0xFF) + ".");
        }
        switch (elementType) {
            case ARRAY: {
                return this.readArrayElement();
            }
            case BINARY: {
                return this.readBinaryElement();
            }
            case DB_POINTER: {
                String string;
                String string2 = this.readCString();
                String string3 = string = this.readString();
                String string4 = "";
                int n = string.indexOf(46);
                if (0 <= n) {
                    string3 = string.substring(0, n);
                    string4 = string.substring(n + 1);
                }
                return new DBPointerElement(string2, string3, string4, new ObjectId(EndianUtils.swap(this.readInt()), EndianUtils.swap(this.readLong())));
            }
            case DOCUMENT: {
                return this.readDocumentElement();
            }
            case DOUBLE: {
                return new DoubleElement(this.readCString(), Double.longBitsToDouble(this.readLong()));
            }
            case BOOLEAN: {
                return new BooleanElement(this.readCString(), this.read() == 1);
            }
            case INTEGER: {
                return new IntegerElement(this.readCString(), this.readInt());
            }
            case JAVA_SCRIPT: {
                return new JavaScriptElement(this.readCString(), this.readString());
            }
            case JAVA_SCRIPT_WITH_SCOPE: {
                String string = this.readCString();
                this.readInt();
                return new JavaScriptWithScopeElement(string, this.readString(), this.readDocument());
            }
            case LONG: {
                return new LongElement(this.readCString(), this.readLong());
            }
            case MAX_KEY: {
                return new MaxKeyElement(this.readCString());
            }
            case MIN_KEY: {
                return new MinKeyElement(this.readCString());
            }
            case MONGO_TIMESTAMP: {
                return new MongoTimestampElement(this.readCString(), this.readLong());
            }
            case NULL: {
                return new NullElement(this.readCString());
            }
            case OBJECT_ID: {
                return new ObjectIdElement(this.readCString(), new ObjectId(EndianUtils.swap(this.readInt()), EndianUtils.swap(this.readLong())));
            }
            case REGEX: {
                return new RegularExpressionElement(this.readCString(), this.readCString(), this.readCString());
            }
            case STRING: {
                return new StringElement(this.readCString(), this.readString());
            }
            case SYMBOL: {
                return new SymbolElement(this.readCString(), this.readString());
            }
            case UTC_TIMESTAMP: {
                return new TimestampElement(this.readCString(), this.readLong());
            }
        }
        throw new StreamCorruptedException("Unknown element type: " + elementType.name() + ".");
    }

    protected List<Element> readElements() throws EOFException, IOException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = this.read();
        while (n > 0) {
            arrayList.add(this.readElement((byte)n));
            n = this.read();
        }
        if (n < 0) {
            throw new EOFException();
        }
        return arrayList;
    }

    protected void readFully(byte[] byArray) throws EOFException, IOException {
        int n;
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += n) {
            n = this.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    protected String readString() throws EOFException, IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new String(byArray, 0, byArray.length - 1, UTF8);
    }
}

