/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.WriteVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class BsonOutputStream {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    protected IOException myError;
    protected final OutputStream myOutput;
    protected final WriteVisitor myWriteVisitor;

    public BsonOutputStream(OutputStream outputStream) {
        this.myOutput = outputStream;
        this.myWriteVisitor = new WriteVisitor(this);
    }

    public IOException getError() {
        return this.myError;
    }

    public boolean hasError() {
        return this.myError != null;
    }

    public void reset() {
        this.myError = null;
    }

    public int sizeOf(Document document) {
        return this.myWriteVisitor.sizeOf(document);
    }

    public int sizeOfCString(String ... stringArray) {
        int n = 0;
        for (String string : stringArray) {
            n += this.myWriteVisitor.utf8Size(string);
        }
        return n + 1;
    }

    public int sizeOfString(String string) {
        return 4 + this.myWriteVisitor.utf8Size(string) + 1;
    }

    public void writeByte(byte by) {
        try {
            this.myOutput.write(by);
        }
        catch (IOException iOException) {
            this.myError = iOException;
        }
    }

    public void writeBytes(byte[] byArray) {
        try {
            this.myOutput.write(byArray);
        }
        catch (IOException iOException) {
            this.myError = iOException;
        }
    }

    public void writeCString(String ... stringArray) {
        for (String string : stringArray) {
            this.writeUtf8(string);
        }
        this.writeByte((byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(Document document) throws IOException {
        try {
            document.accept(this.myWriteVisitor);
            if (this.myWriteVisitor.hasError()) {
                throw this.myWriteVisitor.getError();
            }
        }
        finally {
            this.myWriteVisitor.reset();
        }
    }

    public void writeInt(int n) {
        try {
            this.myOutput.write(n);
            this.myOutput.write(n >> 8);
            this.myOutput.write(n >> 16);
            this.myOutput.write(n >> 24);
        }
        catch (IOException iOException) {
            this.myError = iOException;
        }
    }

    public void writeLong(long l) {
        try {
            this.myOutput.write((int)l);
            this.myOutput.write((int)(l >> 8));
            this.myOutput.write((int)(l >> 16));
            this.myOutput.write((int)(l >> 24));
            this.myOutput.write((int)(l >> 32));
            this.myOutput.write((int)(l >> 40));
            this.myOutput.write((int)(l >> 48));
            this.myOutput.write((int)(l >> 56));
        }
        catch (IOException iOException) {
            this.myError = iOException;
        }
    }

    public void writeString(String string) {
        this.writeInt(this.myWriteVisitor.utf8Size(string) + 1);
        this.writeUtf8(string);
        this.writeByte((byte)0);
    }

    protected void writeUtf8(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                this.writeByte((byte)c);
                continue;
            }
            if (c < '\u0800') {
                this.writeByte((byte)(0xC0 | c >> 6));
                this.writeByte((byte)(0x80 | c & 0x3F));
                continue;
            }
            this.writeBytes(string.substring(i).getBytes(UTF8));
            return;
        }
    }
}

