/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BufferingWriteVisitor;
import com.allanbank.mongodb.bson.io.RandomAccessOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferingBsonOutputStream
extends FilterOutputStream {
    private final BufferingWriteVisitor myVisitor;

    public BufferingBsonOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.myVisitor = new BufferingWriteVisitor();
    }

    public BufferingBsonOutputStream(RandomAccessOutputStream randomAccessOutputStream) {
        super(randomAccessOutputStream);
        this.myVisitor = new BufferingWriteVisitor(randomAccessOutputStream);
    }

    public long write(Document document) throws IOException {
        document.accept(this.myVisitor);
        long l = this.myVisitor.getSize();
        if (this.out != this.myVisitor.getOutputBuffer()) {
            this.myVisitor.writeTo(this.out);
            this.myVisitor.reset();
        }
        return l;
    }
}

