/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.io.EndianUtils;
import com.allanbank.mongodb.bson.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class BufferingWriteVisitor
implements Visitor {
    protected final RandomAccessOutputStream myOutputBuffer;

    public BufferingWriteVisitor() {
        this(new RandomAccessOutputStream());
    }

    public BufferingWriteVisitor(RandomAccessOutputStream randomAccessOutputStream) {
        this.myOutputBuffer = randomAccessOutputStream;
    }

    public long getSize() {
        return this.myOutputBuffer.getPosition();
    }

    public void reset() {
        this.myOutputBuffer.reset();
    }

    @Override
    public void visit(List<Element> list) {
        long l = this.myOutputBuffer.getPosition();
        this.myOutputBuffer.writeInt(0);
        for (Element element : list) {
            element.accept(this);
        }
        this.myOutputBuffer.writeByte((byte)0);
        int n = (int)(this.myOutputBuffer.getPosition() - l);
        this.myOutputBuffer.writeIntAt(l, n);
    }

    @Override
    public void visitArray(String string, List<Element> list) {
        this.myOutputBuffer.writeByte(ElementType.ARRAY.getToken());
        this.myOutputBuffer.writeCString(string);
        this.visit(list);
    }

    @Override
    public void visitBinary(String string, byte by, byte[] byArray) {
        this.myOutputBuffer.writeByte(ElementType.BINARY.getToken());
        this.myOutputBuffer.writeCString(string);
        switch (by) {
            case 2: {
                this.myOutputBuffer.writeInt(byArray.length + 4);
                this.myOutputBuffer.writeByte(by);
                this.myOutputBuffer.writeInt(byArray.length);
                this.myOutputBuffer.writeBytes(byArray);
                break;
            }
            default: {
                this.myOutputBuffer.writeInt(byArray.length);
                this.myOutputBuffer.writeByte(by);
                this.myOutputBuffer.writeBytes(byArray);
            }
        }
    }

    @Override
    public void visitBoolean(String string, boolean bl) {
        this.myOutputBuffer.writeByte(ElementType.BOOLEAN.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeByte(bl ? (byte)1 : 0);
    }

    @Override
    public void visitDBPointer(String string, String string2, String string3, ObjectId objectId) {
        this.myOutputBuffer.writeByte(ElementType.DB_POINTER.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeString(string2 + "." + string3);
        this.myOutputBuffer.writeInt(EndianUtils.swap(objectId.getTimestamp()));
        this.myOutputBuffer.writeLong(EndianUtils.swap(objectId.getMachineId()));
    }

    @Override
    public void visitDocument(String string, List<Element> list) {
        this.myOutputBuffer.writeByte(ElementType.DOCUMENT.getToken());
        this.myOutputBuffer.writeCString(string);
        this.visit(list);
    }

    @Override
    public void visitDouble(String string, double d) {
        this.myOutputBuffer.writeByte(ElementType.DOUBLE.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void visitInteger(String string, int n) {
        this.myOutputBuffer.writeByte(ElementType.INTEGER.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeInt(n);
    }

    @Override
    public void visitJavaScript(String string, String string2) {
        this.myOutputBuffer.writeByte(ElementType.JAVA_SCRIPT.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeString(string2);
    }

    @Override
    public void visitJavaScript(String string, String string2, Document document) {
        this.myOutputBuffer.writeByte(ElementType.JAVA_SCRIPT_WITH_SCOPE.getToken());
        this.myOutputBuffer.writeCString(string);
        long l = this.myOutputBuffer.getPosition();
        this.myOutputBuffer.writeInt(0);
        this.myOutputBuffer.writeString(string2);
        document.accept(this);
        int n = (int)(this.myOutputBuffer.getPosition() - l);
        this.myOutputBuffer.writeIntAt(l, n);
    }

    @Override
    public void visitLong(String string, long l) {
        this.myOutputBuffer.writeByte(ElementType.LONG.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeLong(l);
    }

    @Override
    public void visitMaxKey(String string) {
        this.myOutputBuffer.writeByte(ElementType.MAX_KEY.getToken());
        this.myOutputBuffer.writeCString(string);
    }

    @Override
    public void visitMinKey(String string) {
        this.myOutputBuffer.writeByte(ElementType.MIN_KEY.getToken());
        this.myOutputBuffer.writeCString(string);
    }

    @Override
    public void visitMongoTimestamp(String string, long l) {
        this.myOutputBuffer.writeByte(ElementType.MONGO_TIMESTAMP.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeLong(l);
    }

    @Override
    public void visitNull(String string) {
        this.myOutputBuffer.writeByte(ElementType.NULL.getToken());
        this.myOutputBuffer.writeCString(string);
    }

    @Override
    public void visitObjectId(String string, ObjectId objectId) {
        this.myOutputBuffer.writeByte(ElementType.OBJECT_ID.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeInt(EndianUtils.swap(objectId.getTimestamp()));
        this.myOutputBuffer.writeLong(EndianUtils.swap(objectId.getMachineId()));
    }

    @Override
    public void visitRegularExpression(String string, String string2, String string3) {
        this.myOutputBuffer.writeByte(ElementType.REGEX.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeCString(string2);
        this.myOutputBuffer.writeCString(string3);
    }

    @Override
    public void visitString(String string, String string2) {
        this.myOutputBuffer.writeByte(ElementType.STRING.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeString(string2);
    }

    @Override
    public void visitSymbol(String string, String string2) {
        this.myOutputBuffer.writeByte(ElementType.SYMBOL.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeString(string2);
    }

    @Override
    public void visitTimestamp(String string, long l) {
        this.myOutputBuffer.writeByte(ElementType.UTC_TIMESTAMP.getToken());
        this.myOutputBuffer.writeCString(string);
        this.myOutputBuffer.writeLong(l);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.myOutputBuffer.writeTo(outputStream);
    }

    protected RandomAccessOutputStream getOutputBuffer() {
        return this.myOutputBuffer;
    }
}

