/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class RandomAccessOutputStream
extends OutputStream {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int MAX_BUFFER_SIZE = 8192;
    private static final int MIN_BUFFER_SIZE = 512;
    private final List<byte[]> myBuffers;
    private byte[] myCurrentBuffer = new byte[512];
    private int myCurrentBufferIndex = 0;
    private int myCurrentBufferOffset = 0;
    private final byte[] myIntegerBytes;
    private long mySize = 0L;

    public RandomAccessOutputStream() {
        this.myBuffers = new ArrayList<byte[]>();
        this.myBuffers.add(this.myCurrentBuffer);
        this.myIntegerBytes = new byte[8];
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public long getPosition() {
        return this.getSize();
    }

    public long getSize() {
        return this.mySize;
    }

    public void reset() {
        this.mySize = 0L;
        this.myCurrentBufferOffset = 0;
        this.myCurrentBufferIndex = 0;
        this.myCurrentBuffer = this.myBuffers.get(0);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; i += n3) {
            if (this.myCurrentBuffer.length <= this.myCurrentBufferOffset) {
                this.nextBuffer();
            }
            int n4 = this.myCurrentBuffer.length - this.myCurrentBufferOffset;
            n3 = Math.min(n2 - i, n4);
            System.arraycopy(byArray, n + i, this.myCurrentBuffer, this.myCurrentBufferOffset, n3);
            this.myCurrentBufferOffset += n3;
            this.mySize += (long)n3;
        }
    }

    @Override
    public void write(int n) {
        if (this.myCurrentBuffer.length <= this.myCurrentBufferOffset) {
            this.nextBuffer();
        }
        this.myCurrentBuffer[this.myCurrentBufferOffset] = (byte)n;
        ++this.myCurrentBufferOffset;
        ++this.mySize;
    }

    public void writeAt(long l, byte[] byArray) {
        this.writeAt(l, byArray, 0, byArray.length);
    }

    public void writeAt(long l, byte[] byArray, int n, int n2) {
        int n3;
        long l2;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0 || l + (long)n2 > this.getSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n4 = 0;
        byte[] byArray2 = this.myBuffers.get(n4);
        for (l2 = l; (long)byArray2.length <= l2; l2 -= (long)this.myBuffers.get(n4).length) {
            byArray2 = this.myBuffers.get(++n4);
        }
        int n5 = (int)l2;
        for (int i = 0; i < n2; i += n3) {
            if (byArray2.length <= n5) {
                byArray2 = this.myBuffers.get(++n4);
                n5 = 0;
            }
            int n6 = byArray2.length - n5;
            n3 = Math.min(n2 - i, n6);
            System.arraycopy(byArray, n + i, byArray2, n5, n3);
            n5 += n3;
        }
    }

    public void writeAt(long l, int n) {
        int n2 = 0;
        byte[] byArray = this.myBuffers.get(n2);
        for (long i = l; (long)byArray.length <= i; i -= (long)this.myBuffers.get(n2).length) {
            byArray = this.myBuffers.get(++n2);
        }
        byArray[(int)i] = (byte)n;
    }

    public void writeByte(byte by) {
        this.write(by & 0xFF);
    }

    public void writeBytes(byte[] byArray) {
        this.write(byArray);
    }

    public void writeCString(String ... stringArray) {
        for (String string : stringArray) {
            this.writeBytes(string.getBytes(UTF8));
        }
        this.writeByte((byte)0);
    }

    public void writeInt(int n) {
        this.myIntegerBytes[0] = (byte)(n & 0xFF);
        this.myIntegerBytes[1] = (byte)(n >> 8 & 0xFF);
        this.myIntegerBytes[2] = (byte)(n >> 16 & 0xFF);
        this.myIntegerBytes[3] = (byte)(n >> 24 & 0xFF);
        this.write(this.myIntegerBytes, 0, 4);
    }

    public void writeIntAt(long l, int n) {
        this.myIntegerBytes[0] = (byte)(n & 0xFF);
        this.myIntegerBytes[1] = (byte)(n >> 8 & 0xFF);
        this.myIntegerBytes[2] = (byte)(n >> 16 & 0xFF);
        this.myIntegerBytes[3] = (byte)(n >> 24 & 0xFF);
        this.writeAt(l, this.myIntegerBytes, 0, 4);
    }

    public void writeLong(long l) {
        this.myIntegerBytes[0] = (byte)(l & 0xFFL);
        this.myIntegerBytes[1] = (byte)(l >> 8 & 0xFFL);
        this.myIntegerBytes[2] = (byte)(l >> 16 & 0xFFL);
        this.myIntegerBytes[3] = (byte)(l >> 24 & 0xFFL);
        this.myIntegerBytes[4] = (byte)(l >> 32 & 0xFFL);
        this.myIntegerBytes[5] = (byte)(l >> 40 & 0xFFL);
        this.myIntegerBytes[6] = (byte)(l >> 48 & 0xFFL);
        this.myIntegerBytes[7] = (byte)(l >> 56 & 0xFFL);
        this.write(this.myIntegerBytes, 0, 8);
    }

    public void writeString(String string) {
        byte[] byArray = string.getBytes(UTF8);
        this.writeInt(byArray.length + 1);
        this.writeBytes(byArray);
        this.writeByte((byte)0);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this.myCurrentBufferIndex; ++i) {
            outputStream.write(this.myBuffers.get(i));
        }
        outputStream.write(this.myCurrentBuffer, 0, this.myCurrentBufferOffset);
    }

    protected void nextBuffer() {
        ++this.myCurrentBufferIndex;
        if (this.myCurrentBufferIndex < this.myBuffers.size()) {
            this.myCurrentBuffer = this.myBuffers.get(this.myCurrentBufferIndex);
        } else {
            this.myCurrentBuffer = new byte[Math.min(this.myCurrentBuffer.length << 1, 8192)];
            this.myBuffers.add(this.myCurrentBuffer);
        }
        this.myCurrentBufferOffset = 0;
    }
}

