/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.ObjectId;
import java.nio.charset.Charset;
import java.util.List;

public class SizeOfVisitor
implements Visitor {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private CachedSizeNode myHead = null;
    private int mySize = 0;
    private CachedSizeNode myTail = null;

    public int computeCStringSize(String string) {
        return this.utf8Size(string) + 1;
    }

    public int computeStringSize(String string) {
        return 4 + this.utf8Size(string) + 1;
    }

    public int getSize() {
        return this.mySize;
    }

    public void reset() {
        this.mySize = 0;
        this.myTail = null;
        this.myHead = null;
    }

    public void rewind() {
        this.mySize = 0;
        if (this.myHead != null) {
            this.myHead = this.myHead.myNext;
        }
    }

    public int utf8Size(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                ++n;
                continue;
            }
            if (c < '\u0800') {
                n += 2;
                continue;
            }
            return n + string.substring(i).getBytes(UTF8).length;
        }
        return n;
    }

    @Override
    public void visit(List<Element> list) {
        if (this.myHead != null && this.myHead.myElements == list) {
            this.mySize += this.myHead.mySize;
        } else {
            CachedSizeNode cachedSizeNode = new CachedSizeNode(list);
            if (this.myHead == null) {
                this.myHead = this.myTail = cachedSizeNode;
            } else {
                this.myTail.setNext(cachedSizeNode);
                this.myTail = cachedSizeNode;
            }
            int n = this.mySize;
            this.mySize += 4;
            for (Element element : list) {
                element.accept(this);
            }
            ++this.mySize;
            cachedSizeNode.setSize(this.mySize - n);
        }
    }

    @Override
    public void visitArray(String string, List<Element> list) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.visit(list);
    }

    @Override
    public void visitBinary(String string, byte by, byte[] byArray) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        switch (by) {
            case 2: {
                this.mySize += 9 + byArray.length;
                break;
            }
            default: {
                this.mySize += 5 + byArray.length;
            }
        }
    }

    @Override
    public void visitBoolean(String string, boolean bl) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        ++this.mySize;
    }

    @Override
    public void visitDBPointer(String string, String string2, String string3, ObjectId objectId) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2 + "." + string3);
        this.mySize += 12;
    }

    @Override
    public void visitDocument(String string, List<Element> list) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.visit(list);
    }

    @Override
    public void visitDouble(String string, double d) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    @Override
    public void visitInteger(String string, int n) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 4;
    }

    @Override
    public void visitJavaScript(String string, String string2) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2);
    }

    @Override
    public void visitJavaScript(String string, String string2, Document document) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 4;
        this.mySize += this.computeStringSize(string2);
        document.accept(this);
    }

    @Override
    public void visitLong(String string, long l) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    @Override
    public void visitMaxKey(String string) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
    }

    @Override
    public void visitMinKey(String string) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
    }

    @Override
    public void visitMongoTimestamp(String string, long l) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    @Override
    public void visitNull(String string) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
    }

    @Override
    public void visitObjectId(String string, ObjectId objectId) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 12;
    }

    @Override
    public void visitRegularExpression(String string, String string2, String string3) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeCStringSize(string2);
        this.mySize += this.computeCStringSize(string3);
    }

    @Override
    public void visitString(String string, String string2) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2);
    }

    @Override
    public void visitSymbol(String string, String string2) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += this.computeStringSize(string2);
    }

    @Override
    public void visitTimestamp(String string, long l) {
        ++this.mySize;
        this.mySize += this.computeCStringSize(string);
        this.mySize += 8;
    }

    protected static final class CachedSizeNode {
        List<Element> myElements;
        CachedSizeNode myNext;
        int mySize;

        public CachedSizeNode(List<Element> list) {
            this.myElements = list;
            this.mySize = 0;
            this.myNext = null;
        }

        public List<Element> getElements() {
            return this.myElements;
        }

        public CachedSizeNode getNext() {
            return this.myNext;
        }

        public int getSize() {
            return this.mySize;
        }

        public void setNext(CachedSizeNode cachedSizeNode) {
            this.myNext = cachedSizeNode;
        }

        public void setSize(int n) {
            this.mySize = n;
        }
    }
}

