/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.io;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.Visitor;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.EndianUtils;
import com.allanbank.mongodb.bson.io.SizeOfVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class WriteVisitor
implements Visitor {
    protected final BsonOutputStream myOutput;
    protected final SizeOfVisitor mySizeVisitor;

    public WriteVisitor(BsonOutputStream bsonOutputStream) {
        this.myOutput = bsonOutputStream;
        this.mySizeVisitor = new SizeOfVisitor();
    }

    public WriteVisitor(OutputStream outputStream) {
        this.myOutput = new BsonOutputStream(outputStream);
        this.mySizeVisitor = new SizeOfVisitor();
    }

    public IOException getError() {
        return this.myOutput.getError();
    }

    public boolean hasError() {
        return this.myOutput.hasError();
    }

    public void reset() {
        this.mySizeVisitor.reset();
        this.myOutput.reset();
    }

    public int sizeOf(Document document) {
        this.mySizeVisitor.rewind();
        document.accept(this.mySizeVisitor);
        return this.mySizeVisitor.getSize();
    }

    public int utf8Size(String string) {
        return this.mySizeVisitor.utf8Size(string);
    }

    @Override
    public void visit(List<Element> list) {
        this.mySizeVisitor.rewind();
        this.mySizeVisitor.visit(list);
        this.myOutput.writeInt(this.mySizeVisitor.getSize());
        for (Element element : list) {
            element.accept(this);
        }
        this.myOutput.writeByte((byte)0);
    }

    @Override
    public void visitArray(String string, List<Element> list) {
        this.myOutput.writeByte(ElementType.ARRAY.getToken());
        this.myOutput.writeCString(string);
        this.visit(list);
    }

    @Override
    public void visitBinary(String string, byte by, byte[] byArray) {
        this.myOutput.writeByte(ElementType.BINARY.getToken());
        this.myOutput.writeCString(string);
        switch (by) {
            case 2: {
                this.myOutput.writeInt(byArray.length + 4);
                this.myOutput.writeByte(by);
                this.myOutput.writeInt(byArray.length);
                this.myOutput.writeBytes(byArray);
                break;
            }
            default: {
                this.myOutput.writeInt(byArray.length);
                this.myOutput.writeByte(by);
                this.myOutput.writeBytes(byArray);
            }
        }
    }

    @Override
    public void visitBoolean(String string, boolean bl) {
        this.myOutput.writeByte(ElementType.BOOLEAN.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeByte(bl ? (byte)1 : 0);
    }

    @Override
    public void visitDBPointer(String string, String string2, String string3, ObjectId objectId) {
        this.myOutput.writeByte(ElementType.DB_POINTER.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2 + "." + string3);
        this.myOutput.writeInt(EndianUtils.swap(objectId.getTimestamp()));
        this.myOutput.writeLong(EndianUtils.swap(objectId.getMachineId()));
    }

    @Override
    public void visitDocument(String string, List<Element> list) {
        this.myOutput.writeByte(ElementType.DOCUMENT.getToken());
        this.myOutput.writeCString(string);
        this.visit(list);
    }

    @Override
    public void visitDouble(String string, double d) {
        this.myOutput.writeByte(ElementType.DOUBLE.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void visitInteger(String string, int n) {
        this.myOutput.writeByte(ElementType.INTEGER.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeInt(n);
    }

    @Override
    public void visitJavaScript(String string, String string2) {
        this.myOutput.writeByte(ElementType.JAVA_SCRIPT.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2);
    }

    @Override
    public void visitJavaScript(String string, String string2, Document document) {
        this.myOutput.writeByte(ElementType.JAVA_SCRIPT_WITH_SCOPE.getToken());
        this.myOutput.writeCString(string);
        this.mySizeVisitor.rewind();
        document.accept(this.mySizeVisitor);
        this.myOutput.writeInt(4 + this.mySizeVisitor.computeStringSize(string2) + this.mySizeVisitor.getSize());
        this.myOutput.writeString(string2);
        document.accept(this);
    }

    @Override
    public void visitLong(String string, long l) {
        this.myOutput.writeByte(ElementType.LONG.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(l);
    }

    @Override
    public void visitMaxKey(String string) {
        this.myOutput.writeByte(ElementType.MAX_KEY.getToken());
        this.myOutput.writeCString(string);
    }

    @Override
    public void visitMinKey(String string) {
        this.myOutput.writeByte(ElementType.MIN_KEY.getToken());
        this.myOutput.writeCString(string);
    }

    @Override
    public void visitMongoTimestamp(String string, long l) {
        this.myOutput.writeByte(ElementType.MONGO_TIMESTAMP.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(l);
    }

    @Override
    public void visitNull(String string) {
        this.myOutput.writeByte(ElementType.NULL.getToken());
        this.myOutput.writeCString(string);
    }

    @Override
    public void visitObjectId(String string, ObjectId objectId) {
        this.myOutput.writeByte(ElementType.OBJECT_ID.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeInt(EndianUtils.swap(objectId.getTimestamp()));
        this.myOutput.writeLong(EndianUtils.swap(objectId.getMachineId()));
    }

    @Override
    public void visitRegularExpression(String string, String string2, String string3) {
        this.myOutput.writeByte(ElementType.REGEX.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeCString(string2);
        this.myOutput.writeCString(string3);
    }

    @Override
    public void visitString(String string, String string2) {
        this.myOutput.writeByte(ElementType.STRING.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2);
    }

    @Override
    public void visitSymbol(String string, String string2) {
        this.myOutput.writeByte(ElementType.SYMBOL.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeString(string2);
    }

    @Override
    public void visitTimestamp(String string, long l) {
        this.myOutput.writeByte(ElementType.UTC_TIMESTAMP.getToken());
        this.myOutput.writeCString(string);
        this.myOutput.writeLong(l);
    }
}

