/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.json;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.element.JsonSerializationVisitor;
import com.allanbank.mongodb.bson.json.JsonParser;
import com.allanbank.mongodb.bson.json.ParseException;
import com.allanbank.mongodb.error.JsonException;
import com.allanbank.mongodb.error.JsonParseException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class Json {
    public static Document parse(Reader reader) throws JsonParseException {
        JsonParser jsonParser = new JsonParser();
        try {
            Object object = jsonParser.parse(reader);
            if (object instanceof Document) {
                return (Document)object;
            }
            throw new JsonParseException("Unknown type returned from the parsed document: " + object);
        }
        catch (ParseException parseException) {
            if (parseException.currentToken != null) {
                throw new JsonParseException(parseException.getMessage(), (Throwable)parseException, parseException.currentToken.beginLine, parseException.currentToken.beginColumn);
            }
            throw new JsonParseException(parseException);
        }
        catch (RuntimeException runtimeException) {
            throw new JsonParseException(runtimeException);
        }
    }

    public static Document parse(String string) throws JsonParseException {
        return Json.parse(new StringReader(string));
    }

    public static String serialize(DocumentAssignable documentAssignable) throws JsonException {
        StringWriter stringWriter = new StringWriter();
        Json.serialize(documentAssignable, stringWriter);
        return stringWriter.toString();
    }

    public static void serialize(DocumentAssignable documentAssignable, Writer writer) throws JsonException {
        JsonSerializationVisitor jsonSerializationVisitor = new JsonSerializationVisitor(writer, true);
        documentAssignable.asDocument().accept(jsonSerializationVisitor);
    }

    private Json() {
    }
}

