/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson.json;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.json.JavaCharStream;
import com.allanbank.mongodb.bson.json.JsonParserConstants;
import com.allanbank.mongodb.bson.json.JsonParserTokenManager;
import com.allanbank.mongodb.bson.json.ParseException;
import com.allanbank.mongodb.bson.json.Token;
import com.allanbank.mongodb.error.JsonParseException;
import com.allanbank.mongodb.util.IOUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

class JsonParser
implements JsonParserConstants {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd"};
    public JsonParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[26];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public JsonParser() {
        this(new StringReader(""));
    }

    public Object parse(String string) throws ParseException {
        this.ReInit(new StringReader(string));
        return this.parse();
    }

    public Object parse(Reader reader) throws ParseException {
        this.ReInit(reader);
        return this.parse();
    }

    private byte[] toBinaryFromBase64(Token token) throws JsonParseException {
        String string = this.trimQuotes(token.image);
        try {
            return IOUtils.base64ToBytes(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonParseException(illegalArgumentException.getMessage() + " (line " + token.beginLine + ", column " + token.beginColumn + ")", (Throwable)illegalArgumentException, token.beginLine, token.beginColumn);
        }
    }

    private byte[] toBinaryFromHex(Token token) throws JsonParseException {
        String string = this.trimQuotes(token.image);
        try {
            return IOUtils.hexToBytes(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonParseException(illegalArgumentException.getMessage() + " (line " + token.beginLine + ", column " + token.beginColumn + ")", (Throwable)illegalArgumentException, token.beginLine, token.beginColumn);
        }
    }

    private Date toDate(Token token) throws JsonParseException {
        java.text.ParseException parseException = null;
        String string = this.trimQuotes(token.image);
        for (String string2 : DATE_FORMATS) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setTimeZone(UTC);
            try {
                return simpleDateFormat.parse(string);
            }
            catch (java.text.ParseException parseException2) {
                parseException = parseException2;
            }
        }
        throw new JsonParseException("Could not parse the time string '" + string + "' @ line " + token.beginLine + ", column " + token.beginColumn + ".", (Throwable)parseException, token.beginLine, token.beginColumn);
    }

    private Date toDateFromEpoch(Token token) throws JsonParseException {
        try {
            return new Date(Long.parseLong(token.image));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException("Could not parse the time milliseconds '" + token.image + "' @ line " + token.beginLine + ", column " + token.beginColumn + ".", (Throwable)numberFormatException, token.beginLine, token.beginColumn);
        }
    }

    private int toIntFromHex(Token token) throws JsonParseException {
        String string = this.trimQuotes(token.image);
        if (string.startsWith("0x") || string.startsWith("0X")) {
            string = string.substring(2);
        }
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException(numberFormatException.getMessage() + " (line " + token.beginLine + ", column " + token.beginColumn + ")", (Throwable)numberFormatException, token.beginLine, token.beginColumn);
        }
    }

    private long toMongoTimestamp(Token token, Token token2) throws JsonParseException {
        long l = 0L;
        String string = this.trimQuotes(token.image);
        String string2 = this.trimQuotes(token2.image);
        try {
            long l2 = Long.parseLong(string) & 0xFFFFFFFFL;
            l = TimeUnit.MILLISECONDS.toSeconds(l2);
            l <<= 32;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException(numberFormatException.getMessage() + " (line " + token.beginLine + ", column " + token.beginColumn + ")", (Throwable)numberFormatException, token.beginLine, token.beginColumn);
        }
        return l += Long.parseLong(string2) & 0xFFFFFFFFL;
    }

    private long toMongoTimestamp(Token token, Token token2, Token token3, Token token4) {
        try {
            long l = Long.parseLong(this.trimQuotes(token2.image));
            long l2 = Long.parseLong(this.trimQuotes(token4.image));
            String string = this.trimQuotes(token.image);
            String string2 = this.trimQuotes(token3.image);
            long l3 = 0L;
            if ("t".equals(string) && "i".equals(string2)) {
                l3 = TimeUnit.MILLISECONDS.toSeconds(l);
                l3 <<= 32;
                l3 += l2 & 0xFFFFFFFFL;
            } else if ("t".equals(string2) && "i".equals(string)) {
                l3 = TimeUnit.MILLISECONDS.toSeconds(l2);
                l3 <<= 32;
                l3 += l & 0xFFFFFFFFL;
            } else {
                throw new JsonParseException("Invalid MongoDB Timestamp document at line " + token.beginLine + ", column " + token.beginColumn + ":", token.beginLine, token.beginColumn);
            }
            return l3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException(numberFormatException.getMessage() + " (line " + token.beginLine + ", column " + token.beginColumn + ")", (Throwable)numberFormatException, token.beginLine, token.beginColumn);
        }
    }

    private ObjectId toObjectId(Token token) throws JsonParseException {
        boolean bl = false;
        long l = 0L;
        String string = this.trimQuotes(token.image);
        try {
            return new ObjectId(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonParseException(illegalArgumentException.getMessage() + " (line " + token.beginLine + ", column " + token.beginColumn + ")", (Throwable)illegalArgumentException, token.beginLine, token.beginColumn);
        }
    }

    private String trimQuotes(String string) {
        if (!string.isEmpty()) {
            char c;
            int n = string.length();
            char c2 = string.charAt(0);
            if (c2 == (c = string.charAt(n - 1)) && (c2 == '\"' || c2 == '\'')) {
                return string.substring(1, n - 1);
            }
        }
        return string;
    }

    protected final Object parse() throws ParseException {
        Iterable<Element> iterable = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                iterable = this.document(null);
                break;
            }
            case 13: {
                iterable = this.array(null);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return iterable;
    }

    private final Document document(DocumentBuilder documentBuilder) throws ParseException {
        DocumentBuilder documentBuilder2 = documentBuilder;
        if (documentBuilder2 == null) {
            documentBuilder2 = BuilderFactory.start();
        }
        this.jj_consume_token(11);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: 
            case 38: 
            case 57: {
                this.members(documentBuilder2);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(12);
        return documentBuilder2.build();
    }

    private final List<Element> array(ArrayBuilder arrayBuilder) throws ParseException {
        ArrayBuilder arrayBuilder2 = arrayBuilder;
        if (arrayBuilder2 == null) {
            arrayBuilder2 = BuilderFactory.startArray();
        }
        this.jj_consume_token(13);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 20: 
            case 21: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 57: {
                this.elements(arrayBuilder2);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(14);
        return Arrays.asList(arrayBuilder2.build());
    }

    private final void members(DocumentBuilder documentBuilder) throws ParseException {
        this.pair(documentBuilder);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.members(documentBuilder);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
    }

    private final void pair(DocumentBuilder documentBuilder) throws ParseException {
        Token token = null;
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                token = this.jj_consume_token(57);
                string = token.image;
                break;
            }
            case 28: {
                token = this.jj_consume_token(28);
                string = this.trimQuotes(token.image);
                break;
            }
            case 38: {
                token = this.jj_consume_token(38);
                string = token.image;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(16);
        this.documentValue(string, documentBuilder);
    }

    private final void elements(ArrayBuilder arrayBuilder) throws ParseException {
        this.arrayValue(arrayBuilder);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.elements(arrayBuilder);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
    }

    private final void arrayValue(ArrayBuilder arrayBuilder) throws ParseException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        if (this.jj_2_1(2)) {
            this.jj_consume_token(11);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 48: {
                    this.jj_consume_token(48);
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    this.jj_consume_token(49);
                    this.jj_consume_token(16);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            token = this.jj_consume_token(21);
                            break;
                        }
                        case 28: {
                            token3 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (token != null) {
                        arrayBuilder.addBinary((byte)Integer.parseInt(token.image), this.toBinaryFromBase64(token2));
                        break;
                    }
                    arrayBuilder.addBinary((byte)this.toIntFromHex(token3), this.toBinaryFromBase64(token2));
                    break;
                }
                case 49: {
                    this.jj_consume_token(49);
                    this.jj_consume_token(16);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            token = this.jj_consume_token(21);
                            break;
                        }
                        case 28: {
                            token3 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(15);
                    this.jj_consume_token(48);
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(28);
                    if (token != null) {
                        arrayBuilder.addBinary((byte)Integer.parseInt(token.image), this.toBinaryFromBase64(token2));
                        break;
                    }
                    arrayBuilder.addBinary((byte)this.toIntFromHex(token3), this.toBinaryFromBase64(token2));
                    break;
                }
                case 50: {
                    this.jj_consume_token(50);
                    this.jj_consume_token(16);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            token = this.jj_consume_token(21);
                            break;
                        }
                        case 28: {
                            token2 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (token != null) {
                        arrayBuilder.add(this.toDateFromEpoch(token));
                        break;
                    }
                    arrayBuilder.add(this.toDate(token2));
                    break;
                }
                case 51: {
                    this.jj_consume_token(51);
                    this.jj_consume_token(16);
                    this.jj_consume_token(11);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            token = this.jj_consume_token(57);
                            break;
                        }
                        case 28: {
                            token = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            token3 = this.jj_consume_token(57);
                            break;
                        }
                        case 28: {
                            token3 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(16);
                    token4 = this.jj_consume_token(21);
                    this.jj_consume_token(12);
                    arrayBuilder.addMongoTimestamp(this.toMongoTimestamp(token, token2, token3, token4));
                    break;
                }
                case 52: {
                    this.jj_consume_token(52);
                    this.jj_consume_token(16);
                    token = this.jj_consume_token(28);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 15: {
                            this.jj_consume_token(15);
                            this.jj_consume_token(53);
                            this.jj_consume_token(16);
                            token2 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                        }
                    }
                    if (token2 != null) {
                        arrayBuilder.addRegularExpression(this.trimQuotes(token.image), this.trimQuotes(token2.image));
                        break;
                    }
                    arrayBuilder.addRegularExpression(this.trimQuotes(token.image), "");
                    break;
                }
                case 53: {
                    this.jj_consume_token(53);
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    this.jj_consume_token(52);
                    this.jj_consume_token(16);
                    token = this.jj_consume_token(28);
                    arrayBuilder.addRegularExpression(this.trimQuotes(token.image), this.trimQuotes(token2.image));
                    break;
                }
                case 54: {
                    this.jj_consume_token(54);
                    this.jj_consume_token(16);
                    token = this.jj_consume_token(28);
                    arrayBuilder.addObjectId(this.toObjectId(token));
                    break;
                }
                case 55: {
                    this.jj_consume_token(55);
                    this.jj_consume_token(16);
                    this.jj_consume_token(21);
                    arrayBuilder.addMaxKey();
                    break;
                }
                case 56: {
                    this.jj_consume_token(56);
                    this.jj_consume_token(16);
                    this.jj_consume_token(21);
                    arrayBuilder.addMinKey();
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(12);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    this.document(arrayBuilder.push());
                    break;
                }
                case 13: {
                    this.array(arrayBuilder.pushArray());
                    break;
                }
                case 38: {
                    token = this.jj_consume_token(38);
                    arrayBuilder.addSymbol(token.image);
                    break;
                }
                case 57: {
                    token = this.jj_consume_token(57);
                    arrayBuilder.addSymbol(token.image);
                    break;
                }
                case 28: {
                    token = this.jj_consume_token(28);
                    arrayBuilder.addString(this.trimQuotes(token.image));
                    break;
                }
                case 20: {
                    token = this.jj_consume_token(20);
                    arrayBuilder.addDouble(Double.parseDouble(token.image));
                    break;
                }
                case 21: {
                    token = this.jj_consume_token(21);
                    long l = Long.parseLong(token.image);
                    if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
                        arrayBuilder.addInteger((int)l);
                        break;
                    }
                    arrayBuilder.addLong(l);
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    arrayBuilder.addBoolean(true);
                    break;
                }
                case 9: {
                    this.jj_consume_token(9);
                    arrayBuilder.addBoolean(false);
                    break;
                }
                case 10: {
                    this.jj_consume_token(10);
                    arrayBuilder.addNull();
                    break;
                }
                case 39: {
                    this.jj_consume_token(39);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    arrayBuilder.addBinary((byte)Integer.parseInt(token.image), this.toBinaryFromBase64(token2));
                    break;
                }
                case 40: {
                    this.jj_consume_token(40);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    arrayBuilder.addBinary((byte)Integer.parseInt(token.image), this.toBinaryFromHex(token2));
                    break;
                }
                case 41: {
                    this.jj_consume_token(41);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    arrayBuilder.add(this.toDate(token));
                    break;
                }
                case 42: {
                    this.jj_consume_token(42);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    arrayBuilder.addLong(Long.parseLong(this.trimQuotes(token.image)));
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    arrayBuilder.addObjectId(this.toObjectId(token));
                    break;
                }
                case 44: {
                    this.jj_consume_token(44);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(21);
                    this.jj_consume_token(70);
                    arrayBuilder.addMongoTimestamp(this.toMongoTimestamp(token, token2));
                    break;
                }
                case 45: {
                    this.jj_consume_token(45);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: {
                            this.jj_consume_token(69);
                            this.jj_consume_token(70);
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                        }
                    }
                    arrayBuilder.addMaxKey();
                    break;
                }
                case 46: {
                    this.jj_consume_token(46);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: {
                            this.jj_consume_token(69);
                            this.jj_consume_token(70);
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                        }
                    }
                    arrayBuilder.addMinKey();
                    break;
                }
                case 47: {
                    this.jj_consume_token(47);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    this.jj_consume_token(43);
                    this.jj_consume_token(69);
                    token3 = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    this.jj_consume_token(70);
                    arrayBuilder.addDBPointer(this.trimQuotes(token.image), this.trimQuotes(token2.image), this.toObjectId(token3));
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private final void documentValue(String string, DocumentBuilder documentBuilder) throws ParseException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        if (this.jj_2_2(2)) {
            this.jj_consume_token(11);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 48: {
                    this.jj_consume_token(48);
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    this.jj_consume_token(49);
                    this.jj_consume_token(16);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            token = this.jj_consume_token(21);
                            break;
                        }
                        case 28: {
                            token3 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (token != null) {
                        documentBuilder.addBinary(string, (byte)Integer.parseInt(token.image), this.toBinaryFromBase64(token2));
                        break;
                    }
                    documentBuilder.addBinary(string, (byte)this.toIntFromHex(token3), this.toBinaryFromBase64(token2));
                    break;
                }
                case 49: {
                    this.jj_consume_token(49);
                    this.jj_consume_token(16);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            token = this.jj_consume_token(21);
                            break;
                        }
                        case 28: {
                            token3 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(15);
                    this.jj_consume_token(48);
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(28);
                    if (token != null) {
                        documentBuilder.addBinary(string, (byte)Integer.parseInt(token.image), this.toBinaryFromBase64(token2));
                        break;
                    }
                    documentBuilder.addBinary(string, (byte)this.toIntFromHex(token3), this.toBinaryFromBase64(token2));
                    break;
                }
                case 50: {
                    this.jj_consume_token(50);
                    this.jj_consume_token(16);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            token = this.jj_consume_token(21);
                            break;
                        }
                        case 28: {
                            token2 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (token != null) {
                        documentBuilder.add(string, this.toDateFromEpoch(token));
                        break;
                    }
                    documentBuilder.add(string, this.toDate(token2));
                    break;
                }
                case 51: {
                    this.jj_consume_token(51);
                    this.jj_consume_token(16);
                    this.jj_consume_token(11);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            token = this.jj_consume_token(57);
                            break;
                        }
                        case 28: {
                            token = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            token3 = this.jj_consume_token(57);
                            break;
                        }
                        case 28: {
                            token3 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(16);
                    token4 = this.jj_consume_token(21);
                    this.jj_consume_token(12);
                    documentBuilder.addMongoTimestamp(string, this.toMongoTimestamp(token, token2, token3, token4));
                    break;
                }
                case 52: {
                    this.jj_consume_token(52);
                    this.jj_consume_token(16);
                    token = this.jj_consume_token(28);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 15: {
                            this.jj_consume_token(15);
                            this.jj_consume_token(53);
                            this.jj_consume_token(16);
                            token2 = this.jj_consume_token(28);
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                        }
                    }
                    if (token2 != null) {
                        documentBuilder.addRegularExpression(string, this.trimQuotes(token.image), this.trimQuotes(token2.image));
                        break;
                    }
                    documentBuilder.addRegularExpression(string, this.trimQuotes(token.image), "");
                    break;
                }
                case 53: {
                    this.jj_consume_token(53);
                    this.jj_consume_token(16);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    this.jj_consume_token(52);
                    this.jj_consume_token(16);
                    token = this.jj_consume_token(28);
                    documentBuilder.addRegularExpression(string, this.trimQuotes(token.image), this.trimQuotes(token2.image));
                    break;
                }
                case 54: {
                    this.jj_consume_token(54);
                    this.jj_consume_token(16);
                    token = this.jj_consume_token(28);
                    documentBuilder.addObjectId(string, this.toObjectId(token));
                    break;
                }
                case 55: {
                    this.jj_consume_token(55);
                    this.jj_consume_token(16);
                    this.jj_consume_token(21);
                    documentBuilder.addMaxKey(string);
                    break;
                }
                case 56: {
                    this.jj_consume_token(56);
                    this.jj_consume_token(16);
                    this.jj_consume_token(21);
                    documentBuilder.addMinKey(string);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(12);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    this.document(documentBuilder.push(string));
                    break;
                }
                case 13: {
                    this.array(documentBuilder.pushArray(string));
                    break;
                }
                case 38: {
                    token = this.jj_consume_token(38);
                    documentBuilder.addSymbol(string, token.image);
                    break;
                }
                case 57: {
                    token = this.jj_consume_token(57);
                    documentBuilder.addSymbol(string, token.image);
                    break;
                }
                case 28: {
                    token = this.jj_consume_token(28);
                    documentBuilder.addString(string, this.trimQuotes(token.image));
                    break;
                }
                case 20: {
                    token = this.jj_consume_token(20);
                    documentBuilder.addDouble(string, Double.parseDouble(token.image));
                    break;
                }
                case 21: {
                    token = this.jj_consume_token(21);
                    long l = Long.parseLong(token.image);
                    if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
                        documentBuilder.addInteger(string, (int)l);
                        break;
                    }
                    documentBuilder.addLong(string, l);
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    documentBuilder.addBoolean(string, true);
                    break;
                }
                case 9: {
                    this.jj_consume_token(9);
                    documentBuilder.addBoolean(string, false);
                    break;
                }
                case 10: {
                    this.jj_consume_token(10);
                    documentBuilder.addNull(string);
                    break;
                }
                case 39: {
                    this.jj_consume_token(39);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    documentBuilder.addBinary(string, (byte)Integer.parseInt(token.image), this.toBinaryFromBase64(token2));
                    break;
                }
                case 40: {
                    this.jj_consume_token(40);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    documentBuilder.addBinary(string, (byte)Integer.parseInt(token.image), this.toBinaryFromHex(token2));
                    break;
                }
                case 41: {
                    this.jj_consume_token(41);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    documentBuilder.add(string, this.toDate(token));
                    break;
                }
                case 42: {
                    this.jj_consume_token(42);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    documentBuilder.addLong(string, Long.parseLong(this.trimQuotes(token.image)));
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    documentBuilder.addObjectId(string, this.toObjectId(token));
                    break;
                }
                case 44: {
                    this.jj_consume_token(44);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(21);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(21);
                    this.jj_consume_token(70);
                    documentBuilder.addMongoTimestamp(string, this.toMongoTimestamp(token, token2));
                    break;
                }
                case 45: {
                    this.jj_consume_token(45);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: {
                            this.jj_consume_token(69);
                            this.jj_consume_token(70);
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                        }
                    }
                    documentBuilder.addMaxKey(string);
                    break;
                }
                case 46: {
                    this.jj_consume_token(46);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 69: {
                            this.jj_consume_token(69);
                            this.jj_consume_token(70);
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                        }
                    }
                    documentBuilder.addMinKey(string);
                    break;
                }
                case 47: {
                    this.jj_consume_token(47);
                    this.jj_consume_token(69);
                    token = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    token2 = this.jj_consume_token(28);
                    this.jj_consume_token(15);
                    this.jj_consume_token(43);
                    this.jj_consume_token(69);
                    token3 = this.jj_consume_token(28);
                    this.jj_consume_token(70);
                    this.jj_consume_token(70);
                    documentBuilder.addDBPointer(string, this.trimQuotes(token.image), this.trimQuotes(token2.image), this.toObjectId(token3));
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_2() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_9() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_1() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_8() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_7() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_11() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_1()) {
            this.jj_scanpos = token;
            if (this.jj_3R_2()) {
                this.jj_scanpos = token;
                if (this.jj_3R_3()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_4()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_5()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_6()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_7()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_8()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_9()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_6() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_10() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_17() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_5() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_16() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_10()) {
            this.jj_scanpos = token;
            if (this.jj_3R_11()) {
                this.jj_scanpos = token;
                if (this.jj_3R_12()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_13()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_14()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_15()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_16()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_17()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_18()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_4() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_3() {
        return this.jj_scan_token(50);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{10240, 0x10000000, 271593216, 32768, 0x10000000, 32768, 0x10200000, 0x10200000, 0x10200000, 0x10000000, 0x10000000, 32768, 0, 0, 0, 271593216, 0x10200000, 0x10200000, 0x10200000, 0x10000000, 0x10000000, 32768, 0, 0, 0, 271593216};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0x2000040, 33619904, 0, 0x2000040, 0, 0, 0, 0, 0x2000000, 0x2000000, 0, 0x1FF0000, 0, 0, 33619904, 0, 0, 0, 0x2000000, 0x2000000, 0, 0x1FF0000, 0, 0, 33619904};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0};
    }

    public JsonParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public JsonParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 26; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 26; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public JsonParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 26; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 26; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public JsonParser(JsonParserTokenManager jsonParserTokenManager) {
        int n;
        this.token_source = jsonParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 26; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(JsonParserTokenManager jsonParserTokenManager) {
        int n;
        this.token_source = jsonParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 26; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] nArray : this.jj_expentries) {
                if (nArray.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[71];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 26; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 71; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        JsonParser.jj_la1_init_0();
        JsonParser.jj_la1_init_1();
        JsonParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

