/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.builder.AggregationGeoNear;
import com.allanbank.mongodb.builder.AggregationGroupField;
import com.allanbank.mongodb.builder.AggregationGroupId;
import com.allanbank.mongodb.builder.AggregationProjectFields;
import com.allanbank.mongodb.builder.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Aggregate {
    private final List<Element> myPipeline;
    private final ReadPreference myReadPreference;

    public static Builder builder() {
        return new Builder();
    }

    protected Aggregate(Builder builder) {
        this.myPipeline = Collections.unmodifiableList(Arrays.asList(builder.myPipeline.build()));
        this.myReadPreference = builder.myReadPreference;
    }

    public List<Element> getPipeline() {
        return this.myPipeline;
    }

    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public static class Builder {
        protected final ArrayBuilder myPipeline = BuilderFactory.startArray();
        protected ReadPreference myReadPreference;

        public Aggregate build() {
            return new Aggregate(this);
        }

        public Builder geoNear(AggregationGeoNear aggregationGeoNear) {
            return this.step("$geoNear", aggregationGeoNear.asDocument());
        }

        public Builder geoNear(AggregationGeoNear.Builder builder) {
            return this.geoNear(builder.build());
        }

        public Builder group(AggregationGroupId aggregationGroupId, AggregationGroupField ... aggregationGroupFieldArray) {
            Element[] elementArray = new Element[aggregationGroupFieldArray.length + 1];
            elementArray[0] = aggregationGroupId.toElement();
            for (int i = 0; i < aggregationGroupFieldArray.length; ++i) {
                elementArray[i + 1] = aggregationGroupFieldArray[i].toElement();
            }
            return this.step("$group", elementArray);
        }

        public Builder group(AggregationGroupId.Builder builder, AggregationGroupField ... aggregationGroupFieldArray) {
            return this.group(builder.buildId(), aggregationGroupFieldArray);
        }

        public Builder group(DocumentAssignable documentAssignable) {
            return this.step("$group", documentAssignable);
        }

        public Builder group(DocumentAssignable documentAssignable, AggregationGroupField ... aggregationGroupFieldArray) {
            return this.group(new AggregationGroupId(documentAssignable), aggregationGroupFieldArray);
        }

        public Builder limit(int n) {
            return this.step("$limit", n);
        }

        public Builder limit(long l) {
            return this.step("$limit", l);
        }

        public Builder match(DocumentAssignable documentAssignable) {
            return this.step("$match", documentAssignable);
        }

        public Builder project(AggregationProjectFields aggregationProjectFields, Element ... elementArray) {
            List<IntegerElement> list = aggregationProjectFields.toElements();
            ArrayList<Element> arrayList = new ArrayList<Element>(list.size() + elementArray.length);
            arrayList.addAll(list);
            arrayList.addAll(Arrays.asList(elementArray));
            return this.step("$project", arrayList);
        }

        public Builder project(DocumentAssignable documentAssignable) {
            return this.step("$project", documentAssignable);
        }

        public Builder reset() {
            this.myPipeline.reset();
            this.myReadPreference = null;
            return this;
        }

        public Builder setReadPreference(ReadPreference readPreference) {
            this.myReadPreference = readPreference;
            return this;
        }

        public Builder skip(int n) {
            return this.step("$skip", n);
        }

        public Builder skip(long l) {
            return this.step("$skip", l);
        }

        public Builder sort(IntegerElement ... integerElementArray) {
            return this.step("$sort", integerElementArray);
        }

        public Builder sort(String ... stringArray) {
            IntegerElement[] integerElementArray = new IntegerElement[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                integerElementArray[i] = Sort.asc(stringArray[i]);
            }
            return this.sort(integerElementArray);
        }

        public Builder step(String string, DocumentAssignable documentAssignable) {
            this.myPipeline.push().addDocument(string, documentAssignable.asDocument());
            return this;
        }

        public Builder step(String string, double d) {
            this.myPipeline.push().addDouble(string, d);
            return this;
        }

        public Builder step(String string, Element ... elementArray) {
            return this.step(string, Arrays.asList(elementArray));
        }

        public Builder step(String string, int n) {
            this.myPipeline.push().addInteger(string, n);
            return this;
        }

        public Builder step(String string, List<Element> list) {
            DocumentBuilder documentBuilder = this.myPipeline.push().push(string);
            for (Element element : list) {
                documentBuilder.add(element);
            }
            return this;
        }

        public Builder step(String string, long l) {
            this.myPipeline.push().addLong(string, l);
            return this;
        }

        public Builder step(String string, String string2) {
            this.myPipeline.push().addString(string, string2);
            return this;
        }

        public Builder unwind(String string) {
            if (string.startsWith("$")) {
                this.step("$unwind", string);
            } else {
                this.step("$unwind", "$" + string);
            }
            return this;
        }
    }
}

