/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.StringElement;

public class AggregationGroupField {
    private final Element myElement;

    public static Builder set(String string) {
        return new Builder(string);
    }

    protected AggregationGroupField(String string, String string2, int n) {
        this.myElement = new DocumentElement(string, new IntegerElement(string2, n));
    }

    protected AggregationGroupField(String string, String string2, String string3) {
        String string4 = string3;
        if (!string3.startsWith("$")) {
            string4 = "$" + string3;
        }
        this.myElement = new DocumentElement(string, new StringElement(string2, string4));
    }

    public Element toElement() {
        return this.myElement;
    }

    public static class Builder {
        private final String myFieldName;

        public Builder(String string) {
            this.myFieldName = string;
        }

        public AggregationGroupField addToSet(String string) {
            return this.uniqueValuesOf(string);
        }

        public AggregationGroupField all(String string) {
            return this.as("$push", string);
        }

        public AggregationGroupField as(String string, int n) {
            return new AggregationGroupField(this.myFieldName, string, n);
        }

        public AggregationGroupField as(String string, String string2) {
            return new AggregationGroupField(this.myFieldName, string, string2);
        }

        public AggregationGroupField average(String string) {
            return this.as("$avg", string);
        }

        public AggregationGroupField count() {
            return this.as("$sum", 1);
        }

        public AggregationGroupField first(String string) {
            return this.as("$first", string);
        }

        public AggregationGroupField last(String string) {
            return this.as("$last", string);
        }

        public AggregationGroupField maximum(String string) {
            return this.as("$max", string);
        }

        public AggregationGroupField minimum(String string) {
            return this.as("$min", string);
        }

        public AggregationGroupField push(String string) {
            return this.all(string);
        }

        public AggregationGroupField sum(String string) {
            return this.as("$sum", string);
        }

        public AggregationGroupField uniqueValuesOf(String string) {
            return this.as("$addToSet", string);
        }
    }
}

