/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.ElementType;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.DoubleElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.bson.element.JavaScriptElement;
import com.allanbank.mongodb.bson.element.JavaScriptWithScopeElement;
import com.allanbank.mongodb.bson.element.LongElement;
import com.allanbank.mongodb.bson.element.MaxKeyElement;
import com.allanbank.mongodb.bson.element.MinKeyElement;
import com.allanbank.mongodb.bson.element.MongoTimestampElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.ObjectIdElement;
import com.allanbank.mongodb.bson.element.RegularExpressionElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.bson.element.UuidElement;
import com.allanbank.mongodb.builder.ComparisonOperator;
import com.allanbank.mongodb.builder.GeospatialOperator;
import com.allanbank.mongodb.builder.MiscellaneousOperator;
import com.allanbank.mongodb.builder.Operator;
import com.allanbank.mongodb.builder.QueryBuilder;
import com.allanbank.mongodb.builder.expression.Constant;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class ConditionBuilder
implements DocumentAssignable {
    private Element myEqualsComparison;
    private final String myFieldName;
    private final Map<Operator, Element> myOtherComparisons;
    private final QueryBuilder myParent;

    protected ConditionBuilder(String string, QueryBuilder queryBuilder) {
        this.myFieldName = string;
        this.myParent = queryBuilder;
        this.myOtherComparisons = new LinkedHashMap<Operator, Element>();
    }

    public ConditionBuilder all(ArrayBuilder arrayBuilder) {
        return this.all(arrayBuilder.build());
    }

    public ConditionBuilder all(Constant ... constantArray) {
        this.myEqualsComparison = null;
        ArrayList<Element> arrayList = new ArrayList<Element>(constantArray.length);
        for (int i = 0; i < constantArray.length; ++i) {
            arrayList.add(constantArray[i].toElement(ArrayElement.nameFor(i)));
        }
        this.myOtherComparisons.put(MiscellaneousOperator.ALL, new ArrayElement(MiscellaneousOperator.ALL.getToken(), arrayList));
        return this;
    }

    public ConditionBuilder all(Element ... elementArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.ALL, new ArrayElement(MiscellaneousOperator.ALL.getToken(), elementArray));
        return this;
    }

    public ConditionBuilder and(String string) {
        return this.myParent.whereField(string);
    }

    @Override
    public Document asDocument() {
        return this.build();
    }

    public Document build() {
        return this.myParent.build();
    }

    public ConditionBuilder elementMatches(DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.ELEMENT_MATCH, new DocumentElement(MiscellaneousOperator.ELEMENT_MATCH.getToken(), documentAssignable.asDocument()));
        return this;
    }

    public ConditionBuilder equals(boolean bl) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new BooleanElement(this.getFieldName(), bl);
        return this;
    }

    public ConditionBuilder equals(byte by, byte[] byArray) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new BinaryElement(this.getFieldName(), by, byArray);
        return this;
    }

    public ConditionBuilder equals(byte[] byArray) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new BinaryElement(this.getFieldName(), byArray);
        return this;
    }

    public ConditionBuilder equals(DocumentAssignable documentAssignable) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new DocumentElement(this.getFieldName(), documentAssignable.asDocument());
        return this;
    }

    public ConditionBuilder equals(double d) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new DoubleElement(this.getFieldName(), d);
        return this;
    }

    public ConditionBuilder equals(int n) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new IntegerElement(this.getFieldName(), n);
        return this;
    }

    public ConditionBuilder equals(long l) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new LongElement(this.getFieldName(), l);
        return this;
    }

    public ConditionBuilder equals(ObjectId objectId) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new ObjectIdElement(this.getFieldName(), objectId);
        return this;
    }

    public ConditionBuilder equals(Pattern pattern) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new RegularExpressionElement(this.getFieldName(), pattern);
        return this;
    }

    public ConditionBuilder equals(String string) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new StringElement(this.getFieldName(), string);
        return this;
    }

    public ConditionBuilder equals(UUID uUID) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new UuidElement(this.getFieldName(), uUID);
        return this;
    }

    public ConditionBuilder equalsJavaScript(String string) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new JavaScriptElement(this.getFieldName(), string);
        return this;
    }

    public ConditionBuilder equalsJavaScript(String string, DocumentAssignable documentAssignable) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new JavaScriptWithScopeElement(this.getFieldName(), string, documentAssignable.asDocument());
        return this;
    }

    public ConditionBuilder equalsLegacy(UUID uUID) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new UuidElement(this.getFieldName(), 3, uUID);
        return this;
    }

    public ConditionBuilder equalsMaxKey() {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new MaxKeyElement(this.getFieldName());
        return this;
    }

    public ConditionBuilder equalsMinKey() {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new MinKeyElement(this.getFieldName());
        return this;
    }

    public ConditionBuilder equalsMongoTimestamp(long l) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new MongoTimestampElement(this.getFieldName(), l);
        return this;
    }

    public ConditionBuilder equalsNull() {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new NullElement(this.getFieldName());
        return this;
    }

    public ConditionBuilder equalsSymbol(String string) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new SymbolElement(this.getFieldName(), string);
        return this;
    }

    public ConditionBuilder equalsTimestamp(long l) {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = new TimestampElement(this.getFieldName(), l);
        return this;
    }

    public ConditionBuilder exists() {
        return this.exists(true);
    }

    public ConditionBuilder exists(boolean bl) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.EXISTS, new BooleanElement(MiscellaneousOperator.EXISTS.getToken(), bl));
        return this;
    }

    public ConditionBuilder geoWithin(DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.GEO_WITHIN, new DocumentElement(GeospatialOperator.GEO_WITHIN.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument())));
        return this;
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    public ConditionBuilder greaterThan(byte by, byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new BinaryElement(ComparisonOperator.GT.getToken(), by, byArray));
        return this;
    }

    public ConditionBuilder greaterThan(byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new BinaryElement(ComparisonOperator.GT.getToken(), byArray));
        return this;
    }

    public ConditionBuilder greaterThan(double d) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new DoubleElement(ComparisonOperator.GT.getToken(), d));
        return this;
    }

    public ConditionBuilder greaterThan(int n) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new IntegerElement(ComparisonOperator.GT.getToken(), n));
        return this;
    }

    public ConditionBuilder greaterThan(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new LongElement(ComparisonOperator.GT.getToken(), l));
        return this;
    }

    public ConditionBuilder greaterThan(ObjectId objectId) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new ObjectIdElement(ComparisonOperator.GT.getToken(), objectId));
        return this;
    }

    public ConditionBuilder greaterThan(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new StringElement(ComparisonOperator.GT.getToken(), string));
        return this;
    }

    public ConditionBuilder greaterThanMongoTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new MongoTimestampElement(ComparisonOperator.GT.getToken(), l));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualTo(byte by, byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new BinaryElement(ComparisonOperator.GTE.getToken(), by, byArray));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualTo(byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new BinaryElement(ComparisonOperator.GTE.getToken(), byArray));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualTo(double d) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new DoubleElement(ComparisonOperator.GTE.getToken(), d));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualTo(int n) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new IntegerElement(ComparisonOperator.GTE.getToken(), n));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualTo(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new LongElement(ComparisonOperator.GTE.getToken(), l));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualTo(ObjectId objectId) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new ObjectIdElement(ComparisonOperator.GTE.getToken(), objectId));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualTo(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new StringElement(ComparisonOperator.GTE.getToken(), string));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualToMongoTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new MongoTimestampElement(ComparisonOperator.GTE.getToken(), l));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualToSymbol(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new SymbolElement(ComparisonOperator.GTE.getToken(), string));
        return this;
    }

    public ConditionBuilder greaterThanOrEqualToTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GTE, new TimestampElement(ComparisonOperator.GTE.getToken(), l));
        return this;
    }

    public ConditionBuilder greaterThanSymbol(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new SymbolElement(ComparisonOperator.GT.getToken(), string));
        return this;
    }

    public ConditionBuilder greaterThanTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.GT, new TimestampElement(ComparisonOperator.GT.getToken(), l));
        return this;
    }

    public ConditionBuilder in(ArrayBuilder arrayBuilder) {
        return this.in(arrayBuilder.build());
    }

    public ConditionBuilder in(Constant ... constantArray) {
        this.myEqualsComparison = null;
        ArrayList<Element> arrayList = new ArrayList<Element>(constantArray.length);
        for (int i = 0; i < constantArray.length; ++i) {
            arrayList.add(constantArray[i].toElement(ArrayElement.nameFor(i)));
        }
        this.myOtherComparisons.put(MiscellaneousOperator.IN, new ArrayElement(MiscellaneousOperator.IN.getToken(), arrayList));
        return this;
    }

    public ConditionBuilder in(Element ... elementArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.IN, new ArrayElement(MiscellaneousOperator.IN.getToken(), elementArray));
        return this;
    }

    public ConditionBuilder instanceOf(ElementType elementType) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.TYPE, new IntegerElement(MiscellaneousOperator.TYPE.getToken(), elementType.getToken()));
        return this;
    }

    public ConditionBuilder intersects(DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.INTERSECT, new DocumentElement(GeospatialOperator.INTERSECT.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument())));
        return this;
    }

    public ConditionBuilder lessThan(byte by, byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new BinaryElement(ComparisonOperator.LT.getToken(), by, byArray));
        return this;
    }

    public ConditionBuilder lessThan(byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new BinaryElement(ComparisonOperator.LT.getToken(), byArray));
        return this;
    }

    public ConditionBuilder lessThan(double d) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new DoubleElement(ComparisonOperator.LT.getToken(), d));
        return this;
    }

    public ConditionBuilder lessThan(int n) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new IntegerElement(ComparisonOperator.LT.getToken(), n));
        return this;
    }

    public ConditionBuilder lessThan(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new LongElement(ComparisonOperator.LT.getToken(), l));
        return this;
    }

    public ConditionBuilder lessThan(ObjectId objectId) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new ObjectIdElement(ComparisonOperator.LT.getToken(), objectId));
        return this;
    }

    public ConditionBuilder lessThan(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new StringElement(ComparisonOperator.LT.getToken(), string));
        return this;
    }

    public ConditionBuilder lessThanMongoTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new MongoTimestampElement(ComparisonOperator.LT.getToken(), l));
        return this;
    }

    public ConditionBuilder lessThanOrEqualTo(byte by, byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new BinaryElement(ComparisonOperator.LTE.getToken(), by, byArray));
        return this;
    }

    public ConditionBuilder lessThanOrEqualTo(byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new BinaryElement(ComparisonOperator.LTE.getToken(), byArray));
        return this;
    }

    public ConditionBuilder lessThanOrEqualTo(double d) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new DoubleElement(ComparisonOperator.LTE.getToken(), d));
        return this;
    }

    public ConditionBuilder lessThanOrEqualTo(int n) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new IntegerElement(ComparisonOperator.LTE.getToken(), n));
        return this;
    }

    public ConditionBuilder lessThanOrEqualTo(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new LongElement(ComparisonOperator.LTE.getToken(), l));
        return this;
    }

    public ConditionBuilder lessThanOrEqualTo(ObjectId objectId) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new ObjectIdElement(ComparisonOperator.LTE.getToken(), objectId));
        return this;
    }

    public ConditionBuilder lessThanOrEqualTo(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new StringElement(ComparisonOperator.LTE.getToken(), string));
        return this;
    }

    public ConditionBuilder lessThanOrEqualToMongoTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new MongoTimestampElement(ComparisonOperator.LTE.getToken(), l));
        return this;
    }

    public ConditionBuilder lessThanOrEqualToSymbol(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new SymbolElement(ComparisonOperator.LTE.getToken(), string));
        return this;
    }

    public ConditionBuilder lessThanOrEqualToTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LTE, new TimestampElement(ComparisonOperator.LTE.getToken(), l));
        return this;
    }

    public ConditionBuilder lessThanSymbol(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new SymbolElement(ComparisonOperator.LT.getToken(), string));
        return this;
    }

    public ConditionBuilder lessThanTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.LT, new TimestampElement(ComparisonOperator.LT.getToken(), l));
        return this;
    }

    public ConditionBuilder matches(Pattern pattern) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.REG_EX, new RegularExpressionElement(MiscellaneousOperator.REG_EX.getToken(), pattern));
        return this;
    }

    public ConditionBuilder mod(int n, int n2) {
        this.myEqualsComparison = null;
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        arrayBuilder.addInteger(n);
        arrayBuilder.addInteger(n2);
        this.myOtherComparisons.put(MiscellaneousOperator.MOD, new ArrayElement(MiscellaneousOperator.MOD.getToken(), arrayBuilder.build()));
        return this;
    }

    public ConditionBuilder mod(long l, long l2) {
        this.myEqualsComparison = null;
        ArrayBuilder arrayBuilder = BuilderFactory.startArray();
        arrayBuilder.addLong(l);
        arrayBuilder.addLong(l2);
        this.myOtherComparisons.put(MiscellaneousOperator.MOD, new ArrayElement(MiscellaneousOperator.MOD.getToken(), arrayBuilder.build()));
        return this;
    }

    public ConditionBuilder near(DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new DocumentElement(GeospatialOperator.NEAR.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument())));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder near(DocumentAssignable documentAssignable, double d) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new DocumentElement(GeospatialOperator.NEAR.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument()), new DoubleElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), d)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder near(double d, double d2) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new ArrayElement(GeospatialOperator.NEAR.getToken(), new DoubleElement("0", d), new DoubleElement("1", d2)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder near(double d, double d2, double d3) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new ArrayElement(GeospatialOperator.NEAR.getToken(), new DoubleElement("0", d), new DoubleElement("1", d2)));
        this.myOtherComparisons.put(GeospatialOperator.MAX_DISTANCE_MODIFIER, new DoubleElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), d3));
        return this;
    }

    public ConditionBuilder near(int n, int n2) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new ArrayElement(GeospatialOperator.NEAR.getToken(), new IntegerElement("0", n), new IntegerElement("1", n2)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder near(int n, int n2, int n3) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new ArrayElement(GeospatialOperator.NEAR.getToken(), new IntegerElement("0", n), new IntegerElement("1", n2)));
        this.myOtherComparisons.put(GeospatialOperator.MAX_DISTANCE_MODIFIER, new IntegerElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), n3));
        return this;
    }

    public ConditionBuilder near(long l, long l2) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new ArrayElement(GeospatialOperator.NEAR.getToken(), new LongElement("0", l), new LongElement("1", l2)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder near(long l, long l2, long l3) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR, new ArrayElement(GeospatialOperator.NEAR.getToken(), new LongElement("0", l), new LongElement("1", l2)));
        this.myOtherComparisons.put(GeospatialOperator.MAX_DISTANCE_MODIFIER, new LongElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), l3));
        return this;
    }

    public ConditionBuilder nearSphere(DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new DocumentElement(GeospatialOperator.NEAR_SPHERE.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument())));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder nearSphere(DocumentAssignable documentAssignable, double d) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new DocumentElement(GeospatialOperator.NEAR_SPHERE.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument()), new DoubleElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), d)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder nearSphere(double d, double d2) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new ArrayElement(GeospatialOperator.NEAR_SPHERE.getToken(), new DoubleElement("0", d), new DoubleElement("1", d2)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder nearSphere(double d, double d2, double d3) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new ArrayElement(GeospatialOperator.NEAR_SPHERE.getToken(), new DoubleElement("0", d), new DoubleElement("1", d2)));
        this.myOtherComparisons.put(GeospatialOperator.MAX_DISTANCE_MODIFIER, new DoubleElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), d3));
        return this;
    }

    public ConditionBuilder nearSphere(int n, int n2) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new ArrayElement(GeospatialOperator.NEAR_SPHERE.getToken(), new IntegerElement("0", n), new IntegerElement("1", n2)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder nearSphere(int n, int n2, int n3) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new ArrayElement(GeospatialOperator.NEAR_SPHERE.getToken(), new IntegerElement("0", n), new IntegerElement("1", n2)));
        this.myOtherComparisons.put(GeospatialOperator.MAX_DISTANCE_MODIFIER, new IntegerElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), n3));
        return this;
    }

    public ConditionBuilder nearSphere(long l, long l2) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new ArrayElement(GeospatialOperator.NEAR_SPHERE.getToken(), new LongElement("0", l), new LongElement("1", l2)));
        this.myOtherComparisons.remove(GeospatialOperator.MAX_DISTANCE_MODIFIER);
        return this;
    }

    public ConditionBuilder nearSphere(long l, long l2, long l3) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.NEAR_SPHERE, new ArrayElement(GeospatialOperator.NEAR_SPHERE.getToken(), new LongElement("0", l), new LongElement("1", l2)));
        this.myOtherComparisons.put(GeospatialOperator.MAX_DISTANCE_MODIFIER, new LongElement(GeospatialOperator.MAX_DISTANCE_MODIFIER.getToken(), l3));
        return this;
    }

    public ConditionBuilder notEqualTo(boolean bl) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new BooleanElement(ComparisonOperator.NE.getToken(), bl));
        return this;
    }

    public ConditionBuilder notEqualTo(byte by, byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new BinaryElement(ComparisonOperator.NE.getToken(), by, byArray));
        return this;
    }

    public ConditionBuilder notEqualTo(byte[] byArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new BinaryElement(ComparisonOperator.NE.getToken(), byArray));
        return this;
    }

    public ConditionBuilder notEqualTo(DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new DocumentElement(ComparisonOperator.NE.getToken(), documentAssignable.asDocument()));
        return this;
    }

    public ConditionBuilder notEqualTo(double d) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new DoubleElement(ComparisonOperator.NE.getToken(), d));
        return this;
    }

    public ConditionBuilder notEqualTo(int n) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new IntegerElement(ComparisonOperator.NE.getToken(), n));
        return this;
    }

    public ConditionBuilder notEqualTo(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new LongElement(ComparisonOperator.NE.getToken(), l));
        return this;
    }

    public ConditionBuilder notEqualTo(ObjectId objectId) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new ObjectIdElement(ComparisonOperator.NE.getToken(), objectId));
        return this;
    }

    public ConditionBuilder notEqualTo(Pattern pattern) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new RegularExpressionElement(ComparisonOperator.NE.getToken(), pattern));
        return this;
    }

    public ConditionBuilder notEqualTo(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new StringElement(ComparisonOperator.NE.getToken(), string));
        return this;
    }

    public ConditionBuilder notEqualTo(UUID uUID) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new UuidElement(ComparisonOperator.NE.getToken(), uUID));
        return this;
    }

    public ConditionBuilder notEqualToJavaScript(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new JavaScriptElement(ComparisonOperator.NE.getToken(), string));
        return this;
    }

    public ConditionBuilder notEqualToJavaScript(String string, DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new JavaScriptWithScopeElement(ComparisonOperator.NE.getToken(), string, documentAssignable.asDocument()));
        return this;
    }

    public ConditionBuilder notEqualToLegacy(UUID uUID) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new UuidElement(ComparisonOperator.NE.getToken(), 3, uUID));
        return this;
    }

    public ConditionBuilder notEqualToMaxKey() {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new MaxKeyElement(ComparisonOperator.NE.getToken()));
        return this;
    }

    public ConditionBuilder notEqualToMinKey() {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new MinKeyElement(ComparisonOperator.NE.getToken()));
        return this;
    }

    public ConditionBuilder notEqualToMongoTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new MongoTimestampElement(ComparisonOperator.NE.getToken(), l));
        return this;
    }

    public ConditionBuilder notEqualToNull() {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new NullElement(ComparisonOperator.NE.getToken()));
        return this;
    }

    public ConditionBuilder notEqualToSymbol(String string) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new SymbolElement(ComparisonOperator.NE.getToken(), string));
        return this;
    }

    public ConditionBuilder notEqualToTimestamp(long l) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(ComparisonOperator.NE, new TimestampElement(ComparisonOperator.NE.getToken(), l));
        return this;
    }

    public ConditionBuilder notIn(ArrayBuilder arrayBuilder) {
        return this.notIn(arrayBuilder.build());
    }

    public ConditionBuilder notIn(Constant ... constantArray) {
        this.myEqualsComparison = null;
        ArrayList<Element> arrayList = new ArrayList<Element>(constantArray.length);
        for (int i = 0; i < constantArray.length; ++i) {
            arrayList.add(constantArray[i].toElement(ArrayElement.nameFor(i)));
        }
        this.myOtherComparisons.put(MiscellaneousOperator.NIN, new ArrayElement(MiscellaneousOperator.NIN.getToken(), arrayList));
        return this;
    }

    public ConditionBuilder notIn(Element ... elementArray) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.NIN, new ArrayElement(MiscellaneousOperator.NIN.getToken(), elementArray));
        return this;
    }

    public void reset() {
        this.myOtherComparisons.clear();
        this.myEqualsComparison = null;
    }

    public ConditionBuilder size(int n) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(MiscellaneousOperator.SIZE, new IntegerElement(MiscellaneousOperator.SIZE.getToken(), n));
        return this;
    }

    public ConditionBuilder where(String string) {
        this.myParent.whereJavaScript(string);
        return this;
    }

    public ConditionBuilder within(boolean bl, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D ... point2DArray) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$polygon");
        arrayBuilder.pushArray().addDouble(point2D.getX()).addDouble(point2D.getY());
        arrayBuilder.pushArray().addDouble(point2D2.getX()).addDouble(point2D2.getY());
        arrayBuilder.pushArray().addDouble(point2D3.getX()).addDouble(point2D3.getY());
        for (Point2D point2D4 : point2DArray) {
            arrayBuilder.pushArray().addDouble(point2D4.getX()).addDouble(point2D4.getY());
        }
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder within(DocumentAssignable documentAssignable) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument())));
        return this;
    }

    public ConditionBuilder within(DocumentAssignable documentAssignable, boolean bl) {
        this.myEqualsComparison = null;
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), new DocumentElement("$geometry", documentAssignable.asDocument()), new BooleanElement("$uniqueDocs", bl)));
        return this;
    }

    public ConditionBuilder within(double d, double d2, double d3) {
        return this.within(d, d2, d3, true);
    }

    public ConditionBuilder within(double d, double d2, double d3, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$center");
        arrayBuilder.pushArray().addDouble(d).addDouble(d2);
        arrayBuilder.addDouble(d3);
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder within(double d, double d2, double d3, double d4) {
        return this.within(d, d2, d3, d4, true);
    }

    public ConditionBuilder within(double d, double d2, double d3, double d4, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$box");
        arrayBuilder.pushArray().addDouble(Math.min(d, d3)).addDouble(Math.min(d2, d4));
        arrayBuilder.pushArray().addDouble(Math.max(d, d3)).addDouble(Math.max(d2, d4));
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder within(int n, int n2, int n3) {
        return this.within(n, n2, n3, true);
    }

    public ConditionBuilder within(int n, int n2, int n3, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$center");
        arrayBuilder.pushArray().addInteger(n).addInteger(n2);
        arrayBuilder.addInteger(n3);
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder within(int n, int n2, int n3, int n4) {
        return this.within(n, n2, n3, n4, true);
    }

    public ConditionBuilder within(int n, int n2, int n3, int n4, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$box");
        arrayBuilder.pushArray().addInteger(Math.min(n, n3)).addInteger(Math.min(n2, n4));
        arrayBuilder.pushArray().addInteger(Math.max(n, n3)).addInteger(Math.max(n2, n4));
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder within(long l, long l2, long l3) {
        return this.within(l, l2, l3, true);
    }

    public ConditionBuilder within(long l, long l2, long l3, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$center");
        arrayBuilder.pushArray().addLong(l).addLong(l2);
        arrayBuilder.addLong(l3);
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder within(long l, long l2, long l3, long l4) {
        return this.within(l, l2, l3, l4, true);
    }

    public ConditionBuilder within(long l, long l2, long l3, long l4, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$box");
        arrayBuilder.pushArray().addLong(Math.min(l, l3)).addLong(Math.min(l2, l4));
        arrayBuilder.pushArray().addLong(Math.max(l, l3)).addLong(Math.max(l2, l4));
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder within(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D ... point2DArray) {
        return this.within(true, point2D, point2D2, point2D3, point2DArray);
    }

    public ConditionBuilder withinOnSphere(double d, double d2, double d3) {
        return this.withinOnSphere(d, d2, d3, true);
    }

    public ConditionBuilder withinOnSphere(double d, double d2, double d3, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$centerSphere");
        arrayBuilder.pushArray().addDouble(d).addDouble(d2);
        arrayBuilder.addDouble(d3);
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder withinOnSphere(int n, int n2, int n3) {
        return this.withinOnSphere(n, n2, n3, true);
    }

    public ConditionBuilder withinOnSphere(int n, int n2, int n3, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$centerSphere");
        arrayBuilder.pushArray().addInteger(n).addInteger(n2);
        arrayBuilder.addInteger(n3);
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    public ConditionBuilder withinOnSphere(long l, long l2, long l3) {
        return this.withinOnSphere(l, l2, l3, true);
    }

    public ConditionBuilder withinOnSphere(long l, long l2, long l3, boolean bl) {
        this.myEqualsComparison = null;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("$centerSphere");
        arrayBuilder.pushArray().addLong(l).addLong(l2);
        arrayBuilder.addLong(l3);
        documentBuilder.addBoolean("$uniqueDocs", bl);
        this.myOtherComparisons.put(GeospatialOperator.WITHIN, new DocumentElement(GeospatialOperator.WITHIN.getToken(), documentBuilder.build()));
        return this;
    }

    Element buildFieldCondition() {
        if (!this.myOtherComparisons.isEmpty()) {
            return new DocumentElement(this.myFieldName, this.myOtherComparisons.values());
        }
        return this.myEqualsComparison;
    }
}

