/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.IntegerElement;

public class Find {
    public static final Document ALL = MongoCollection.ALL;
    private final boolean myAwaitData;
    private final int myBatchSize;
    private final Document myHint;
    private final String myHintName;
    private final boolean myImmortalCursor;
    private final int myLimit;
    private final long myMaximumDocumentsToScan;
    private final Document myMaximumRange;
    private final Document myMinimumRange;
    private final int myNumberToSkip;
    private final boolean myPartialOk;
    private final Document myQuery;
    private final ReadPreference myReadPreference;
    private final Document myReturnFields;
    private final boolean myReturnIndexKeysOnly;
    private final boolean myShowDiskLocation;
    private final boolean mySnapshot;
    private final Document mySort;
    private final boolean myTailable;

    public static Builder builder() {
        return new Builder();
    }

    protected Find(Builder builder) {
        this.myBatchSize = builder.myBatchSize;
        this.myHint = builder.myHint;
        this.myHintName = builder.myHintName;
        this.myLimit = builder.myLimit;
        this.myNumberToSkip = builder.myNumberToSkip;
        this.myPartialOk = builder.myPartialOk;
        this.myQuery = builder.myQuery;
        this.myReadPreference = builder.myReadPreference;
        this.myReturnFields = builder.myReturnFields;
        this.mySnapshot = builder.mySnapshot;
        this.mySort = builder.mySort;
        this.myTailable = builder.myTailable;
        this.myAwaitData = builder.myAwaitData;
        this.myImmortalCursor = builder.myImmortalCursor;
        this.myMaximumRange = builder.myMaximumRange;
        this.myMinimumRange = builder.myMinimumRange;
        this.myMaximumDocumentsToScan = builder.myMaximumDocumentsToScan;
        this.myReturnIndexKeysOnly = builder.myReturnIndexKeysOnly;
        this.myShowDiskLocation = builder.myShowDiskLocation;
    }

    public int getBatchSize() {
        return this.myBatchSize;
    }

    public Document getHint() {
        return this.myHint;
    }

    public String getHintName() {
        return this.myHintName;
    }

    public int getLimit() {
        return this.myLimit;
    }

    public long getMaximumDocumentsToScan() {
        return this.myMaximumDocumentsToScan;
    }

    public Document getMaximumRange() {
        return this.myMaximumRange;
    }

    public Document getMinimumRange() {
        return this.myMinimumRange;
    }

    public int getNumberToSkip() {
        return this.myNumberToSkip;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public Document getReturnFields() {
        return this.myReturnFields;
    }

    public Document getSort() {
        return this.mySort;
    }

    public boolean isAwaitData() {
        return this.myAwaitData;
    }

    public boolean isImmortalCursor() {
        return this.myImmortalCursor;
    }

    public boolean isPartialOk() {
        return this.myPartialOk;
    }

    public boolean isReturnIndexKeysOnly() {
        return this.myReturnIndexKeysOnly;
    }

    public boolean isShowDiskLocation() {
        return this.myShowDiskLocation;
    }

    public boolean isSnapshot() {
        return this.mySnapshot;
    }

    public boolean isTailable() {
        return this.myTailable;
    }

    public Document toQueryRequest(boolean bl) {
        return this.toQueryRequest(bl, null);
    }

    public Document toQueryRequest(boolean bl, ReadPreference readPreference) {
        if (bl || this.mySnapshot || this.myReturnIndexKeysOnly || this.myShowDiskLocation || this.mySort != null || this.myMaximumDocumentsToScan > 0L || this.myHint != null || this.myHintName != null || readPreference != null || this.myMaximumRange != null || this.myMinimumRange != null) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.add("$query", this.myQuery);
            if (bl) {
                documentBuilder.add("$explain", true);
            }
            if (this.myHint != null) {
                documentBuilder.add("$hint", this.myHint);
            } else if (this.myHintName != null) {
                documentBuilder.add("$hint", this.myHintName);
            }
            if (this.myMaximumRange != null) {
                documentBuilder.add("$max", this.myMaximumRange);
            }
            if (this.myMaximumDocumentsToScan > 0L) {
                documentBuilder.add("$maxScan", this.myMaximumDocumentsToScan);
            }
            if (this.myMinimumRange != null) {
                documentBuilder.add("$min", this.myMinimumRange);
            }
            if (this.mySort != null) {
                documentBuilder.add("$orderby", this.mySort);
            }
            if (this.myReturnIndexKeysOnly) {
                documentBuilder.add("$returnKey", true);
            }
            if (this.myShowDiskLocation) {
                documentBuilder.add("$showDiskLoc", true);
            }
            if (this.mySnapshot) {
                documentBuilder.add("$snapshot", true);
            }
            if (readPreference != null) {
                documentBuilder.add("$readPreference", readPreference);
            }
            return documentBuilder.build();
        }
        return this.myQuery;
    }

    public static class Builder {
        protected boolean myAwaitData;
        protected int myBatchSize;
        protected Document myHint;
        protected String myHintName;
        protected boolean myImmortalCursor;
        protected int myLimit;
        protected long myMaximumDocumentsToScan;
        protected Document myMaximumRange;
        protected Document myMinimumRange;
        protected int myNumberToSkip;
        protected boolean myPartialOk;
        protected Document myQuery;
        protected ReadPreference myReadPreference;
        protected Document myReturnFields;
        protected boolean myReturnIndexKeysOnly;
        protected boolean myShowDiskLocation;
        protected boolean mySnapshot;
        protected Document mySort;
        protected boolean myTailable;

        public Builder() {
            this.reset();
        }

        public Builder(DocumentAssignable documentAssignable) {
            this();
            this.myQuery = documentAssignable.asDocument();
        }

        public Builder batchSize(int n) {
            return this.setBatchSize(n);
        }

        public Find build() {
            return new Find(this);
        }

        public Builder hint(DocumentAssignable documentAssignable) {
            return this.setHint(documentAssignable);
        }

        public Builder hint(Element ... elementArray) {
            return this.setHint(elementArray);
        }

        public Builder hint(String string) {
            return this.setHint(string);
        }

        public Builder immortalCursor() {
            return this.setImmortalCursor(true);
        }

        public Builder immortalCursor(boolean bl) {
            return this.setImmortalCursor(bl);
        }

        public Builder limit(int n) {
            return this.setLimit(n);
        }

        public Builder max(DocumentAssignable documentAssignable) {
            return this.setMaximumRange(documentAssignable);
        }

        public Builder maxScan(long l) {
            return this.setMaximumDocumentsToScan(l);
        }

        public Builder min(DocumentAssignable documentAssignable) {
            return this.setMinimumRange(documentAssignable);
        }

        public Builder partialOk() {
            return this.setPartialOk(true);
        }

        public Builder partialOk(boolean bl) {
            return this.setPartialOk(bl);
        }

        public Builder query(DocumentAssignable documentAssignable) {
            return this.setQuery(documentAssignable);
        }

        public Builder readPreference(ReadPreference readPreference) {
            return this.setReadPreference(readPreference);
        }

        public Builder reset() {
            this.myBatchSize = 0;
            this.myHint = null;
            this.myHintName = null;
            this.myLimit = 0;
            this.myNumberToSkip = 0;
            this.myPartialOk = false;
            this.myQuery = ALL;
            this.myReadPreference = null;
            this.myReturnFields = null;
            this.mySnapshot = false;
            this.mySort = null;
            this.myTailable = false;
            this.myAwaitData = false;
            this.myImmortalCursor = false;
            this.myMaximumRange = null;
            this.myMinimumRange = null;
            this.myMaximumDocumentsToScan = -1L;
            this.myReturnIndexKeysOnly = false;
            this.myShowDiskLocation = false;
            return this;
        }

        public Builder returnFields(DocumentAssignable documentAssignable) {
            return this.setReturnFields(documentAssignable);
        }

        public Builder returnKey() {
            return this.setReturnIndexKeysOnly(true);
        }

        public Builder returnKey(boolean bl) {
            return this.setReturnIndexKeysOnly(bl);
        }

        public Builder setAwaitData(boolean bl) {
            this.myAwaitData = bl;
            return this;
        }

        public Builder setBatchSize(int n) {
            this.myBatchSize = n;
            return this;
        }

        public Builder setHint(DocumentAssignable documentAssignable) {
            this.myHintName = null;
            this.myHint = documentAssignable.asDocument();
            return this;
        }

        public Builder setHint(Element ... elementArray) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            for (Element element : elementArray) {
                documentBuilder.add(element);
            }
            this.myHintName = null;
            this.myHint = documentBuilder.build();
            return this;
        }

        public Builder setHint(String string) {
            this.myHintName = string;
            this.myHint = null;
            return this;
        }

        public Builder setImmortalCursor(boolean bl) {
            this.myImmortalCursor = bl;
            return this;
        }

        public Builder setLimit(int n) {
            this.myLimit = n;
            return this;
        }

        public Builder setMaximumDocumentsToScan(long l) {
            this.myMaximumDocumentsToScan = l;
            return this;
        }

        public Builder setMaximumRange(DocumentAssignable documentAssignable) {
            this.myMaximumRange = documentAssignable != null ? documentAssignable.asDocument() : null;
            return this;
        }

        public Builder setMinimumRange(DocumentAssignable documentAssignable) {
            this.myMinimumRange = documentAssignable != null ? documentAssignable.asDocument() : null;
            return this;
        }

        public Builder setNumberToSkip(int n) {
            this.myNumberToSkip = n;
            return this;
        }

        public Builder setPartialOk(boolean bl) {
            this.myPartialOk = bl;
            return this;
        }

        public Builder setQuery(DocumentAssignable documentAssignable) {
            this.myQuery = documentAssignable.asDocument();
            return this;
        }

        public Builder setReadPreference(ReadPreference readPreference) {
            this.myReadPreference = readPreference;
            return this;
        }

        public Builder setReturnFields(DocumentAssignable documentAssignable) {
            this.myReturnFields = documentAssignable.asDocument();
            return this;
        }

        public Builder setReturnIndexKeysOnly(boolean bl) {
            this.myReturnIndexKeysOnly = bl;
            return this;
        }

        public Builder setShowDiskLocation(boolean bl) {
            this.myShowDiskLocation = bl;
            return this;
        }

        public Builder setSnapshot(boolean bl) {
            this.mySnapshot = bl;
            return this;
        }

        public Builder setSort(DocumentAssignable documentAssignable) {
            this.mySort = documentAssignable.asDocument();
            return this;
        }

        public Builder setSort(IntegerElement ... integerElementArray) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            for (IntegerElement integerElement : integerElementArray) {
                documentBuilder.add(integerElement);
            }
            this.mySort = documentBuilder.build();
            return this;
        }

        public Builder setTailable(boolean bl) {
            this.myTailable = bl;
            return this;
        }

        public Builder showDiskLoc() {
            return this.setShowDiskLocation(true);
        }

        public Builder showDiskLoc(boolean bl) {
            return this.setShowDiskLocation(bl);
        }

        public Builder skip(int n) {
            return this.setNumberToSkip(n);
        }

        public Builder snapshot() {
            return this.setSnapshot(true);
        }

        public Builder snapshot(boolean bl) {
            return this.setSnapshot(bl);
        }

        public Builder sort(DocumentAssignable documentAssignable) {
            return this.setSort(documentAssignable);
        }

        public Builder sort(IntegerElement ... integerElementArray) {
            return this.setSort(integerElementArray);
        }

        public Builder tailable() {
            return this.setTailable(true).setAwaitData(true);
        }
    }
}

