/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;

public final class GeoJson {
    private static final Class<Point> POINT_CLASS = Point.class;

    public static Document lineString(List<? extends Point2D> list) throws IllegalArgumentException {
        if (list.size() < 2) {
            throw new IllegalArgumentException("A GeoJSON LineString must have at least 2 postions.");
        }
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "LineString");
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("coordinates");
        GeoJson.add(arrayBuilder, list);
        return documentBuilder.build();
    }

    public static Document lineString(Point2D point2D, Point2D point2D2, Point2D ... point2DArray) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "LineString");
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("coordinates");
        GeoJson.add(arrayBuilder, point2D);
        GeoJson.add(arrayBuilder, point2D2);
        for (Point2D point2D3 : point2DArray) {
            GeoJson.add(arrayBuilder, point2D3);
        }
        return documentBuilder.build();
    }

    public static Document multiLineString(List<? extends Point2D> list, List<? extends Point2D> ... listArray) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "MultiLineString");
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("coordinates");
        GeoJson.add(arrayBuilder.pushArray(), list);
        for (List<? extends Point2D> list2 : listArray) {
            GeoJson.add(arrayBuilder.pushArray(), list2);
        }
        return documentBuilder.build();
    }

    public static Document multiPoint(List<? extends Point2D> list) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "MultiPoint");
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("coordinates");
        for (Point2D point2D : list) {
            GeoJson.add(arrayBuilder, point2D);
        }
        return documentBuilder.build();
    }

    public static Document multiPoint(Point2D point2D, Point2D ... point2DArray) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "MultiPoint");
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("coordinates");
        GeoJson.add(arrayBuilder, point2D);
        for (Point2D point2D2 : point2DArray) {
            GeoJson.add(arrayBuilder, point2D2);
        }
        return documentBuilder.build();
    }

    public static Point2D p(double d, double d2) {
        return new Point2D.Double(d, d2);
    }

    public static Point p(int n, int n2) {
        return new Point(n, n2);
    }

    public static Document point(Point2D point2D) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "Point");
        GeoJson.addRaw(documentBuilder.pushArray("coordinates"), point2D);
        return documentBuilder.build();
    }

    public static Document polygon(List<? extends Point2D> list) throws IllegalArgumentException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "Polygon");
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("coordinates");
        GeoJson.lineRing(arrayBuilder.pushArray(), list);
        return documentBuilder.build();
    }

    public static Document polygon(List<? extends Point2D> list, List<? extends Point2D> ... listArray) throws IllegalArgumentException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add("type", "Polygon");
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("coordinates");
        GeoJson.lineRing(arrayBuilder.pushArray(), list);
        for (List<? extends Point2D> list2 : listArray) {
            GeoJson.lineRing(arrayBuilder.pushArray(), list2);
        }
        return documentBuilder.build();
    }

    protected static void add(ArrayBuilder arrayBuilder, List<? extends Point2D> list) {
        for (Point2D point2D : list) {
            GeoJson.add(arrayBuilder, point2D);
        }
    }

    protected static void add(ArrayBuilder arrayBuilder, Point2D point2D) {
        GeoJson.addRaw(arrayBuilder.pushArray(), point2D);
    }

    protected static void addRaw(ArrayBuilder arrayBuilder, Point2D point2D) {
        if (point2D.getClass() == POINT_CLASS) {
            Point point = (Point)point2D;
            arrayBuilder.add(point.x).add(point.y);
        } else {
            arrayBuilder.add(point2D.getX()).add(point2D.getY());
        }
    }

    protected static void lineRing(ArrayBuilder arrayBuilder, List<? extends Point2D> list) throws IllegalArgumentException {
        Point2D point2D;
        if (list.size() < 4) {
            throw new IllegalArgumentException("A GeoJSON LineRing must have at least 4 postions.");
        }
        Point2D point2D2 = point2D = list.get(0);
        for (Point2D point2D3 : list) {
            GeoJson.add(arrayBuilder, point2D3);
            point2D2 = point2D3;
        }
        if (!point2D2.equals(point2D)) {
            throw new IllegalArgumentException("A GeoJSON LineRing's first and last postion must be equal.");
        }
    }

    private GeoJson() {
    }
}

