/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.util.Assertions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class GroupBy {
    private final String myFinalizeFunction;
    private final Document myInitialValue;
    private final String myKeyFunction;
    private final Set<String> myKeys;
    private final Document myQuery;
    private final ReadPreference myReadPreference;
    private final String myReduceFunction;

    public static Builder builder() {
        return new Builder();
    }

    protected GroupBy(Builder builder) throws IllegalArgumentException {
        Assertions.assertThat(!builder.myKeys.isEmpty() || builder.myKeyFunction != null, "Must specify either a set of keys for the groupBy or a key function.");
        this.myKeys = Collections.unmodifiableSet(new HashSet<String>(builder.myKeys));
        this.myReduceFunction = builder.myReduceFunction;
        this.myInitialValue = builder.myInitialValue;
        this.myKeyFunction = builder.myKeyFunction;
        this.myQuery = builder.myQuery;
        this.myFinalizeFunction = builder.myFinalizeFunction;
        this.myReadPreference = builder.myReadPreference;
    }

    public String getFinalizeFunction() {
        return this.myFinalizeFunction;
    }

    public Document getInitialValue() {
        return this.myInitialValue;
    }

    public String getKeyFunction() {
        return this.myKeyFunction;
    }

    public Set<String> getKeys() {
        return this.myKeys;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public String getReduceFunction() {
        return this.myReduceFunction;
    }

    public static class Builder {
        protected String myFinalizeFunction;
        protected Document myInitialValue;
        protected String myKeyFunction;
        protected final Set<String> myKeys = new HashSet<String>();
        protected Document myQuery;
        protected ReadPreference myReadPreference;
        protected String myReduceFunction;

        public Builder() {
            this.reset();
        }

        public GroupBy build() throws IllegalArgumentException {
            return new GroupBy(this);
        }

        public Builder finalize(String string) {
            return this.setFinalizeFunction(string);
        }

        public Builder initialValue(DocumentAssignable documentAssignable) {
            return this.setInitialValue(documentAssignable);
        }

        public Builder key(String string) {
            return this.setKeyFunction(string);
        }

        public Builder keys(Set<String> set) {
            return this.setKeys(set);
        }

        public Builder query(DocumentAssignable documentAssignable) {
            return this.setQuery(documentAssignable);
        }

        public Builder readPreference(ReadPreference readPreference) {
            return this.setReadPreference(readPreference);
        }

        public Builder reduce(String string) {
            return this.setReduceFunction(string);
        }

        public Builder reset() {
            this.myFinalizeFunction = null;
            this.myInitialValue = null;
            this.myKeyFunction = null;
            this.myKeys.clear();
            this.myQuery = null;
            this.myReadPreference = null;
            this.myReduceFunction = null;
            return this;
        }

        public Builder setFinalizeFunction(String string) {
            this.myFinalizeFunction = string;
            return this;
        }

        public Builder setInitialValue(DocumentAssignable documentAssignable) {
            this.myInitialValue = documentAssignable.asDocument();
            return this;
        }

        public Builder setKeyFunction(String string) {
            this.myKeyFunction = string;
            return this;
        }

        public Builder setKeys(Set<String> set) {
            this.myKeys.clear();
            if (set != null) {
                this.myKeys.addAll(set);
            }
            return this;
        }

        public Builder setQuery(DocumentAssignable documentAssignable) {
            this.myQuery = documentAssignable.asDocument();
            return this;
        }

        public Builder setReadPreference(ReadPreference readPreference) {
            this.myReadPreference = readPreference;
            return this;
        }

        public Builder setReduceFunction(String string) {
            this.myReduceFunction = string;
            return this;
        }
    }
}

