/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.util.Assertions;

public class MapReduce {
    private final String myFinalizeFunction;
    private final boolean myJsMode;
    private final boolean myKeepTemp;
    private final int myLimit;
    private final String myMapFunction;
    private final String myOutputDatabase;
    private final String myOutputName;
    private final OutputType myOutputType;
    private final Document myQuery;
    private final ReadPreference myReadPreference;
    private final String myReduceFunction;
    private final Document myScope;
    private final Document mySort;
    private final boolean myVerbose;

    public static Builder builder() {
        return new Builder();
    }

    protected MapReduce(Builder builder) {
        Assertions.assertNotNull(builder.myMapFunction, "A mapReduce must have a map function.");
        Assertions.assertNotNull(builder.myReduceFunction, "A mapReduce must have a reduce function.");
        Assertions.assertThat(builder.myOutputType == OutputType.INLINE || builder.myOutputName != null && !builder.myOutputName.isEmpty(), "A mapReduce output type must be INLINE or an output collection must be specified.");
        this.myMapFunction = builder.myMapFunction;
        this.myReduceFunction = builder.myReduceFunction;
        this.myFinalizeFunction = builder.myFinalizeFunction;
        this.myQuery = builder.myQuery;
        this.mySort = builder.mySort;
        this.myScope = builder.myScope;
        this.myLimit = builder.myLimit;
        this.myOutputName = builder.myOutputName;
        this.myOutputDatabase = builder.myOutputDatabase;
        this.myOutputType = builder.myOutputType;
        this.myKeepTemp = builder.myKeepTemp;
        this.myJsMode = builder.myJsMode;
        this.myVerbose = builder.myVerbose;
        this.myReadPreference = builder.myReadPreference;
    }

    public String getFinalizeFunction() {
        return this.myFinalizeFunction;
    }

    public int getLimit() {
        return this.myLimit;
    }

    public String getMapFunction() {
        return this.myMapFunction;
    }

    public String getOutputDatabase() {
        return this.myOutputDatabase;
    }

    public String getOutputName() {
        return this.myOutputName;
    }

    public OutputType getOutputType() {
        return this.myOutputType;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public String getReduceFunction() {
        return this.myReduceFunction;
    }

    public Document getScope() {
        return this.myScope;
    }

    public Document getSort() {
        return this.mySort;
    }

    public boolean isJsMode() {
        return this.myJsMode;
    }

    public boolean isKeepTemp() {
        return this.myKeepTemp;
    }

    public boolean isVerbose() {
        return this.myVerbose;
    }

    public static enum OutputType {
        INLINE,
        MERGE,
        REDUCE,
        REPLACE;

    }

    public static class Builder {
        protected String myFinalizeFunction = null;
        protected boolean myJsMode = false;
        protected boolean myKeepTemp = false;
        protected int myLimit = 0;
        protected String myMapFunction = null;
        protected String myOutputDatabase = null;
        protected String myOutputName = null;
        protected OutputType myOutputType = OutputType.INLINE;
        protected Document myQuery = null;
        protected ReadPreference myReadPreference = null;
        protected String myReduceFunction = null;
        protected Document myScope = null;
        protected Document mySort = null;
        protected boolean myVerbose = false;

        public Builder() {
            this.reset();
        }

        public MapReduce build() {
            return new MapReduce(this);
        }

        public Builder finalize(String string) {
            return this.setFinalizeFunction(string);
        }

        public Builder jsMode() {
            return this.setJsMode(true);
        }

        public Builder jsMode(boolean bl) {
            return this.setJsMode(bl);
        }

        public Builder keepTemp() {
            return this.setKeepTemp(true);
        }

        public Builder keepTemp(boolean bl) {
            return this.setKeepTemp(bl);
        }

        public Builder limit(int n) {
            return this.setLimit(n);
        }

        public Builder map(String string) {
            return this.setMapFunction(string);
        }

        public Builder outputDatabase(String string) {
            return this.setOutputDatabase(string);
        }

        public Builder outputName(String string) {
            return this.setOutputName(string);
        }

        public Builder outputType(OutputType outputType) {
            return this.setOutputType(outputType);
        }

        public Builder query(DocumentAssignable documentAssignable) {
            return this.setQuery(documentAssignable);
        }

        public Builder readPreference(ReadPreference readPreference) {
            return this.setReadPreference(readPreference);
        }

        public Builder reduce(String string) {
            return this.setReduceFunction(string);
        }

        public Builder reset() {
            this.myFinalizeFunction = null;
            this.myJsMode = false;
            this.myKeepTemp = false;
            this.myLimit = 0;
            this.myMapFunction = null;
            this.myOutputDatabase = null;
            this.myOutputName = null;
            this.myOutputType = OutputType.INLINE;
            this.myQuery = null;
            this.myReadPreference = null;
            this.myReduceFunction = null;
            this.myScope = null;
            this.mySort = null;
            this.myVerbose = false;
            return this;
        }

        public Builder scope(DocumentAssignable documentAssignable) {
            return this.setScope(documentAssignable);
        }

        public Builder setFinalizeFunction(String string) {
            this.myFinalizeFunction = string;
            return this;
        }

        public Builder setJsMode(boolean bl) {
            this.myJsMode = bl;
            return this;
        }

        public Builder setKeepTemp(boolean bl) {
            this.myKeepTemp = bl;
            return this;
        }

        public Builder setLimit(int n) {
            this.myLimit = n;
            return this;
        }

        public Builder setMapFunction(String string) {
            this.myMapFunction = string;
            return this;
        }

        public Builder setOutputDatabase(String string) {
            this.myOutputDatabase = string;
            return this;
        }

        public Builder setOutputName(String string) {
            this.myOutputName = string;
            return this;
        }

        public Builder setOutputType(OutputType outputType) {
            this.myOutputType = outputType;
            return this;
        }

        public Builder setQuery(DocumentAssignable documentAssignable) {
            this.myQuery = documentAssignable.asDocument();
            return this;
        }

        public Builder setReadPreference(ReadPreference readPreference) {
            this.myReadPreference = readPreference;
            return this;
        }

        public Builder setReduceFunction(String string) {
            this.myReduceFunction = string;
            return this;
        }

        public Builder setScope(DocumentAssignable documentAssignable) {
            this.myScope = documentAssignable.asDocument();
            return this;
        }

        public Builder setSort(DocumentAssignable documentAssignable) {
            this.mySort = documentAssignable.asDocument();
            return this;
        }

        public Builder setSort(IntegerElement ... integerElementArray) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            for (IntegerElement integerElement : integerElementArray) {
                documentBuilder.add(integerElement);
            }
            this.mySort = documentBuilder.build();
            return this;
        }

        public Builder setVerbose(boolean bl) {
            this.myVerbose = bl;
            return this;
        }

        public Builder sort(DocumentAssignable documentAssignable) {
            return this.setSort(documentAssignable);
        }

        public Builder sort(IntegerElement ... integerElementArray) {
            return this.setSort(integerElementArray);
        }

        public Builder verbose() {
            return this.setVerbose(true);
        }

        public Builder verbose(boolean bl) {
            return this.setVerbose(bl);
        }
    }
}

