/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.builder;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.impl.EmptyDocument;
import com.allanbank.mongodb.builder.ConditionBuilder;
import com.allanbank.mongodb.builder.LogicalOperator;
import com.allanbank.mongodb.builder.MiscellaneousOperator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryBuilder
implements DocumentAssignable {
    private final Map<String, ConditionBuilder> myConditions = new LinkedHashMap<String, ConditionBuilder>();
    private String myWhere;

    public static Document and(DocumentAssignable ... documentAssignableArray) {
        if (documentAssignableArray.length <= 0) {
            return EmptyDocument.INSTANCE;
        }
        if (documentAssignableArray.length == 1) {
            return documentAssignableArray[0].asDocument();
        }
        HashSet<String> hashSet = new HashSet<String>();
        DocumentBuilder documentBuilder = BuilderFactory.start();
        DocumentBuilder documentBuilder2 = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder2.pushArray(LogicalOperator.AND.getToken());
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            Document document = documentAssignable.asDocument();
            Iterator iterator = document.iterator();
            if (!iterator.hasNext()) continue;
            arrayBuilder.addDocument(document);
            while (documentBuilder != null && iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (hashSet.add(element.getName())) {
                    documentBuilder.add(element);
                    continue;
                }
                documentBuilder = null;
            }
        }
        if (documentBuilder != null) {
            return documentBuilder.build();
        }
        return documentBuilder2.build();
    }

    public static Document nor(DocumentAssignable ... documentAssignableArray) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray(LogicalOperator.NOR.getToken());
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            Document document = documentAssignable.asDocument();
            if (!document.iterator().hasNext()) continue;
            arrayBuilder.addDocument(document);
        }
        return documentBuilder.build();
    }

    public static Document not(DocumentAssignable ... documentAssignableArray) {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray(LogicalOperator.NOT.getToken());
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            Document document = documentAssignable.asDocument();
            if (!document.iterator().hasNext()) continue;
            arrayBuilder.addDocument(document);
        }
        return documentBuilder.build();
    }

    public static Document or(DocumentAssignable ... documentAssignableArray) {
        if (documentAssignableArray.length <= 0) {
            return EmptyDocument.INSTANCE;
        }
        if (documentAssignableArray.length == 1) {
            return documentAssignableArray[0].asDocument();
        }
        DocumentBuilder documentBuilder = BuilderFactory.start();
        ArrayBuilder arrayBuilder = documentBuilder.pushArray(LogicalOperator.OR.getToken());
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            Document document = documentAssignable.asDocument();
            if (!document.iterator().hasNext()) continue;
            arrayBuilder.addDocument(document);
        }
        return documentBuilder.build();
    }

    public static ConditionBuilder where(String string) {
        return new QueryBuilder().whereField(string);
    }

    @Override
    public Document asDocument() {
        return this.build();
    }

    public Document build() {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        for (ConditionBuilder conditionBuilder : this.myConditions.values()) {
            Element element = conditionBuilder.buildFieldCondition();
            if (element == null) continue;
            documentBuilder.add(element);
        }
        if (this.myWhere != null) {
            documentBuilder.addJavaScript(MiscellaneousOperator.WHERE.getToken(), this.myWhere);
        }
        return documentBuilder.build();
    }

    public void reset() {
        this.myConditions.clear();
    }

    public ConditionBuilder whereField(String string) {
        ConditionBuilder conditionBuilder = this.myConditions.get(string);
        if (conditionBuilder == null) {
            conditionBuilder = new ConditionBuilder(string, this);
            this.myConditions.put(string, conditionBuilder);
        }
        return conditionBuilder;
    }

    public QueryBuilder whereJavaScript(String string) {
        this.myWhere = string;
        return this;
    }
}

