/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.io.SizeOfVisitor;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.Message;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.DocumentToLargeException;
import com.allanbank.mongodb.error.MongoClientClosedException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractClient
implements Client {
    private final AtomicBoolean myClosed = new AtomicBoolean(false);

    @Override
    public void close() {
        this.myClosed.set(true);
    }

    @Override
    public String send(Message message, Callback<Reply> callback) throws MongoDbException {
        this.validate(message, null);
        return this.findConnection(message, null).send(message, callback);
    }

    @Override
    public String send(Message message, Message message2, Callback<Reply> callback) throws MongoDbException {
        this.validate(message, message2);
        return this.findConnection(message, message2).send(message, message2, callback);
    }

    protected abstract Connection findConnection(Message var1, Message var2) throws MongoDbException;

    private void validate(Message message, Message message2) throws DocumentToLargeException, MongoClientClosedException {
        if (this.myClosed.get()) {
            throw new MongoClientClosedException(message);
        }
        SizeOfVisitor sizeOfVisitor = new SizeOfVisitor();
        message.validateSize(sizeOfVisitor, 0x1000000);
        if (message2 != null) {
            sizeOfVisitor.reset();
            message2.validateSize(sizeOfVisitor, 0x1000000);
        }
    }
}

