/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.builder.Aggregate;
import com.allanbank.mongodb.builder.Distinct;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.FindAndModify;
import com.allanbank.mongodb.builder.GroupBy;
import com.allanbank.mongodb.builder.MapReduce;
import com.allanbank.mongodb.builder.Text;
import com.allanbank.mongodb.builder.TextResult;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.LegacyStreamCallbackAdapter;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.message.GetLastError;
import com.allanbank.mongodb.util.FutureUtils;
import java.util.List;
import java.util.concurrent.Future;

public abstract class AbstractMongoCollection
implements MongoCollection {
    public static final boolean DELETE_SINGLE_DELETE_DEFAULT = false;
    public static final Document EMPTY_INDEX_OPTIONS = BuilderFactory.start().build();
    public static final boolean INSERT_CONTINUE_ON_ERROR_DEFAULT = false;
    public static final Document UNIQUE_INDEX_OPTIONS = BuilderFactory.start().add("unique", true).build();
    public static final boolean UPDATE_MULTIUPDATE_DEFAULT = false;
    public static final boolean UPDATE_UPSERT_DEFAULT = false;
    protected final Client myClient;
    protected final MongoDatabase myDatabase;
    protected final String myName;
    private Durability myDurability;
    private ReadPreference myReadPreference;

    public AbstractMongoCollection(Client client, MongoDatabase mongoDatabase, String string) {
        this.myClient = client;
        this.myDatabase = mongoDatabase;
        this.myName = string;
        this.myDurability = null;
        this.myReadPreference = null;
    }

    @Override
    public List<Document> aggregate(Aggregate aggregate) throws MongoDbException {
        return FutureUtils.unwrap(this.aggregateAsync(aggregate));
    }

    @Override
    public List<Document> aggregate(Aggregate.Builder builder) throws MongoDbException {
        return this.aggregate(builder.build());
    }

    @Override
    public Future<List<Document>> aggregateAsync(Aggregate aggregate) throws MongoDbException {
        FutureCallback<List<Document>> futureCallback = new FutureCallback<List<Document>>();
        this.aggregateAsync(futureCallback, aggregate);
        return futureCallback;
    }

    @Override
    public Future<List<Document>> aggregateAsync(Aggregate.Builder builder) throws MongoDbException {
        return this.aggregateAsync(builder.build());
    }

    @Override
    public abstract void aggregateAsync(Callback<List<Document>> var1, Aggregate var2) throws MongoDbException;

    @Override
    public void aggregateAsync(Callback<List<Document>> callback, Aggregate.Builder builder) throws MongoDbException {
        this.aggregateAsync(callback, builder.build());
    }

    @Override
    public long count() throws MongoDbException {
        return this.count(BuilderFactory.start(), this.getReadPreference());
    }

    @Override
    public long count(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.count(documentAssignable, this.getReadPreference());
    }

    @Override
    public long count(DocumentAssignable documentAssignable, ReadPreference readPreference) throws MongoDbException {
        Future<Long> future = this.countAsync(documentAssignable, readPreference);
        return FutureUtils.unwrap(future);
    }

    @Override
    public long count(ReadPreference readPreference) throws MongoDbException {
        return this.count(BuilderFactory.start(), readPreference);
    }

    @Override
    public Future<Long> countAsync() throws MongoDbException {
        return this.countAsync(BuilderFactory.start(), this.getReadPreference());
    }

    @Override
    public void countAsync(Callback<Long> callback) throws MongoDbException {
        this.countAsync(callback, BuilderFactory.start(), this.getReadPreference());
    }

    @Override
    public void countAsync(Callback<Long> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.countAsync(callback, documentAssignable, this.getReadPreference());
    }

    @Override
    public abstract void countAsync(Callback<Long> var1, DocumentAssignable var2, ReadPreference var3) throws MongoDbException;

    @Override
    public void countAsync(Callback<Long> callback, ReadPreference readPreference) throws MongoDbException {
        this.countAsync(callback, BuilderFactory.start(), readPreference);
    }

    @Override
    public Future<Long> countAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.countAsync(futureCallback, documentAssignable, this.getReadPreference());
        return futureCallback;
    }

    @Override
    public Future<Long> countAsync(DocumentAssignable documentAssignable, ReadPreference readPreference) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.countAsync(futureCallback, documentAssignable, readPreference);
        return futureCallback;
    }

    @Override
    public Future<Long> countAsync(ReadPreference readPreference) throws MongoDbException {
        return this.countAsync(BuilderFactory.start(), readPreference);
    }

    @Override
    public void createIndex(boolean bl, Element ... elementArray) throws MongoDbException {
        this.createIndex(null, bl, elementArray);
    }

    @Override
    public void createIndex(DocumentAssignable documentAssignable, Element ... elementArray) throws MongoDbException {
        this.createIndex(null, documentAssignable, elementArray);
    }

    @Override
    public void createIndex(Element ... elementArray) throws MongoDbException {
        this.createIndex(EMPTY_INDEX_OPTIONS, elementArray);
    }

    @Override
    public void createIndex(String string, boolean bl, Element ... elementArray) throws MongoDbException {
        this.createIndex(string, bl ? UNIQUE_INDEX_OPTIONS : EMPTY_INDEX_OPTIONS, elementArray);
    }

    @Override
    public abstract void createIndex(String var1, DocumentAssignable var2, Element ... var3) throws MongoDbException;

    @Override
    public long delete(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.delete(documentAssignable, false, this.getDurability());
    }

    @Override
    public long delete(DocumentAssignable documentAssignable, boolean bl) throws MongoDbException {
        return this.delete(documentAssignable, bl, this.getDurability());
    }

    @Override
    public long delete(DocumentAssignable documentAssignable, boolean bl, Durability durability) throws MongoDbException {
        Future<Long> future = this.deleteAsync(documentAssignable, bl, durability);
        return FutureUtils.unwrap(future);
    }

    @Override
    public long delete(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        return this.delete(documentAssignable, false, durability);
    }

    @Override
    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.deleteAsync(callback, documentAssignable, false, this.getDurability());
    }

    @Override
    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable, boolean bl) throws MongoDbException {
        this.deleteAsync(callback, documentAssignable, bl, this.getDurability());
    }

    @Override
    public abstract void deleteAsync(Callback<Long> var1, DocumentAssignable var2, boolean var3, Durability var4) throws MongoDbException;

    @Override
    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        this.deleteAsync(callback, documentAssignable, false, durability);
    }

    @Override
    public Future<Long> deleteAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.deleteAsync(futureCallback, documentAssignable, false, this.getDurability());
        return futureCallback;
    }

    @Override
    public Future<Long> deleteAsync(DocumentAssignable documentAssignable, boolean bl) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.deleteAsync(futureCallback, documentAssignable, bl, this.getDurability());
        return futureCallback;
    }

    @Override
    public Future<Long> deleteAsync(DocumentAssignable documentAssignable, boolean bl, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.deleteAsync(futureCallback, documentAssignable, bl, durability);
        return futureCallback;
    }

    @Override
    public Future<Long> deleteAsync(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.deleteAsync(futureCallback, documentAssignable, false, durability);
        return futureCallback;
    }

    @Override
    public ArrayElement distinct(Distinct distinct) throws MongoDbException {
        return FutureUtils.unwrap(this.distinctAsync(distinct));
    }

    @Override
    public ArrayElement distinct(Distinct.Builder builder) throws MongoDbException {
        return this.distinct(builder.build());
    }

    @Override
    public abstract void distinctAsync(Callback<ArrayElement> var1, Distinct var2) throws MongoDbException;

    @Override
    public void distinctAsync(Callback<ArrayElement> callback, Distinct.Builder builder) throws MongoDbException {
        this.distinctAsync(callback, builder.build());
    }

    @Override
    public Future<ArrayElement> distinctAsync(Distinct distinct) throws MongoDbException {
        FutureCallback<ArrayElement> futureCallback = new FutureCallback<ArrayElement>();
        this.distinctAsync(futureCallback, distinct);
        return futureCallback;
    }

    @Override
    public Future<ArrayElement> distinctAsync(Distinct.Builder builder) throws MongoDbException {
        return this.distinctAsync(builder.build());
    }

    @Override
    public boolean dropIndex(IntegerElement ... integerElementArray) throws MongoDbException {
        return this.dropIndex(this.buildIndexName(integerElementArray));
    }

    @Override
    public abstract boolean dropIndex(String var1) throws MongoDbException;

    @Override
    public Document explain(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.explain(new Find.Builder(documentAssignable).build());
    }

    @Override
    public Document explain(Find find) throws MongoDbException {
        return FutureUtils.unwrap(this.explainAsync(find));
    }

    @Override
    public Document explain(Find.Builder builder) throws MongoDbException {
        return this.explain(builder.build());
    }

    @Override
    public abstract void explainAsync(Callback<Document> var1, Find var2) throws MongoDbException;

    @Override
    public void explainAsync(Callback<Document> callback, Find.Builder builder) throws MongoDbException {
        this.explainAsync(callback, builder.build());
    }

    @Override
    public Future<Document> explainAsync(Find find) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>();
        this.explainAsync(futureCallback, find);
        return futureCallback;
    }

    @Override
    public Future<Document> explainAsync(Find.Builder builder) throws MongoDbException {
        return this.explainAsync(builder.build());
    }

    @Override
    public MongoIterator<Document> find(DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.findAsync(documentAssignable));
    }

    @Override
    public MongoIterator<Document> find(Find find) throws MongoDbException {
        return FutureUtils.unwrap(this.findAsync(find));
    }

    @Override
    public MongoIterator<Document> find(Find.Builder builder) throws MongoDbException {
        return this.find(builder.build());
    }

    @Override
    public Document findAndModify(FindAndModify findAndModify) throws MongoDbException {
        return FutureUtils.unwrap(this.findAndModifyAsync(findAndModify));
    }

    @Override
    public Document findAndModify(FindAndModify.Builder builder) throws MongoDbException {
        return this.findAndModify(builder.build());
    }

    @Override
    public abstract void findAndModifyAsync(Callback<Document> var1, FindAndModify var2) throws MongoDbException;

    @Override
    public void findAndModifyAsync(Callback<Document> callback, FindAndModify.Builder builder) throws MongoDbException {
        this.findAndModifyAsync(callback, builder.build());
    }

    @Override
    public Future<Document> findAndModifyAsync(FindAndModify findAndModify) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>();
        this.findAndModifyAsync(futureCallback, findAndModify);
        return futureCallback;
    }

    @Override
    public Future<Document> findAndModifyAsync(FindAndModify.Builder builder) throws MongoDbException {
        return this.findAndModifyAsync(builder.build());
    }

    @Override
    public void findAsync(Callback<MongoIterator<Document>> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.findAsync(callback, new Find.Builder(documentAssignable).build());
    }

    @Override
    public abstract void findAsync(Callback<MongoIterator<Document>> var1, Find var2) throws MongoDbException;

    @Override
    public void findAsync(Callback<MongoIterator<Document>> callback, Find.Builder builder) throws MongoDbException {
        this.findAsync(callback, builder.build());
    }

    @Override
    public Future<MongoIterator<Document>> findAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<MongoIterator<Document>> futureCallback = new FutureCallback<MongoIterator<Document>>();
        this.findAsync(futureCallback, documentAssignable);
        return futureCallback;
    }

    @Override
    public Future<MongoIterator<Document>> findAsync(Find find) throws MongoDbException {
        FutureCallback<MongoIterator<Document>> futureCallback = new FutureCallback<MongoIterator<Document>>();
        this.findAsync(futureCallback, find);
        return futureCallback;
    }

    @Override
    public Future<MongoIterator<Document>> findAsync(Find.Builder builder) throws MongoDbException {
        return this.findAsync(builder.build());
    }

    @Override
    public Document findOne(DocumentAssignable documentAssignable) throws MongoDbException {
        return FutureUtils.unwrap(this.findOneAsync(documentAssignable));
    }

    @Override
    public Document findOne(Find find) throws MongoDbException {
        return FutureUtils.unwrap(this.findOneAsync(find));
    }

    @Override
    public Document findOne(Find.Builder builder) throws MongoDbException {
        return this.findOne(builder.build());
    }

    @Override
    public void findOneAsync(Callback<Document> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.findOneAsync(callback, new Find.Builder(documentAssignable).build());
    }

    @Override
    public abstract void findOneAsync(Callback<Document> var1, Find var2) throws MongoDbException;

    @Override
    public void findOneAsync(Callback<Document> callback, Find.Builder builder) throws MongoDbException {
        this.findOneAsync(callback, builder.build());
    }

    @Override
    public Future<Document> findOneAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>();
        this.findOneAsync(futureCallback, documentAssignable);
        return futureCallback;
    }

    @Override
    public Future<Document> findOneAsync(Find find) throws MongoDbException {
        FutureCallback<Document> futureCallback = new FutureCallback<Document>();
        this.findOneAsync(futureCallback, find);
        return futureCallback;
    }

    @Override
    public Future<Document> findOneAsync(Find.Builder builder) throws MongoDbException {
        return this.findOneAsync(builder.build());
    }

    @Override
    public String getDatabaseName() {
        return this.myDatabase.getName();
    }

    @Override
    public Durability getDurability() {
        Durability durability = this.myDurability;
        if (durability == null) {
            durability = this.myDatabase.getDurability();
        }
        return durability;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public ReadPreference getReadPreference() {
        ReadPreference readPreference = this.myReadPreference;
        if (readPreference == null) {
            readPreference = this.myDatabase.getReadPreference();
        }
        return readPreference;
    }

    @Override
    public ArrayElement groupBy(GroupBy groupBy) throws MongoDbException {
        return FutureUtils.unwrap(this.groupByAsync(groupBy));
    }

    @Override
    public ArrayElement groupBy(GroupBy.Builder builder) throws MongoDbException {
        return this.groupBy(builder.build());
    }

    @Override
    public abstract void groupByAsync(Callback<ArrayElement> var1, GroupBy var2) throws MongoDbException;

    @Override
    public void groupByAsync(Callback<ArrayElement> callback, GroupBy.Builder builder) throws MongoDbException {
        this.groupByAsync(callback, builder.build());
    }

    @Override
    public Future<ArrayElement> groupByAsync(GroupBy groupBy) throws MongoDbException {
        FutureCallback<ArrayElement> futureCallback = new FutureCallback<ArrayElement>();
        this.groupByAsync(futureCallback, groupBy);
        return futureCallback;
    }

    @Override
    public Future<ArrayElement> groupByAsync(GroupBy.Builder builder) throws MongoDbException {
        return this.groupByAsync(builder.build());
    }

    @Override
    public int insert(boolean bl, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        return this.insert(bl, this.getDurability(), documentAssignableArray);
    }

    @Override
    public int insert(boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        Future<Integer> future = this.insertAsync(bl, durability, documentAssignableArray);
        return FutureUtils.unwrap(future);
    }

    @Override
    public int insert(DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        return this.insert(false, this.getDurability(), documentAssignableArray);
    }

    @Override
    public int insert(Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        return this.insert(false, durability, documentAssignableArray);
    }

    @Override
    public Future<Integer> insertAsync(boolean bl, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>();
        this.insertAsync(futureCallback, bl, this.getDurability(), documentAssignableArray);
        return futureCallback;
    }

    @Override
    public Future<Integer> insertAsync(boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>();
        this.insertAsync(futureCallback, bl, durability, documentAssignableArray);
        return futureCallback;
    }

    @Override
    public void insertAsync(Callback<Integer> callback, boolean bl, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(callback, bl, this.getDurability(), documentAssignableArray);
    }

    @Override
    public abstract void insertAsync(Callback<Integer> var1, boolean var2, Durability var3, DocumentAssignable ... var4) throws MongoDbException;

    @Override
    public void insertAsync(Callback<Integer> callback, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(callback, false, this.getDurability(), documentAssignableArray);
    }

    @Override
    public void insertAsync(Callback<Integer> callback, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        this.insertAsync(callback, false, durability, documentAssignableArray);
    }

    @Override
    public Future<Integer> insertAsync(DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>();
        this.insertAsync(futureCallback, false, this.getDurability(), documentAssignableArray);
        return futureCallback;
    }

    @Override
    public Future<Integer> insertAsync(Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>();
        this.insertAsync(futureCallback, false, durability, documentAssignableArray);
        return futureCallback;
    }

    @Override
    public List<Document> mapReduce(MapReduce mapReduce) throws MongoDbException {
        return FutureUtils.unwrap(this.mapReduceAsync(mapReduce));
    }

    @Override
    public List<Document> mapReduce(MapReduce.Builder builder) throws MongoDbException {
        return this.mapReduce(builder.build());
    }

    @Override
    public abstract void mapReduceAsync(Callback<List<Document>> var1, MapReduce var2) throws MongoDbException;

    @Override
    public void mapReduceAsync(Callback<List<Document>> callback, MapReduce.Builder builder) throws MongoDbException {
        this.mapReduceAsync(callback, builder.build());
    }

    @Override
    public Future<List<Document>> mapReduceAsync(MapReduce mapReduce) throws MongoDbException {
        FutureCallback<List<Document>> futureCallback = new FutureCallback<List<Document>>();
        this.mapReduceAsync(futureCallback, mapReduce);
        return futureCallback;
    }

    @Override
    public Future<List<Document>> mapReduceAsync(MapReduce.Builder builder) throws MongoDbException {
        return this.mapReduceAsync(builder.build());
    }

    @Override
    public int save(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.save(documentAssignable, this.getDurability());
    }

    @Override
    public int save(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        return FutureUtils.unwrap(this.saveAsync(documentAssignable, durability));
    }

    @Override
    public void saveAsync(Callback<Integer> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        this.saveAsync(callback, documentAssignable, this.getDurability());
    }

    @Override
    public abstract void saveAsync(Callback<Integer> var1, DocumentAssignable var2, Durability var3) throws MongoDbException;

    @Override
    public Future<Integer> saveAsync(DocumentAssignable documentAssignable) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>();
        this.saveAsync(futureCallback, documentAssignable, this.getDurability());
        return futureCallback;
    }

    @Override
    public Future<Integer> saveAsync(DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        FutureCallback<Integer> futureCallback = new FutureCallback<Integer>();
        this.saveAsync(futureCallback, documentAssignable, durability);
        return futureCallback;
    }

    @Override
    public void setDurability(Durability durability) {
        this.myDurability = durability;
    }

    @Override
    public void setReadPreference(ReadPreference readPreference) {
        this.myReadPreference = readPreference;
    }

    @Override
    @Deprecated
    public MongoCursorControl streamingFind(Callback<Document> callback, DocumentAssignable documentAssignable) throws MongoDbException {
        return this.streamingFind(callback, new Find.Builder(documentAssignable).build());
    }

    @Override
    @Deprecated
    public MongoCursorControl streamingFind(Callback<Document> callback, Find find) throws MongoDbException {
        return this.streamingFind((StreamCallback<Document>)new LegacyStreamCallbackAdapter(callback), find);
    }

    @Override
    public MongoCursorControl streamingFind(StreamCallback<Document> streamCallback, DocumentAssignable documentAssignable) throws MongoDbException {
        return this.streamingFind(streamCallback, new Find.Builder(documentAssignable).build());
    }

    @Override
    public abstract MongoCursorControl streamingFind(StreamCallback<Document> var1, Find var2) throws MongoDbException;

    @Override
    public MongoCursorControl streamingFind(StreamCallback<Document> streamCallback, Find.Builder builder) throws MongoDbException {
        return this.streamingFind(streamCallback, builder.build());
    }

    @Override
    public List<TextResult> textSearch(Text text) throws MongoDbException {
        return FutureUtils.unwrap(this.textSearchAsync(text));
    }

    @Override
    public List<TextResult> textSearch(Text.Builder builder) throws MongoDbException {
        return this.textSearch(builder.build());
    }

    @Override
    public abstract void textSearchAsync(Callback<List<TextResult>> var1, Text var2) throws MongoDbException;

    @Override
    public void textSearchAsync(Callback<List<TextResult>> callback, Text.Builder builder) throws MongoDbException {
        this.textSearchAsync(callback, builder.build());
    }

    @Override
    public Future<List<TextResult>> textSearchAsync(Text text) throws MongoDbException {
        FutureCallback<List<TextResult>> futureCallback = new FutureCallback<List<TextResult>>();
        this.textSearchAsync(futureCallback, text);
        return futureCallback;
    }

    @Override
    public Future<List<TextResult>> textSearchAsync(Text.Builder builder) throws MongoDbException {
        return this.textSearchAsync(builder.build());
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) throws MongoDbException {
        return this.update(documentAssignable, documentAssignable2, false, false, this.getDurability());
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) throws MongoDbException {
        return this.update(documentAssignable, documentAssignable2, bl, bl2, this.getDurability());
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) throws MongoDbException {
        Future<Long> future = this.updateAsync(documentAssignable, documentAssignable2, bl, bl2, durability);
        return FutureUtils.unwrap(future);
    }

    @Override
    public long update(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, Durability durability) throws MongoDbException {
        return this.update(documentAssignable, documentAssignable2, false, false, durability);
    }

    @Override
    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) throws MongoDbException {
        this.updateAsync(callback, documentAssignable, documentAssignable2, false, false, this.getDurability());
    }

    @Override
    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) throws MongoDbException {
        this.updateAsync(callback, documentAssignable, documentAssignable2, bl, bl2, this.getDurability());
    }

    @Override
    public abstract void updateAsync(Callback<Long> var1, DocumentAssignable var2, DocumentAssignable var3, boolean var4, boolean var5, Durability var6) throws MongoDbException;

    @Override
    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, Durability durability) throws MongoDbException {
        this.updateAsync(callback, documentAssignable, documentAssignable2, false, false, durability);
    }

    @Override
    public Future<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, false, false, this.getDurability());
        return futureCallback;
    }

    @Override
    public Future<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, bl, bl2, this.getDurability());
        return futureCallback;
    }

    @Override
    public Future<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, bl, bl2, durability);
        return futureCallback;
    }

    @Override
    public Future<Long> updateAsync(DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, Durability durability) throws MongoDbException {
        FutureCallback<Long> futureCallback = new FutureCallback<Long>();
        this.updateAsync(futureCallback, documentAssignable, documentAssignable2, false, false, durability);
        return futureCallback;
    }

    protected GetLastError asGetLastError(Durability durability) {
        return new GetLastError(this.getDatabaseName(), durability);
    }

    protected String buildIndexName(Element ... elementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : elementArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('_');
            }
            stringBuilder.append(element.getName().replace(' ', '_'));
            stringBuilder.append("_");
            if (element instanceof NumericElement) {
                stringBuilder.append(((NumericElement)element).getIntValue());
                continue;
            }
            stringBuilder.append(element.getValueAsString());
        }
        return stringBuilder.toString();
    }
}

