/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.element.NullElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.CursorNotFoundException;
import com.allanbank.mongodb.error.DuplicateKeyException;
import com.allanbank.mongodb.error.QueryFailedException;
import com.allanbank.mongodb.error.ReplyException;
import com.allanbank.mongodb.error.ShardConfigStaleException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractValidatingReplyCallback
implements Callback<Reply> {
    public static final String ERROR_CODE_FIELD = "code";
    public static final List<String> ERROR_MESSAGE_FIELDS;

    @Override
    public void callback(Reply reply) {
        try {
            this.verify(reply);
            this.handle(reply);
        }
        catch (MongoDbException mongoDbException) {
            this.exception(mongoDbException);
        }
    }

    @Override
    public abstract void exception(Throwable var1);

    protected MongoDbException asError(Reply reply) {
        return this.asError(reply, false);
    }

    protected MongoDbException asError(Reply reply, boolean bl) {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            int n;
            Document document = list.get(0);
            Element element = document.get("ok");
            Element element2 = document.get(ERROR_CODE_FIELD);
            Element element3 = null;
            for (n = 0; element3 == null && n < ERROR_MESSAGE_FIELDS.size(); ++n) {
                element3 = document.get(ERROR_MESSAGE_FIELDS.get(n));
            }
            if (element != null) {
                n = this.toInt(element);
                if (n != 1) {
                    return this.asError(reply, n, this.toInt(element2), this.asString(element3));
                }
                if (element3 != null && !(element3 instanceof NullElement)) {
                    return this.asError(reply, n, this.toInt(element2), this.asString(element3));
                }
            } else if (bl) {
                return this.asError(reply, -1, this.toInt(element2), this.asString(element3));
            }
        }
        return null;
    }

    protected MongoDbException asError(Reply reply, int n, int n2, String string) {
        if (n2 == 11000 || n2 == 11001 || string.startsWith("E11000") || string.startsWith("E11001")) {
            return new DuplicateKeyException(n, n2, string, reply);
        }
        return new ReplyException(n, n2, string, reply);
    }

    protected String asString(Element element) {
        if (element instanceof StringElement) {
            return ((StringElement)element).getValue();
        }
        return String.valueOf(element);
    }

    protected void checkForError(Reply reply) throws MongoDbException {
        MongoDbException mongoDbException = this.asError(reply);
        if (mongoDbException != null) {
            throw mongoDbException;
        }
    }

    protected abstract void handle(Reply var1);

    protected int toInt(Element element) {
        if (element instanceof NumericElement) {
            return ((NumericElement)element).getIntValue();
        }
        return -1;
    }

    protected void verify(Reply reply) throws MongoDbException {
        if (reply.isCursorNotFound()) {
            throw new CursorNotFoundException(reply, (Throwable)this.asError(reply, true));
        }
        if (reply.isQueryFailed()) {
            throw new QueryFailedException(reply, (Throwable)this.asError(reply, true));
        }
        if (reply.isShardConfigStale()) {
            throw new ShardConfigStaleException(reply, (Throwable)this.asError(reply, true));
        }
        this.checkForError(reply);
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add("$err");
        arrayList.add("errmsg");
        arrayList.add("err");
        ERROR_MESSAGE_FIELDS = Collections.unmodifiableList(arrayList);
    }
}

