/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.MongoClient;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.ClientImpl;
import com.allanbank.mongodb.client.MongoDatabaseImpl;
import com.allanbank.mongodb.client.SerialClientImpl;
import java.util.ArrayList;
import java.util.List;

public class MongoClientImpl
implements MongoClient {
    private final Client myClient;

    public MongoClientImpl(Client client) {
        this.myClient = client;
    }

    public MongoClientImpl(MongoClientConfiguration mongoClientConfiguration) {
        this(new ClientImpl(mongoClientConfiguration));
    }

    @Override
    public MongoClient asSerializedClient() {
        if (this.myClient instanceof SerialClientImpl) {
            return this;
        }
        return new MongoClientImpl(new SerialClientImpl((ClientImpl)this.myClient));
    }

    @Override
    public void close() {
        this.myClient.close();
    }

    public Client getClient() {
        return this.myClient;
    }

    @Override
    public MongoClientConfiguration getConfig() {
        return this.myClient.getConfig();
    }

    @Override
    public MongoDatabase getDatabase(String string) {
        return new MongoDatabaseImpl(this.myClient, string);
    }

    @Override
    public List<String> listDatabaseNames() {
        MongoDatabase mongoDatabase = this.getDatabase("admin");
        Document document = mongoDatabase.runAdminCommand("listDatabases");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StringElement stringElement : document.find(StringElement.class, "databases", ".*", "name")) {
            arrayList.add(stringElement.getValue());
        }
        return arrayList;
    }

    @Override
    public List<String> listDatabases() {
        return this.listDatabaseNames();
    }

    @Override
    public MongoIterator<Document> restart(DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.myClient.restart(documentAssignable);
    }

    @Override
    public MongoCursorControl restart(StreamCallback<Document> streamCallback, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.myClient.restart(streamCallback, documentAssignable);
    }
}

