/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.ArrayBuilder;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.impl.RootDocument;
import com.allanbank.mongodb.builder.Aggregate;
import com.allanbank.mongodb.builder.Distinct;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.FindAndModify;
import com.allanbank.mongodb.builder.GroupBy;
import com.allanbank.mongodb.builder.MapReduce;
import com.allanbank.mongodb.builder.Text;
import com.allanbank.mongodb.builder.TextResult;
import com.allanbank.mongodb.client.AbstractMongoCollection;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.LongToIntCallback;
import com.allanbank.mongodb.client.QueryCallback;
import com.allanbank.mongodb.client.QueryOneCallback;
import com.allanbank.mongodb.client.QueryStreamingCallback;
import com.allanbank.mongodb.client.ReplyArrayCallback;
import com.allanbank.mongodb.client.ReplyDocumentCallback;
import com.allanbank.mongodb.client.ReplyIntegerCallback;
import com.allanbank.mongodb.client.ReplyLongCallback;
import com.allanbank.mongodb.client.ReplyResultCallback;
import com.allanbank.mongodb.client.TextCallback;
import com.allanbank.mongodb.connection.ClusterType;
import com.allanbank.mongodb.connection.message.Command;
import com.allanbank.mongodb.connection.message.Delete;
import com.allanbank.mongodb.connection.message.Insert;
import com.allanbank.mongodb.connection.message.Query;
import com.allanbank.mongodb.connection.message.Update;
import java.util.ArrayList;
import java.util.List;

public class MongoCollectionImpl
extends AbstractMongoCollection {
    public static final String ID_FIELD_NAME = "_id";

    public MongoCollectionImpl(Client client, MongoDatabase mongoDatabase, String string) {
        super(client, mongoDatabase, string);
    }

    @Override
    public void aggregateAsync(Callback<List<Document>> callback, Aggregate aggregate) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("aggregate", this.getName());
        ArrayBuilder arrayBuilder = documentBuilder.pushArray("pipeline");
        for (Element object2 : aggregate.getPipeline()) {
            arrayBuilder.add(object2);
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, aggregate.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), documentBuilder.build(), readPreference);
        this.myClient.send(command, new ReplyResultCallback("result", callback));
    }

    @Override
    public void countAsync(Callback<Long> callback, DocumentAssignable documentAssignable, ReadPreference readPreference) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("count", this.getName());
        documentBuilder.addDocument("query", documentAssignable.asDocument());
        ReadPreference readPreference2 = this.updateReadPreference(documentBuilder, readPreference, true);
        Command command = new Command(this.getDatabaseName(), documentBuilder.build(), readPreference2);
        this.myClient.send(command, new ReplyLongCallback(callback));
    }

    @Override
    public void createIndex(String string, DocumentAssignable documentAssignable, Element ... elementArray) throws MongoDbException {
        String string2 = string;
        if (string == null || string.isEmpty()) {
            string2 = this.buildIndexName(elementArray);
        }
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("name", string2);
        documentBuilder.addString("ns", this.getDatabaseName() + "." + this.getName());
        DocumentBuilder documentBuilder2 = documentBuilder.push("key");
        for (Element element : elementArray) {
            documentBuilder2.add(element);
        }
        for (Element element : documentAssignable.asDocument()) {
            documentBuilder.add(element);
        }
        MongoCollectionImpl mongoCollectionImpl = new MongoCollectionImpl(this.myClient, this.myDatabase, "system.indexes");
        Document document = documentBuilder.build();
        if (mongoCollectionImpl.findOne(document) == null) {
            mongoCollectionImpl.insert(Durability.ACK, document);
        }
    }

    @Override
    public void deleteAsync(Callback<Long> callback, DocumentAssignable documentAssignable, boolean bl, Durability durability) throws MongoDbException {
        Delete delete = new Delete(this.getDatabaseName(), this.myName, documentAssignable.asDocument(), bl);
        if (Durability.NONE.equals(durability)) {
            this.myClient.send(delete, null);
            callback.callback(-1L);
        } else {
            this.myClient.send(delete, this.asGetLastError(durability), new ReplyLongCallback(callback));
        }
    }

    @Override
    public void distinctAsync(Callback<ArrayElement> callback, Distinct distinct) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("distinct", this.getName());
        documentBuilder.addString("key", distinct.getKey());
        if (distinct.getQuery() != null) {
            documentBuilder.addDocument("query", distinct.getQuery());
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, distinct.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), documentBuilder.build(), readPreference);
        this.myClient.send(command, new ReplyArrayCallback(callback));
    }

    @Override
    public boolean drop() {
        Document document = this.myDatabase.runCommand("drop", this.myName, null);
        List<NumericElement> list = document.find(NumericElement.class, "ok");
        return list.size() > 0 && list.get(0).getIntValue() > 0;
    }

    @Override
    public boolean dropIndex(String string) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("index", string);
        Document document = this.myDatabase.runCommand("deleteIndexes", this.myName, (DocumentAssignable)documentBuilder.build());
        List<NumericElement> list = document.find(NumericElement.class, "ok");
        return list.size() > 0 && list.get(0).getIntValue() > 0;
    }

    @Override
    public void explainAsync(Callback<Document> callback, Find find) throws MongoDbException {
        ReadPreference readPreference = find.getReadPreference();
        if (readPreference == null) {
            readPreference = this.getReadPreference();
        }
        Document document = !readPreference.isLegacy() && this.myClient.getClusterType() == ClusterType.SHARDED ? find.toQueryRequest(true, readPreference) : find.toQueryRequest(true);
        Query query = new Query(this.getDatabaseName(), this.myName, document, find.getReturnFields(), find.getBatchSize(), find.getLimit(), find.getNumberToSkip(), false, readPreference, false, false, false, find.isPartialOk());
        this.myClient.send(query, new QueryOneCallback(callback));
    }

    @Override
    public void findAndModifyAsync(Callback<Document> callback, FindAndModify findAndModify) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("findAndModify", this.getName());
        documentBuilder.addDocument("query", findAndModify.getQuery());
        if (findAndModify.getUpdate() != null) {
            documentBuilder.addDocument("update", findAndModify.getUpdate());
        }
        if (findAndModify.getSort() != null) {
            documentBuilder.addDocument("sort", findAndModify.getSort());
        }
        if (findAndModify.getFields() != null) {
            documentBuilder.addDocument("fields", findAndModify.getFields());
        }
        if (findAndModify.isRemove()) {
            documentBuilder.addBoolean("remove", true);
        }
        if (findAndModify.isReturnNew()) {
            documentBuilder.addBoolean("new", true);
        }
        if (findAndModify.isUpsert()) {
            documentBuilder.addBoolean("upsert", true);
        }
        Command command = new Command(this.getDatabaseName(), documentBuilder.build());
        this.myClient.send(command, new ReplyDocumentCallback(callback));
    }

    @Override
    public void findAsync(Callback<MongoIterator<Document>> callback, Find find) throws MongoDbException {
        Query query = this.createQuery(find, find.getLimit(), find.getBatchSize(), find.isTailable(), find.isAwaitData(), find.isImmortalCursor());
        QueryCallback queryCallback = new QueryCallback(this.myClient, query, callback);
        String string = this.myClient.send(query, queryCallback);
        queryCallback.setAddress(string);
    }

    @Override
    public void findOneAsync(Callback<Document> callback, Find find) throws MongoDbException {
        Query query = this.createQuery(find, 1, 1, false, false, false);
        this.myClient.send(query, new QueryOneCallback(callback));
    }

    @Override
    public void groupByAsync(Callback<ArrayElement> callback, GroupBy groupBy) throws MongoDbException {
        DocumentAssignable documentAssignable;
        DocumentBuilder documentBuilder = BuilderFactory.start();
        DocumentBuilder documentBuilder2 = documentBuilder.push("group");
        documentBuilder2.addString("ns", this.getName());
        if (!groupBy.getKeys().isEmpty()) {
            documentAssignable = documentBuilder2.push("key");
            for (String string : groupBy.getKeys()) {
                documentAssignable.addBoolean(string, true);
            }
        }
        if (groupBy.getKeyFunction() != null) {
            documentBuilder2.addJavaScript("$keyf", groupBy.getKeyFunction());
        }
        if (groupBy.getInitialValue() != null) {
            documentBuilder2.addDocument("initial", groupBy.getInitialValue());
        }
        if (groupBy.getReduceFunction() != null) {
            documentBuilder2.addJavaScript("$reduce", groupBy.getReduceFunction());
        }
        if (groupBy.getFinalizeFunction() != null) {
            documentBuilder2.addJavaScript("finalize", groupBy.getFinalizeFunction());
        }
        if (groupBy.getQuery() != null) {
            documentBuilder2.addDocument("cond", groupBy.getQuery());
        }
        documentAssignable = this.updateReadPreference(documentBuilder2, groupBy.getReadPreference(), false);
        Command command = new Command(this.getDatabaseName(), documentBuilder.build(), (ReadPreference)documentAssignable);
        this.myClient.send(command, new ReplyArrayCallback("retval", callback));
    }

    @Override
    public void insertAsync(Callback<Integer> callback, boolean bl, Durability durability, DocumentAssignable ... documentAssignableArray) throws MongoDbException {
        ArrayList<Document> arrayList = new ArrayList<Document>(documentAssignableArray.length);
        for (DocumentAssignable documentAssignable : documentAssignableArray) {
            Document document = documentAssignable.asDocument();
            if (!document.contains(ID_FIELD_NAME) && document instanceof RootDocument) {
                ((RootDocument)document).injectId();
            }
            arrayList.add(document);
        }
        Insert insert = new Insert(this.getDatabaseName(), this.myName, arrayList, bl);
        if (Durability.NONE == durability) {
            this.myClient.send(insert, null);
            callback.callback(-1);
        } else {
            this.myClient.send(insert, this.asGetLastError(durability), new ReplyIntegerCallback(callback));
        }
    }

    @Override
    public boolean isCapped() throws MongoDbException {
        Document document = this.stats();
        NumericElement numericElement = document.get(NumericElement.class, "capped");
        if (numericElement != null) {
            return numericElement.getIntValue() != 0;
        }
        BooleanElement booleanElement = document.get(BooleanElement.class, "capped");
        if (booleanElement != null) {
            return booleanElement.getValue();
        }
        return false;
    }

    @Override
    public void mapReduceAsync(Callback<List<Document>> callback, MapReduce mapReduce) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("mapreduce", this.getName());
        documentBuilder.addJavaScript("map", mapReduce.getMapFunction());
        documentBuilder.addJavaScript("reduce", mapReduce.getReduceFunction());
        if (mapReduce.getFinalizeFunction() != null) {
            documentBuilder.addJavaScript("finalize", mapReduce.getFinalizeFunction());
        }
        if (mapReduce.getQuery() != null) {
            documentBuilder.addDocument("query", mapReduce.getQuery());
        }
        if (mapReduce.getSort() != null) {
            documentBuilder.addDocument("sort", mapReduce.getSort());
        }
        if (mapReduce.getScope() != null) {
            documentBuilder.addDocument("scope", mapReduce.getScope());
        }
        if (mapReduce.getLimit() != 0) {
            documentBuilder.addInteger("limit", mapReduce.getLimit());
        }
        if (mapReduce.isKeepTemp()) {
            documentBuilder.addBoolean("keeptemp", true);
        }
        if (mapReduce.isJsMode()) {
            documentBuilder.addBoolean("jsMode", true);
        }
        if (mapReduce.isVerbose()) {
            documentBuilder.addBoolean("verbose", true);
        }
        DocumentBuilder documentBuilder2 = documentBuilder.push("out");
        switch (mapReduce.getOutputType()) {
            case INLINE: {
                documentBuilder2.addInteger("inline", 1);
                break;
            }
            case REPLACE: {
                documentBuilder2.addString("replace", mapReduce.getOutputName());
                if (mapReduce.getOutputDatabase() == null) break;
                documentBuilder2.addString("db", mapReduce.getOutputDatabase());
                break;
            }
            case MERGE: {
                documentBuilder2.addString("merge", mapReduce.getOutputName());
                if (mapReduce.getOutputDatabase() == null) break;
                documentBuilder2.addString("db", mapReduce.getOutputDatabase());
                break;
            }
            case REDUCE: {
                documentBuilder2.addString("reduce", mapReduce.getOutputName());
                if (mapReduce.getOutputDatabase() == null) break;
                documentBuilder2.addString("db", mapReduce.getOutputDatabase());
            }
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, mapReduce.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), documentBuilder.build(), readPreference);
        this.myClient.send(command, new ReplyResultCallback(callback));
    }

    @Override
    public void saveAsync(Callback<Integer> callback, DocumentAssignable documentAssignable, Durability durability) throws MongoDbException {
        Document document = documentAssignable.asDocument();
        if (document.contains(ID_FIELD_NAME)) {
            this.updateAsync(new LongToIntCallback(callback), BuilderFactory.start().add(document.get(ID_FIELD_NAME)), document, false, true, durability);
        } else {
            this.insertAsync(callback, durability, document);
        }
    }

    @Override
    public Document stats() throws MongoDbException {
        return this.myDatabase.runCommand("collStats", this.getName(), null);
    }

    @Override
    public MongoCursorControl streamingFind(StreamCallback<Document> streamCallback, Find find) throws MongoDbException {
        Query query = this.createQuery(find, find.getLimit(), find.getBatchSize(), find.isTailable(), find.isAwaitData(), find.isImmortalCursor());
        QueryStreamingCallback queryStreamingCallback = new QueryStreamingCallback(this.myClient, query, streamCallback);
        String string = this.myClient.send(query, queryStreamingCallback);
        queryStreamingCallback.setAddress(string);
        return queryStreamingCallback;
    }

    @Override
    public void textSearchAsync(Callback<List<TextResult>> callback, Text text) throws MongoDbException {
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.addString("text", this.getName());
        documentBuilder.addString("search", text.getSearchTerm());
        if (text.getQuery() != null) {
            documentBuilder.add("filter", text.getQuery());
        }
        if (text.getLimit() > 0) {
            documentBuilder.add("limit", text.getLimit());
        }
        if (text.getReturnFields() != null) {
            documentBuilder.add("project", text.getReturnFields());
        }
        if (text.getLanguage() != null) {
            documentBuilder.add("language", text.getLanguage());
        }
        ReadPreference readPreference = this.updateReadPreference(documentBuilder, text.getReadPreference(), true);
        Command command = new Command(this.getDatabaseName(), documentBuilder.build(), readPreference);
        this.myClient.send(command, new ReplyResultCallback(new TextCallback(callback)));
    }

    @Override
    public void updateAsync(Callback<Long> callback, DocumentAssignable documentAssignable, DocumentAssignable documentAssignable2, boolean bl, boolean bl2, Durability durability) throws MongoDbException {
        Update update = new Update(this.getDatabaseName(), this.myName, documentAssignable.asDocument(), documentAssignable2.asDocument(), bl, bl2);
        if (Durability.NONE == durability) {
            this.myClient.send(update, null);
            callback.callback(-1L);
        } else {
            this.myClient.send(update, this.asGetLastError(durability), new ReplyLongCallback(callback));
        }
    }

    @Override
    public Document updateOptions(DocumentAssignable documentAssignable) throws MongoDbException {
        return this.myDatabase.runCommand("collMod", this.getName(), (DocumentAssignable)documentAssignable.asDocument());
    }

    @Override
    public Document validate(MongoCollection.ValidateMode validateMode) throws MongoDbException {
        Document document = null;
        switch (validateMode) {
            case INDEX_ONLY: {
                document = this.myDatabase.runCommand("validate", this.getName(), (DocumentAssignable)BuilderFactory.start().add("scandata", false).build());
                break;
            }
            case NORMAL: {
                document = this.myDatabase.runCommand("validate", this.getName(), null);
                break;
            }
            case FULL: {
                document = this.myDatabase.runCommand("validate", this.getName(), (DocumentAssignable)BuilderFactory.start().add("full", true).build());
            }
        }
        return document;
    }

    protected Query createQuery(Find find, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        ReadPreference readPreference = find.getReadPreference();
        if (readPreference == null) {
            readPreference = this.getReadPreference();
        }
        Document document = !readPreference.isLegacy() && this.myClient.getClusterType() == ClusterType.SHARDED ? find.toQueryRequest(false, readPreference) : find.toQueryRequest(false);
        return new Query(this.getDatabaseName(), this.myName, document, find.getReturnFields(), n2, n, find.getNumberToSkip(), bl, readPreference, bl3, bl2, false, find.isPartialOk());
    }

    protected ReadPreference updateReadPreference(DocumentBuilder documentBuilder, ReadPreference readPreference, boolean bl) {
        ReadPreference readPreference2 = readPreference;
        if (readPreference2 == null) {
            readPreference2 = this.getReadPreference();
        }
        if (!readPreference2.isLegacy() && this.myClient.getClusterType() == ClusterType.SHARDED) {
            if (bl) {
                Document document = documentBuilder.asDocument();
                documentBuilder.reset();
                documentBuilder.add("$query", document);
            }
            documentBuilder.add("$readPreference", readPreference2);
        }
        return readPreference2;
    }
}

