/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.client.Client;
import com.allanbank.mongodb.client.MongoIteratorImpl;
import com.allanbank.mongodb.connection.message.Query;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.concurrent.atomic.AtomicBoolean;

final class QueryCallback
extends AbstractReplyCallback<MongoIterator<Document>> {
    private volatile String myAddress;
    private final Client myClient;
    private final Query myQueryMessage;
    private volatile Reply myReply;
    private final AtomicBoolean mySetOther;

    public QueryCallback(Client client, Query query, Callback<MongoIterator<Document>> callback) {
        super(callback);
        this.myClient = client;
        this.myQueryMessage = query;
        this.mySetOther = new AtomicBoolean(false);
    }

    public String getAddress() {
        return this.myAddress;
    }

    public void setAddress(String string) {
        this.myAddress = string;
        this.trigger();
    }

    @Override
    protected MongoDbException asError(Reply reply, int n, int n2, String string) {
        return new ReplyException(n, n2, string, this.myQueryMessage, reply);
    }

    @Override
    protected MongoIterator<Document> convert(Reply reply) throws MongoDbException {
        return new MongoIteratorImpl(this.myQueryMessage, this.myClient, this.myAddress, reply);
    }

    @Override
    protected void handle(Reply reply) {
        this.myReply = reply;
        this.trigger();
    }

    private void trigger() {
        if (!this.mySetOther.compareAndSet(false, true)) {
            super.handle(this.myReply);
        }
    }
}

