/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.element.ArrayElement;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.List;

class ReplyArrayCallback
extends AbstractReplyCallback<ArrayElement> {
    public static final String DEFAULT_NAME = "values";
    private final String myName;

    public ReplyArrayCallback(Callback<ArrayElement> callback) {
        this(DEFAULT_NAME, callback);
    }

    public ReplyArrayCallback(String string, Callback<ArrayElement> callback) {
        super(callback);
        this.myName = string;
    }

    @Override
    protected MongoDbException asError(Reply reply) {
        MongoDbException mongoDbException = super.asError(reply);
        if (mongoDbException == null) {
            List<Document> list = reply.getResults();
            if (list.size() != 1) {
                mongoDbException = new ReplyException(reply, "Should only be a single document in the reply.");
            } else if (reply.getResults().get(0).find(ArrayElement.class, this.myName).isEmpty()) {
                mongoDbException = new ReplyException(reply, "No '" + this.myName + "' array in the reply.");
            }
        }
        return mongoDbException;
    }

    @Override
    protected ArrayElement convert(Reply reply) throws MongoDbException {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            return list.get(0).find(ArrayElement.class, this.myName).get(0);
        }
        return null;
    }
}

