/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.List;

class ReplyCallback
extends AbstractReplyCallback<Document> {
    public ReplyCallback(Callback<Document> callback) {
        super(callback);
    }

    @Override
    protected MongoDbException asError(Reply reply) {
        List<Document> list;
        MongoDbException mongoDbException = super.asError(reply);
        if (mongoDbException == null && (list = reply.getResults()).size() != 1) {
            mongoDbException = new ReplyException(reply, "Should only be a single document in the reply.");
        }
        return mongoDbException;
    }

    @Override
    protected Document convert(Reply reply) throws MongoDbException {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }
}

