/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.List;

class ReplyCommandCallback
extends AbstractReplyCallback<Document> {
    public ReplyCommandCallback(Callback<Document> callback) {
        super(callback);
    }

    @Override
    protected MongoDbException asError(Reply reply) {
        List<Document> list;
        MongoDbException mongoDbException = super.asError(reply);
        if (mongoDbException == null && (list = reply.getResults()).size() != 1) {
            mongoDbException = new ReplyException(reply, "Should only be a single document in the reply.");
        }
        return mongoDbException;
    }

    @Override
    protected MongoDbException asError(Reply reply, boolean bl) {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            Document document = list.get(0);
            Element element = document.get("ok");
            Element element2 = document.get("code");
            Element element3 = null;
            for (int i = 0; element3 == null && i < ERROR_MESSAGE_FIELDS.size(); ++i) {
                element3 = document.get((String)ERROR_MESSAGE_FIELDS.get(i));
            }
            if (element == null && bl) {
                return this.asError(reply, -1, this.toInt(element2), this.asString(element3));
            }
        }
        return null;
    }

    @Override
    protected Document convert(Reply reply) throws MongoDbException {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }
}

