/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.List;

class ReplyDocumentCallback
extends AbstractReplyCallback<Document> {
    public static final String DEFAULT_NAME = "value";
    private final String myName;

    public ReplyDocumentCallback(Callback<Document> callback) {
        this(DEFAULT_NAME, callback);
    }

    public ReplyDocumentCallback(String string, Callback<Document> callback) {
        super(callback);
        this.myName = string;
    }

    @Override
    protected MongoDbException asError(Reply reply) {
        MongoDbException mongoDbException = super.asError(reply);
        if (mongoDbException == null) {
            List<Document> list = reply.getResults();
            if (list.size() != 1) {
                mongoDbException = new ReplyException(reply, "Should only be a single document in the reply.");
            } else if (reply.getResults().get(0).get(this.myName) == null) {
                mongoDbException = new ReplyException(reply, "No '" + this.myName + "' document in the reply.");
            }
        }
        return mongoDbException;
    }

    @Override
    protected Document convert(Reply reply) throws MongoDbException {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            DocumentElement documentElement = list.get(0).get(DocumentElement.class, this.myName);
            if (documentElement == null) {
                return null;
            }
            return documentElement.getDocument();
        }
        return null;
    }
}

