/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.ReplyException;
import java.util.List;

class ReplyLongCallback
extends AbstractReplyCallback<Long> {
    public static final String DEFAULT_NAME = "n";
    private final String myName;

    public ReplyLongCallback(Callback<Long> callback) {
        this(DEFAULT_NAME, callback);
    }

    public ReplyLongCallback(String string, Callback<Long> callback) {
        super(callback);
        this.myName = string;
    }

    @Override
    protected MongoDbException asError(Reply reply) {
        Document document;
        Element element;
        List<Document> list;
        MongoDbException mongoDbException = super.asError(reply);
        if (mongoDbException == null && (list = reply.getResults()).size() == 1 && !((element = (document = list.get(0)).get(this.myName)) instanceof NumericElement)) {
            mongoDbException = new ReplyException(reply, "Missing '" + this.myName + "' field in reply.");
        }
        return mongoDbException;
    }

    @Override
    protected Long convert(Reply reply) throws MongoDbException {
        List<Document> list = reply.getResults();
        if (list.size() == 1) {
            Document document = list.get(0);
            Element element = document.get(this.myName);
            return this.toLong(element);
        }
        return -1L;
    }

    protected long toLong(Element element) {
        if (element instanceof NumericElement) {
            return ((NumericElement)element).getLongValue();
        }
        return -1L;
    }
}

